/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.ChunkMapReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.TopicRefWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class ChunkModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;
    final Map<String, String> relativePath2fix = new HashMap<String, String>();

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        File tempDir = new File(input.getAttribute("tempDir"));
        String ditaext = input.getAttribute("ditaext") != null ? input.getAttribute("ditaext") : ".dita";
        String transtype = input.getAttribute("transtype");
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        ChunkMapReader mapReader = new ChunkMapReader();
        mapReader.setLogger(this.logger);
        mapReader.setup(ditaext, transtype);
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (IOException ioe) {
            throw new DITAOTException(ioe);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            String mapFile = new File(tempDir, job.getProperty("user.input.file")).getAbsolutePath();
            Document doc = builder.parse(new File(mapFile));
            Element root = doc.getDocumentElement();
            if (root.getAttribute("class").contains(" eclipsemap/plugin ") && transtype.equals("eclipsehelp")) {
                for (String ditaMap : job.getSet("fullditamaplist")) {
                    mapFile = new File(tempDir, ditaMap).getAbsolutePath();
                    mapReader.read(mapFile);
                }
            } else {
                mapReader.read(mapFile);
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        Map<String, String> changeTable = mapReader.getChangeTable();
        if (changeTable != null) {
            this.updateList(changeTable, mapReader.getConflicTable(), input);
            this.updateRefOfDita(changeTable, mapReader.getConflicTable(), input);
        }
        return null;
    }

    private void updateRefOfDita(Map<String, String> changeTable, Hashtable<String, String> conflictTable, AbstractPipelineInput input) {
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (IOException io) {
            this.logger.logError(io.getMessage());
        }
        TopicRefWriter topicRefWriter = new TopicRefWriter();
        topicRefWriter.setLogger(this.logger);
        topicRefWriter.setChangeTable(changeTable);
        topicRefWriter.setup(conflictTable);
        try {
            for (String f : job.getSet("fullditamapandtopiclist")) {
                topicRefWriter.write(tempDir.getAbsolutePath(), f, this.relativePath2fix);
            }
        }
        catch (DITAOTException ex) {
            this.logger.logError(ex.getMessage(), ex);
        }
    }

    private void updateList(Map<String, String> changeTable, Hashtable<String, String> conflictTable, AbstractPipelineInput input) {
        String oldFile;
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        File xmlDitalist = new File(tempDir, "dummy.xml");
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (IOException ex) {
            this.logger.logError(ex.getMessage(), ex);
        }
        Set<String> hrefTopics = job.getSet("canditopicslist");
        Set<String> chunkTopics = job.getSet("skipchunklist");
        for (String s : chunkTopics) {
            if (!StringUtils.isEmptyString(s) && !s.contains("#")) {
                Iterator<String> hrefit = hrefTopics.iterator();
                while (hrefit.hasNext()) {
                    String ent = hrefit.next();
                    if (!FileUtils.resolveFile(tempDir.getAbsolutePath(), ent).equalsIgnoreCase(FileUtils.resolveFile(tempDir.getAbsolutePath(), s))) continue;
                    hrefit.remove();
                }
                continue;
            }
            if (StringUtils.isEmptyString(s) || !hrefTopics.contains(s)) continue;
            hrefTopics.remove(s);
        }
        LinkedHashSet<String> topicList = new LinkedHashSet<String>(128);
        Set<String> oldTopicList = job.getSet("fullditatopiclist");
        for (String t : hrefTopics) {
            if (t.lastIndexOf("#") != -1) {
                t = t.substring(0, t.lastIndexOf("#"));
            }
            t = FileUtils.getRelativePath(xmlDitalist.getAbsolutePath(), FileUtils.resolveFile(tempDir.getAbsolutePath(), t));
            topicList.add(t);
            if (!oldTopicList.contains(t)) continue;
            oldTopicList.remove(t);
        }
        LinkedHashSet<String> chunkedTopicSet = new LinkedHashSet<String>(128);
        LinkedHashSet<String> chunkedDitamapSet = new LinkedHashSet<String>(128);
        Set<String> ditamapList = job.getSet("fullditamaplist");
        for (Map.Entry<String, String> entry : changeTable.entrySet()) {
            oldFile = entry.getKey();
            if (!entry.getValue().equals(oldFile)) continue;
            String newChunkedFile = entry.getValue();
            newChunkedFile = FileUtils.getRelativePath(xmlDitalist.getAbsolutePath(), newChunkedFile);
            String extName = FileUtils.getExtension(newChunkedFile);
            if (extName != null && !extName.equalsIgnoreCase("DITAMAP")) {
                chunkedTopicSet.add(newChunkedFile);
                if (topicList.contains(newChunkedFile)) continue;
                topicList.add(newChunkedFile);
                if (!oldTopicList.contains(newChunkedFile)) continue;
                oldTopicList.remove(newChunkedFile);
                continue;
            }
            if (!ditamapList.contains(newChunkedFile)) {
                ditamapList.add(newChunkedFile);
                if (oldTopicList.contains(newChunkedFile)) {
                    oldTopicList.remove(newChunkedFile);
                }
            }
            chunkedDitamapSet.add(newChunkedFile);
        }
        for (String string : oldTopicList) {
            File f;
            if (StringUtils.isEmptyString(string) || !(f = new File(tempDir, string)).exists()) continue;
            f.delete();
        }
        for (Map.Entry entry : changeTable.entrySet()) {
            String targetPath;
            oldFile = (String)entry.getKey();
            if (!((String)entry.getValue()).equals(oldFile) || (targetPath = conflictTable.get(entry.getKey())) == null) continue;
            File target = new File(targetPath);
            if (!FileUtils.fileExists(target.getAbsolutePath())) {
                File from = new File((String)entry.getValue());
                String relativePath = FileUtils.getRelativePath(xmlDitalist.getAbsolutePath(), from.getAbsolutePath());
                String relativeTargetPath = FileUtils.getRelativePath(xmlDitalist.getAbsolutePath(), target.getAbsolutePath());
                if (relativeTargetPath.lastIndexOf("/") != -1) {
                    this.relativePath2fix.put(relativeTargetPath, relativeTargetPath.substring(0, relativeTargetPath.lastIndexOf("/") + 1));
                }
                target.delete();
                from.renameTo(target);
                if (topicList.contains(relativePath)) {
                    topicList.remove(relativePath);
                }
                if (chunkedTopicSet.contains(relativePath)) {
                    chunkedTopicSet.remove(relativePath);
                }
                relativePath = FileUtils.getRelativePath(xmlDitalist.getAbsolutePath(), target.getAbsolutePath());
                topicList.add(relativePath);
                chunkedTopicSet.add(relativePath);
                continue;
            }
            conflictTable.remove(entry.getKey());
        }
        Set<String> resourceOnlySet = job.getSet("resourceonlylist");
        resourceOnlySet.removeAll(chunkedTopicSet);
        resourceOnlySet.removeAll(chunkedDitamapSet);
        job.setSet("resourceonlylist", resourceOnlySet);
        job.setSet("fullditatopiclist", topicList);
        job.setSet("fullditamaplist", ditamapList);
        topicList.addAll(ditamapList);
        job.setSet("fullditamapandtopiclist", topicList);
        job.setProperty("chunkedditamapfile", "chunkedditamap.list");
        job.setProperty("chunkedtopicfile", "chunkedtopic.list");
        job.setProperty("resourceonlyfile", "resourceonly.list");
        job.setSet("chunkedditamaplist", chunkedDitamapSet);
        job.setSet("chunkedtopiclist", chunkedTopicSet);
        try {
            job.write();
        }
        catch (IOException iOException) {
            this.logger.logError(iOException.getMessage(), iOException);
        }
    }
}

