/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.ConrefPushReader;
import org.dita.dost.util.Job;
import org.dita.dost.writer.ConrefPushParser;

final class ConrefPushModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;

    ConrefPushModule() {
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        Set<String> conrefpushlist = job.getSet("conrefpushlist");
        ConrefPushReader reader = new ConrefPushReader();
        reader.setLogger(this.logger);
        for (String fileName : conrefpushlist) {
            File file = new File(tempDir, fileName);
            this.logger.logInfo("Reading  " + file.getAbsolutePath());
            reader.read(file.getAbsolutePath());
        }
        Map<String, Hashtable<String, String>> pushSet = reader.getPushMap();
        for (Map.Entry<String, Hashtable<String, String>> entry : pushSet.entrySet()) {
            this.logger.logInfo("Processing " + new File(tempDir, entry.getKey()).getAbsolutePath());
            ConrefPushParser parser = new ConrefPushParser();
            parser.setLogger(this.logger);
            ContentImpl content = new ContentImpl();
            content.setValue(entry.getValue());
            parser.setContent(content);
            parser.setTempDir(tempDir.getAbsolutePath());
            parser.write(entry.getKey());
        }
        return null;
    }
}

