/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DelayConrefUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.TimingUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.DitaWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

final class DebugAndFilterModule
implements AbstractPipelineModule {
    private static final String SUBJECT_SCHEME_EXTENSION = ".subm";
    private String extName = null;
    private File tempDir = null;
    private final OutputUtils outputUtils = new OutputUtils();
    private DITAOTLogger logger;
    private File inputMap = null;
    private File ditaDir = null;
    private File inputDir = null;
    private final boolean setSystemid = true;

    private void updatePropertyMap(String listName, Job property) {
        Map<String, String> propValues = property.getMap(listName);
        if (propValues == null || propValues.isEmpty()) {
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> e : propValues.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (!".ditamap".equals("." + FileUtils.getExtension(value)) && this.extName != null) {
                key = FileUtils.replaceExtension(key, this.extName);
                value = FileUtils.replaceExtension(value, this.extName);
            }
            result.put(key, value);
        }
        property.setMap(listName, result);
    }

    private void updatePropertySet(String listName, Job property) {
        Set<String> propValues = property.getSet(listName);
        if (propValues == null || propValues.isEmpty()) {
            return;
        }
        HashSet<String> result = new HashSet<String>(propValues.size());
        Iterator<String> i$ = propValues.iterator();
        while (i$.hasNext()) {
            String file;
            String f = file = i$.next();
            if (!".ditamap".equals("." + FileUtils.getExtension(file)) && this.extName != null) {
                f = FileUtils.replaceExtension(f, this.extName);
            }
            result.add(f);
        }
        property.setSet(listName, result);
    }

    private void updatePropertyString(String listName, Job property) {
        String propValue = property.getProperty(listName);
        if (propValue == null || propValue.trim().length() == 0) {
            return;
        }
        if (!".ditamap".equals("." + FileUtils.getExtension(propValue)) && this.extName != null) {
            propValue = FileUtils.replaceExtension(propValue, this.extName);
        }
        property.setProperty(listName, propValue);
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        Date executeStartTime = TimingUtils.getNowTime();
        this.logger.logInfo("DebugAndFilterModule.execute(): Starting...");
        try {
            String baseDir = input.getAttribute("basedir");
            this.tempDir = new File(input.getAttribute("tempDir"));
            if (!this.tempDir.isAbsolute()) {
                throw new IllegalArgumentException("Temporary directory " + this.tempDir + " must be absolute");
            }
            this.ditaDir = new File(input.getAttribute("ditadir"));
            String transtype = input.getAttribute("transtype");
            String ext = input.getAttribute("ditaext");
            if (ext != null) {
                this.extName = ext.startsWith(".") ? ext : "." + ext;
            }
            File ditavalFile = null;
            if (input.getAttribute("ditaval") != null && !(ditavalFile = new File(input.getAttribute("ditaval"))).isAbsolute()) {
                ditavalFile = new File(baseDir, ditavalFile.getPath()).getAbsoluteFile();
            }
            Job job = new Job(this.tempDir);
            HashSet<String> parseList = new HashSet<String>();
            parseList.addAll(job.getSet("fullditamapandtopiclist"));
            parseList.addAll(job.getSet("conreftargetslist"));
            parseList.addAll(job.getSet("copytosourcelist"));
            this.inputDir = new File(job.getInputDir());
            if (!this.inputDir.isAbsolute()) {
                this.inputDir = new File(baseDir, this.inputDir.getPath()).getAbsoluteFile();
            }
            this.inputMap = new File(this.inputDir, job.getInputMap()).getAbsoluteFile();
            this.outputSubjectScheme();
            DitaValReader filterReader = new DitaValReader();
            filterReader.setLogger(this.logger);
            filterReader.initXMLReader("yes".equals(input.getAttribute("setsystemid")));
            FilterUtils filterUtils = null;
            if (ditavalFile != null) {
                filterUtils = new FilterUtils();
                filterUtils.setLogger(this.logger);
                filterReader.read(ditavalFile.getAbsolutePath());
                filterUtils.setFilterMap(filterReader.getFilterMap());
            }
            SubjectSchemeReader subjectSchemeReader = new SubjectSchemeReader();
            subjectSchemeReader.setLogger(this.logger);
            DitaWriter fileWriter = new DitaWriter();
            fileWriter.setLogger(this.logger);
            try {
                boolean xmlValidate = Boolean.valueOf(input.getAttribute("validate"));
                fileWriter.initXMLReader(this.ditaDir.getAbsoluteFile(), xmlValidate, true);
            }
            catch (SAXException e) {
                throw new DITAOTException(e.getMessage(), e);
            }
            fileWriter.setTempDir(this.tempDir);
            fileWriter.setExtName(this.extName);
            fileWriter.setTranstype(transtype);
            if (filterUtils != null) {
                fileWriter.setFilterUtils(filterUtils);
            }
            fileWriter.setDelayConrefUtils(new DelayConrefUtils());
            fileWriter.setKeyDefinitions(KeyDef.readKeydef(new File(this.tempDir, "keydef.xml")));
            this.outputUtils.setGeneratecopyouter(input.getAttribute("generatecopyouter"));
            this.outputUtils.setOutterControl(input.getAttribute("outercontrol"));
            this.outputUtils.setOnlyTopicInMap(input.getAttribute("onlytopicinmap"));
            this.outputUtils.setInputMapPathName(this.inputMap);
            this.outputUtils.setOutputDir(new File(input.getAttribute("outputdir")));
            fileWriter.setOutputUtils(this.outputUtils);
            Map<String, Set<String>> dic = this.readMapFromXML("subject_scheme.dictionary");
            for (String filename : parseList) {
                File currentFile = new File(this.inputDir, filename);
                this.logger.logInfo("Processing " + currentFile.getAbsolutePath());
                Set<String> schemaSet = dic.get(filename);
                filterReader.reset();
                if (schemaSet != null) {
                    subjectSchemeReader.reset();
                    FilterUtils fu = new FilterUtils();
                    fu.setLogger(this.logger);
                    for (String schema : schemaSet) {
                        subjectSchemeReader.loadSubjectScheme(FileUtils.resolveFile(this.tempDir.getAbsolutePath(), schema) + SUBJECT_SCHEME_EXTENSION);
                    }
                    if (ditavalFile != null) {
                        filterReader.filterReset();
                        filterReader.setSubjectScheme(subjectSchemeReader.getSubjectSchemeMap());
                        filterReader.read(ditavalFile.getAbsolutePath());
                        HashMap<FilterUtils.FilterKey, FilterUtils.Action> fm = new HashMap<FilterUtils.FilterKey, FilterUtils.Action>();
                        fm.putAll(filterReader.getFilterMap());
                        fm.putAll(filterUtils.getFilterMap());
                        fu.setFilterMap(Collections.unmodifiableMap(fm));
                    } else {
                        fu.setFilterMap(null);
                    }
                    fileWriter.setFilterUtils(fu);
                    fileWriter.setValidateMap(subjectSchemeReader.getValidValuesMap());
                    fileWriter.setDefaultValueMap(subjectSchemeReader.getDefaultValueMap());
                } else {
                    fileWriter.setFilterUtils(filterUtils);
                }
                if (!new File(this.inputDir, filename).exists()) {
                    this.logger.logInfo("Ignoring a copy-to file " + filename);
                    continue;
                }
                fileWriter.write(this.inputDir, filename);
            }
            if (this.extName != null) {
                this.updateList(this.tempDir);
            }
            this.updateDictionary(this.tempDir);
            this.performCopytoTask(this.tempDir, new Job(this.tempDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DITAOTException("Exception doing debug and filter module processing: " + e.getMessage(), e);
        }
        finally {
            this.logger.logInfo("Execution time: " + TimingUtils.reportElapsedTime(executeStartTime));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> readMapFromXML(String filename) {
        File inputFile = new File(this.tempDir, filename);
        HashMap<String, Set<String>> graph = new HashMap<String, Set<String>>();
        if (!inputFile.exists()) {
            return graph;
        }
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFile);
            prop.loadFromXML(in);
            in.close();
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            graph.put(key, StringUtils.restoreSet(value, ","));
        }
        return Collections.unmodifiableMap(graph);
    }

    private void outputSubjectScheme() throws DITAOTException {
        Map<String, Set<String>> graph = this.readMapFromXML("subrelation.xml");
        LinkedList<String> queue = new LinkedList<String>();
        HashSet<String> visitedSet = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : graph.entrySet()) {
            queue.offer(entry.getKey());
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
            while (!queue.isEmpty()) {
                String parent = (String)queue.poll();
                Set<String> children = graph.get(parent);
                if (children != null) {
                    queue.addAll(children);
                }
                if ("ROOT".equals(parent) || visitedSet.contains(parent)) continue;
                visitedSet.add(parent);
                String tmprel = FileUtils.getRelativePath(this.inputMap.getAbsolutePath(), parent);
                tmprel = FileUtils.resolveFile(this.tempDir.getAbsolutePath(), tmprel) + SUBJECT_SCHEME_EXTENSION;
                Document parentRoot = null;
                parentRoot = !FileUtils.fileExists(tmprel) ? builder.parse(new InputSource(new FileInputStream(parent))) : builder.parse(new InputSource(new FileInputStream(tmprel)));
                if (children != null) {
                    for (String childpath : children) {
                        Document childRoot = builder.parse(new InputSource(new FileInputStream(childpath)));
                        this.mergeScheme(parentRoot, childRoot);
                        String rel = FileUtils.getRelativePath(this.inputMap.getAbsolutePath(), childpath);
                        rel = FileUtils.resolveFile(this.tempDir.getAbsolutePath(), rel) + SUBJECT_SCHEME_EXTENSION;
                        this.generateScheme(rel, childRoot);
                    }
                }
                String rel = FileUtils.getRelativePath(this.inputMap.getAbsolutePath(), parent);
                rel = FileUtils.resolveFile(this.tempDir.getAbsolutePath(), rel) + SUBJECT_SCHEME_EXTENSION;
                this.generateScheme(rel, parentRoot);
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
            throw new DITAOTException(e);
        }
    }

    private void mergeScheme(Document parentRoot, Document childRoot) {
        LinkedList<Element> pQueue = new LinkedList<Element>();
        pQueue.offer(parentRoot.getDocumentElement());
        while (!pQueue.isEmpty()) {
            Node tmpnode;
            int i;
            Element target;
            Element pe = (Element)pQueue.poll();
            NodeList pList = pe.getChildNodes();
            for (int i2 = 0; i2 < pList.getLength(); ++i2) {
                Node node = pList.item(i2);
                if (node.getNodeType() != 1) continue;
                pQueue.offer((Element)node);
            }
            String value = pe.getAttribute("class");
            if (StringUtils.isEmptyString(value) || !Constants.SUBJECTSCHEME_SUBJECTDEF.matches(value)) continue;
            value = pe.getAttribute("keyref");
            if (!StringUtils.isEmptyString(value)) {
                target = this.searchForKey(childRoot.getDocumentElement(), value);
                if (target == null) continue;
                pList = pe.getChildNodes();
                for (i = 0; i < pList.getLength(); ++i) {
                    tmpnode = childRoot.importNode(pList.item(i), false);
                    if (tmpnode.getNodeType() == 1 && this.searchForKey(target, ((Element)tmpnode).getAttribute("keys")) != null) continue;
                    target.appendChild(tmpnode);
                }
                continue;
            }
            value = pe.getAttribute("keys");
            if (StringUtils.isEmptyString(value) || (target = this.searchForKey(childRoot.getDocumentElement(), value)) == null) continue;
            pList = target.getChildNodes();
            for (i = 0; i < pList.getLength(); ++i) {
                tmpnode = parentRoot.importNode(pList.item(i), false);
                if (tmpnode.getNodeType() == 1 && this.searchForKey(pe, ((Element)tmpnode).getAttribute("keys")) != null) continue;
                pe.appendChild(tmpnode);
            }
        }
    }

    private Element searchForKey(Element root, String key) {
        if (root == null || StringUtils.isEmptyString(key)) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Element pe = (Element)queue.poll();
            NodeList pchildrenList = pe.getChildNodes();
            for (int i = 0; i < pchildrenList.getLength(); ++i) {
                Node node = pchildrenList.item(i);
                if (node.getNodeType() != 1) continue;
                queue.offer((Element)node);
            }
            String value = pe.getAttribute("class");
            if (StringUtils.isEmptyString(value) || !Constants.SUBJECTSCHEME_SUBJECTDEF.matches(value) || StringUtils.isEmptyString(value = pe.getAttribute("keys")) || !value.equals(key)) continue;
            return pe;
        }
        return null;
    }

    private void generateScheme(String filename, Document root) throws DITAOTException {
        try {
            File f = new File(filename);
            File p = f.getParentFile();
            if (!p.exists() && !p.mkdirs()) {
                throw new IOException("Failed to make directory " + p.getAbsolutePath());
            }
            FileOutputStream file = new FileOutputStream(new File(filename));
            StreamResult res = new StreamResult(file);
            DOMSource ds = new DOMSource(root);
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.transform(ds, res);
            if (res.getOutputStream() != null) {
                res.getOutputStream().close();
            }
            if (file != null) {
                file.close();
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
            throw new DITAOTException(e);
        }
    }

    private void performCopytoTask(File tempDir, Job job) {
        Map<String, String> copytoMap = job.getCopytoMap();
        for (Map.Entry<String, String> entry : copytoMap.entrySet()) {
            String copytoTarget = entry.getKey();
            String copytoSource = entry.getValue();
            File srcFile = new File(tempDir, copytoSource);
            File targetFile = new File(tempDir, copytoTarget);
            if (targetFile.exists()) {
                this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTX064W", copytoTarget).toString());
                continue;
            }
            String inputMapInTemp = new File(tempDir + File.separator + job.getInputMap()).getAbsolutePath();
            this.copyFileWithPIReplaced(srcFile, targetFile, copytoTarget, inputMapInTemp);
        }
    }

    public void copyFileWithPIReplaced(File src, File target, String copytoTargetFilename, String inputMapInTemp) {
        if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
            this.logger.logError("Failed to create copy-to target directory " + target.getParentFile().getAbsolutePath());
        }
        DitaWriter dw = new DitaWriter();
        dw.setOutputUtils(this.outputUtils);
        String path2project = dw.getPathtoProject(copytoTargetFilename, target, inputMapInTemp);
        File workdir = target.getParentFile();
        try {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            CopyToFilter filter = new CopyToFilter(StringUtils.getXMLReader(), workdir, path2project);
            serializer.transform(new SAXSource(filter, new InputSource(src.toURI().toString())), new StreamResult(target));
        }
        catch (TransformerConfigurationException e) {
            this.logger.logError("Failed to configure serializer: " + e.getMessage(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            this.logger.logError("Failed to configure serializer: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            this.logger.logError("Failed to create XML parser: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            this.logger.logError("Failed to rewrite copy-to file: " + e.getMessage(), e);
        }
    }

    private void updateList(File tempDir) throws IOException {
        Job job = new Job(tempDir);
        this.updatePropertyString("user.input.file", job);
        this.updatePropertySet("hreftargetslist", job);
        this.updatePropertySet("conreflist", job);
        this.updatePropertySet("hrefditatopiclist", job);
        this.updatePropertySet("fullditatopiclist", job);
        this.updatePropertySet("fullditamapandtopiclist", job);
        this.updatePropertySet("conreftargetslist", job);
        this.updatePropertySet("copytosourcelist", job);
        this.updatePropertyMap("copytotarget2sourcemaplist", job);
        this.updatePropertySet("outditafileslist", job);
        this.updatePropertySet("conrefpushlist", job);
        this.updatePropertySet("keyreflist", job);
        this.updatePropertySet("codereflist", job);
        this.updatePropertySet("skipchunklist", job);
        this.updatePropertySet("canditopicslist", job);
        this.updatePropertySet("resourceonlylist", job);
        job.write();
    }

    private void updateDictionary(File tempDir) {
        Map<String, Set<String>> dic = this.readMapFromXML("subject_scheme.dictionary");
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : dic.entrySet()) {
            String filename = entry.getKey();
            if (this.extName != null && FileUtils.isDITATopicFile(filename)) {
                filename = FileUtils.replaceExtension(filename, this.extName);
            }
            resultMap.put(filename, entry.getValue());
        }
        this.writeMapToXML(resultMap, "subject_scheme.dictionary");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapToXML(Map<String, Set<String>> m, String filename) {
        if (m == null) {
            return;
        }
        Properties prop = new Properties();
        for (Map.Entry<String, Set<String>> entry : m.entrySet()) {
            String key = entry.getKey();
            String value = StringUtils.assembleString(entry.getValue(), ",");
            prop.setProperty(key, value);
        }
        File outputFile = new File(this.tempDir, filename);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(outputFile, false);
            prop.storeToXML(os, null);
            os.close();
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    private static final class CopyToFilter
    extends XMLFilterImpl {
        private final File workdir;
        private final String path2project;

        CopyToFilter(XMLReader parent, File workdir, String path2project) {
            super(parent);
            this.workdir = workdir;
            this.path2project = path2project;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            String d = data;
            if (target.equals("workdir")) {
                if (this.workdir != null) {
                    try {
                        if (Constants.OS_NAME.toLowerCase().indexOf("windows") == -1) {
                            d = this.workdir.getCanonicalPath();
                        }
                        d = "/" + this.workdir.getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to get canonical path for working directory: " + e.getMessage(), e);
                    }
                }
            } else if (target.equals("workdir-uri")) {
                if (this.workdir != null) {
                    d = this.workdir.toURI().toString();
                }
            } else if (target.equals("path2project")) {
                if (this.path2project != null) {
                    d = this.path2project;
                }
            } else if (target.equals("path2project-uri") && this.path2project != null) {
                d = URLUtils.correct(FileUtils.separatorsToUnix(this.path2project), true);
            }
            this.getContentHandler().processingInstruction(target, d);
        }
    }
}

