/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;

final class EscapeUnicodeModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;

    EscapeUnicodeModule() {
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        String inputFile = input.getAttribute("input");
        String outputFile = input.getAttribute("output");
        File file = new File(outputFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileInputStream fi = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        OutputStreamWriter fw = null;
        try {
            fi = new FileInputStream(new File(inputFile));
            is = new InputStreamReader((InputStream)fi, "UTF-8");
            br = new BufferedReader(is);
            fw = new FileWriter(file);
            String data = null;
            int codePoint = 0;
            while ((data = br.readLine()) != null) {
                for (int i = 0; i < data.length(); ++i) {
                    codePoint = data.codePointAt(i);
                    if (codePoint < 128) {
                        fw.append(data.charAt(i));
                        continue;
                    }
                    fw.append("\\u").append("" + codePoint).append(" ?");
                }
            }
            fw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
        return null;
    }
}

