/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.reader.GrammarPoolManager;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DelayConrefUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.TimingUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class GenMapAndTopicListModule
implements AbstractPipelineModule {
    public static final String ELEMENT_STUB = "stub";
    private static final String ATTRIUBTE_SOURCE = "source";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_KEYS = "keys";
    private static final String ELEMENT_KEYDEF = "keydef";
    private final Set<String> ditaSet = new HashSet<String>(128);
    private final Set<String> fullTopicSet = new HashSet<String>(128);
    private final Set<String> fullMapSet = new HashSet<String>(128);
    private final Set<String> hrefTopicSet = new HashSet<String>(128);
    private final Set<String> hrefWithIDSet = new HashSet<String>(128);
    private final Set<String> chunkTopicSet = new HashSet<String>(128);
    private final Set<String> hrefMapSet;
    private final Set<String> conrefSet;
    private final Set<String> coderefSet;
    private final Set<String> imageSet;
    private final Set<String> flagImageSet;
    private final Set<String> htmlSet;
    private final Set<String> hrefTargetSet;
    private Set<String> conrefTargetSet;
    private Set<String> copytoSourceSet;
    private final Set<String> nonConrefCopytoTargetSet;
    private final Set<String> ignoredCopytoSourceSet;
    private final Set<String> subsidiarySet;
    private final Set<String> relFlagImagesSet;
    private Map<String, String> copytoMap;
    private final List<File> waitList;
    private final List<File> doneList;
    private final Set<String> outDitaFilesSet;
    private final Set<String> conrefpushSet;
    private final Set<String> keyrefSet;
    private final Set<String> resourceOnlySet;
    private final Map<String, KeyDef> keysDefMap;
    private File baseInputDir;
    private File tempDir;
    private File ditaDir;
    private File inputFile;
    private File ditavalFile;
    private int uplevels = 0;
    private String prefix = "";
    private DITAOTLogger logger;
    private GenListModuleReader reader;
    private OutputUtils outputUtils;
    private boolean xmlValidate = true;
    private File rootFile;
    private File currentFile;
    private Map<String, KeyDef> schemekeydefMap;
    private final Set<String> schemeSet = new HashSet<String>(128);
    private final Map<String, Set<String>> schemeDictionary;
    private String transtype;
    private final Map<String, String> exKeyDefMap;
    private static final String moduleStartMsg = "GenMapAndTopicListModule.execute(): Starting...";
    private static final String moduleEndMsg = "GenMapAndTopicListModule.execute(): Execution time: ";
    private boolean gramcache = true;
    private boolean setSystemid = true;

    public GenMapAndTopicListModule() throws SAXException, ParserConfigurationException {
        this.hrefMapSet = new HashSet<String>(128);
        this.conrefSet = new HashSet<String>(128);
        this.imageSet = new HashSet<String>(128);
        this.flagImageSet = new LinkedHashSet<String>(128);
        this.htmlSet = new HashSet<String>(128);
        this.hrefTargetSet = new HashSet<String>(128);
        this.subsidiarySet = new HashSet<String>(16);
        this.waitList = new LinkedList<File>();
        this.doneList = new LinkedList<File>();
        this.conrefTargetSet = new HashSet<String>(128);
        this.nonConrefCopytoTargetSet = new HashSet<String>(128);
        this.copytoMap = new HashMap<String, String>();
        this.copytoSourceSet = new HashSet<String>(128);
        this.ignoredCopytoSourceSet = new HashSet<String>(128);
        this.outDitaFilesSet = new HashSet<String>(128);
        this.relFlagImagesSet = new LinkedHashSet<String>(128);
        this.conrefpushSet = new HashSet<String>(128);
        this.keysDefMap = new HashMap<String, KeyDef>();
        this.exKeyDefMap = new HashMap<String, String>();
        this.keyrefSet = new HashSet<String>(128);
        this.coderefSet = new HashSet<String>(128);
        this.schemeDictionary = new HashMap<String, Set<String>>();
        this.resourceOnlySet = new HashSet<String>(128);
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        Date startTime = TimingUtils.getNowTime();
        try {
            this.logger.logInfo(moduleStartMsg);
            this.parseInputParameters(input);
            GrammarPoolManager.setGramCache(this.gramcache);
            this.reader = new GenListModuleReader();
            this.reader.setLogger(this.logger);
            this.reader.setExtName(input.getAttribute("ditaext"));
            this.reader.initXMLReader(this.ditaDir, this.xmlValidate, this.rootFile, this.setSystemid);
            FilterUtils filterUtils = this.parseFilterFile();
            this.reader.setFilterUtils(filterUtils);
            this.reader.setOutputUtils(this.outputUtils);
            this.addToWaitList(this.inputFile);
            this.processWaitList();
            this.updateBaseDirectory();
            this.refactoringResult();
            this.outputResult();
        }
        catch (DITAOTException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        finally {
            this.logger.logInfo(moduleEndMsg + TimingUtils.reportElapsedTime(startTime));
        }
        return null;
    }

    private void parseInputParameters(AbstractPipelineInput input) throws IOException {
        String ditaInput;
        File inFile;
        this.tempDir = new File(input.getAttribute("tempDir"));
        this.ditaDir = new File(input.getAttribute("ditadir"));
        if (input.getAttribute("ditaval") != null) {
            this.ditavalFile = new File(input.getAttribute("ditaval"));
        }
        this.xmlValidate = Boolean.valueOf(input.getAttribute("validate"));
        this.transtype = input.getAttribute("transtype");
        this.gramcache = "yes".equalsIgnoreCase(input.getAttribute("gramcache"));
        this.setSystemid = "yes".equalsIgnoreCase(input.getAttribute("setsystemid"));
        this.outputUtils = new OutputUtils();
        this.outputUtils.setGeneratecopyouter(input.getAttribute("generatecopyouter"));
        this.outputUtils.setOutterControl(input.getAttribute("outercontrol"));
        this.outputUtils.setOnlyTopicInMap(input.getAttribute("onlytopicinmap"));
        File path = new File(input.getAttribute("outputdir"));
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Output directory " + this.tempDir + " must be absolute");
        }
        this.outputUtils.setOutputDir(path);
        String basedir = input.getAttribute("basedir");
        String ditaInputDir = input.getAttribute("inputdir");
        if (ditaInputDir != null) {
            File inDir = new File(ditaInputDir);
            if (!inDir.isAbsolute()) {
                inDir = new File(basedir, ditaInputDir);
            }
            this.baseInputDir = inDir.getCanonicalFile();
        }
        if (!(inFile = new File(ditaInput = input.getAttribute("inputmap"))).isAbsolute()) {
            inFile = this.baseInputDir != null ? new File(this.baseInputDir, ditaInput) : new File(basedir, ditaInput);
        }
        inFile = inFile.getCanonicalFile();
        if (this.baseInputDir == null) {
            this.baseInputDir = inFile.getParentFile().getCanonicalFile();
        }
        if (!this.tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + this.tempDir + " must be absolute");
        }
        this.tempDir = this.tempDir.getCanonicalFile();
        if (!this.ditaDir.isAbsolute()) {
            throw new IllegalArgumentException("DITA-OT installation directory " + this.tempDir + " must be absolute");
        }
        this.ditaDir = this.ditaDir.getCanonicalFile();
        if (this.ditavalFile != null && !this.ditavalFile.isAbsolute()) {
            this.ditavalFile = new File(basedir, this.ditavalFile.getPath()).getAbsoluteFile();
        }
        this.rootFile = inFile.getCanonicalFile();
        this.inputFile = new File(FileUtils.getRelativePath(new File(this.baseInputDir, "x").getAbsolutePath(), inFile.getAbsolutePath()));
        this.schemekeydefMap = new HashMap<String, KeyDef>();
        this.outputUtils.setInputMapPathName(inFile);
    }

    private void processWaitList() throws DITAOTException {
        this.reader.setTranstype(this.transtype);
        if (FileUtils.isDITAMapFile(this.inputFile.getPath())) {
            this.reader.setPrimaryDitamap(this.inputFile.getPath());
        }
        while (!this.waitList.isEmpty()) {
            this.currentFile = this.waitList.remove(0);
            this.processFile(this.currentFile);
        }
    }

    private void processFile(File currentFile) throws DITAOTException {
        File file;
        File fileToParse;
        if (currentFile.isAbsolute()) {
            fileToParse = currentFile;
            file = new File(FileUtils.getRelativePath(this.rootFile.getAbsolutePath(), currentFile.getPath()));
        } else {
            fileToParse = new File(this.baseInputDir, currentFile.getPath());
            file = currentFile;
        }
        try {
            fileToParse = fileToParse.getCanonicalFile();
        }
        catch (IOException e1) {
            this.logger.logError(e1.toString());
        }
        this.logger.logInfo("Processing " + fileToParse.getAbsolutePath());
        String[] params = new String[]{fileToParse.getAbsolutePath()};
        if (!fileToParse.exists()) {
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTX008E", params).toString());
            return;
        }
        if (!FileUtils.isValidTarget(file.getPath().toLowerCase())) {
            Properties prop = new Properties();
            prop.put("%1", fileToParse);
            this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTJ053W", params).toString());
        }
        try {
            this.reader.setTranstype(this.transtype);
            this.reader.setCurrentDir(file.getParent());
            this.reader.parse(fileToParse);
            if (this.reader.isValidInput()) {
                this.processParseResult(file.getPath());
                this.categorizeCurrentFile(file.getPath());
            } else if (!file.equals(this.inputFile)) {
                this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTJ021W", params).toString());
            }
        }
        catch (SAXParseException sax) {
            Exception inner = sax.getException();
            if (inner != null && inner instanceof DITAOTException) {
                this.logger.logInfo(inner.getMessage());
                throw (DITAOTException)inner;
            }
            if (file.equals(this.inputFile)) {
                String msg = MessageUtils.getInstance().getMessage("DOTJ012F", params).toString() + ": " + sax.getMessage();
                throw new DITAOTException(MessageUtils.getInstance().getMessage("DOTJ012F", params), sax, msg);
            }
            String buff = MessageUtils.getInstance().getMessage("DOTJ013E", params).toString() + Constants.LINE_SEPARATOR + sax.getMessage();
            this.logger.logError(buff.toString());
        }
        catch (Exception e) {
            if (file.equals(this.inputFile)) {
                String msg = MessageUtils.getInstance().getMessage("DOTJ012F", params).toString() + ": " + e.getMessage();
                throw new DITAOTException(MessageUtils.getInstance().getMessage("DOTJ012F", params), e, msg);
            }
            String buff = MessageUtils.getInstance().getMessage("DOTJ013E", params).toString() + Constants.LINE_SEPARATOR + e.getMessage();
            this.logger.logError(buff);
        }
        if (!this.reader.isValidInput() && file.equals(this.inputFile)) {
            if (this.xmlValidate) {
                throw new DITAOTException(MessageUtils.getInstance().getMessage("DOTJ022F", params).toString());
            }
            throw new DITAOTException(MessageUtils.getInstance().getMessage("DOTJ034F", params).toString());
        }
        this.doneList.add(file);
        this.reader.reset();
    }

    private void processParseResult(String currentFile) {
        Object value;
        Map<String, String> cpMap = this.reader.getCopytoMap();
        Map<String, KeyDef> kdMap = this.reader.getKeysDMap();
        Map<String, String> exKdMap = this.reader.getExKeysDefMap();
        this.exKeyDefMap.putAll(exKdMap);
        for (GenListModuleReader.Reference file : this.reader.getNonCopytoResult()) {
            this.categorizeResultFile(file);
            this.updateUplevels(file.filename);
        }
        for (String key : cpMap.keySet()) {
            value = cpMap.get(key);
            if (this.copytoMap.containsKey(key)) {
                this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTX065W", new String[]{value, key}).toString());
                this.ignoredCopytoSourceSet.add((String)value);
                continue;
            }
            this.updateUplevels(key);
            this.copytoMap.put(key, (String)value);
        }
        this.schemeSet.addAll(this.reader.getSchemeRefSet());
        for (String key : kdMap.keySet()) {
            value = kdMap.get(key);
            if (!this.keysDefMap.containsKey(key)) {
                this.updateUplevels(key);
                this.keysDefMap.put(key, new KeyDef(key, ((KeyDef)value).href, ((KeyDef)value).scope, currentFile));
            }
            if (!this.schemeSet.contains(currentFile)) continue;
            this.schemekeydefMap.put(key, new KeyDef(key, ((KeyDef)value).href, ((KeyDef)value).scope, currentFile));
        }
        this.hrefTargetSet.addAll(this.reader.getHrefTargets());
        this.hrefWithIDSet.addAll(this.reader.getHrefTopicSet());
        this.chunkTopicSet.addAll(this.reader.getChunkTopicSet());
        this.conrefTargetSet.addAll(this.reader.getConrefTargets());
        this.nonConrefCopytoTargetSet.addAll(this.reader.getNonConrefCopytoTargets());
        this.ignoredCopytoSourceSet.addAll(this.reader.getIgnoredCopytoSourceSet());
        this.subsidiarySet.addAll(this.reader.getSubsidiaryTargets());
        this.outDitaFilesSet.addAll(this.reader.getOutFilesSet());
        if (this.reader.getSchemeSet() != null && !this.reader.getSchemeSet().isEmpty()) {
            Set<String> children = null;
            children = this.schemeDictionary.get(currentFile);
            if (children == null) {
                children = new HashSet<String>();
            }
            children.addAll(this.reader.getSchemeSet());
            String normalizedCurrentFile = FileUtils.separatorsToUnix(currentFile);
            this.schemeDictionary.put(normalizedCurrentFile, children);
            Set<String> hrfSet = this.reader.getHrefTargets();
            for (String f : hrfSet) {
                String filename = FileUtils.separatorsToUnix(f);
                children = this.schemeDictionary.get(filename);
                if (children == null) {
                    children = new HashSet<String>();
                }
                children.addAll(this.reader.getSchemeSet());
                this.schemeDictionary.put(filename, children);
            }
        }
    }

    private void categorizeCurrentFile(String currentFile) {
        String lcasefn = currentFile.toLowerCase();
        this.ditaSet.add(currentFile);
        if (FileUtils.isDITATopicFile(currentFile)) {
            this.hrefTargetSet.add(currentFile);
        }
        if (this.reader.hasConaction()) {
            this.conrefpushSet.add(currentFile);
        }
        if (this.reader.hasConRef()) {
            this.conrefSet.add(currentFile);
        }
        if (this.reader.hasKeyRef()) {
            this.keyrefSet.add(currentFile);
        }
        if (this.reader.hasCodeRef()) {
            this.coderefSet.add(currentFile);
        }
        if (FileUtils.isDITATopicFile(lcasefn)) {
            this.fullTopicSet.add(currentFile);
            if (this.reader.hasHref()) {
                this.hrefTopicSet.add(currentFile);
            }
        }
        if (FileUtils.isDITAMapFile(lcasefn)) {
            this.fullMapSet.add(currentFile);
            if (this.reader.hasHref()) {
                this.hrefMapSet.add(currentFile);
            }
        }
    }

    private void categorizeResultFile(GenListModuleReader.Reference file) {
        String lcasefn = file.filename.toLowerCase();
        if (this.subsidiarySet.contains(lcasefn)) {
            return;
        }
        if (FileUtils.isDITAFile(lcasefn) && (file.format == null || "dita".equalsIgnoreCase(file.format) || "ditamap".equalsIgnoreCase(file.format))) {
            this.addToWaitList(new File(file.filename));
        } else if (!FileUtils.isSupportedImageFile(lcasefn)) {
            this.htmlSet.add(file.filename);
        }
        if (FileUtils.isSupportedImageFile(lcasefn)) {
            this.imageSet.add(file.filename);
            try {
                File image = new File(this.baseInputDir, file.filename).getCanonicalFile();
                if (!image.exists()) {
                    this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTX008W", image.getAbsolutePath()).toString());
                }
            }
            catch (IOException e) {
                this.logger.logError(e.getMessage());
            }
        }
        if (FileUtils.isHTMLFile(lcasefn) || FileUtils.isResourceFile(lcasefn)) {
            this.htmlSet.add(file.filename);
        }
    }

    private void updateUplevels(String file) {
        int lastIndex;
        String f = file;
        if (f.contains("|")) {
            f = f.substring(0, f.indexOf("|"));
        }
        if ((lastIndex = FileUtils.separatorsToUnix(FileUtils.normalize(f)).lastIndexOf("../")) != -1) {
            int newUplevels = lastIndex / 3 + 1;
            this.uplevels = newUplevels > this.uplevels ? newUplevels : this.uplevels;
        }
    }

    private void addToWaitList(File file) {
        if (this.doneList.contains(file) || this.waitList.contains(file) || file.equals(this.currentFile)) {
            return;
        }
        this.waitList.add(file);
    }

    private void updateBaseDirectory() {
        for (int i = this.uplevels; i > 0; --i) {
            File file = this.baseInputDir;
            this.baseInputDir = this.baseInputDir.getParentFile();
            this.prefix = new StringBuffer(file.getName()).append(File.separator).append(this.prefix).toString();
        }
    }

    private String getUpdateLevels() {
        StringBuffer buff = new StringBuffer();
        for (int current = this.uplevels; current > 0; --current) {
            buff.append(".." + File.separator);
        }
        return buff.toString();
    }

    private String formatRelativeValue(String value) {
        StringBuffer buff = new StringBuffer();
        if (value == null || value.length() == 0) {
            return "";
        }
        block13: for (int index = 0; index < value.length(); ++index) {
            char current = value.charAt(index);
            switch (current) {
                case '.': {
                    buff.append("\\.");
                    continue block13;
                }
                case '\\': {
                    buff.append("[\\\\|/]");
                    continue block13;
                }
                case '(': {
                    buff.append("\\(");
                    continue block13;
                }
                case ')': {
                    buff.append("\\)");
                    continue block13;
                }
                case '[': {
                    buff.append("\\[");
                    continue block13;
                }
                case ']': {
                    buff.append("\\]");
                    continue block13;
                }
                case '{': {
                    buff.append("\\{");
                    continue block13;
                }
                case '}': {
                    buff.append("\\}");
                    continue block13;
                }
                case '^': {
                    buff.append("\\^");
                    continue block13;
                }
                case '+': {
                    buff.append("\\+");
                    continue block13;
                }
                case '$': {
                    buff.append("\\$");
                    continue block13;
                }
                default: {
                    buff.append(current);
                }
            }
        }
        return buff.toString();
    }

    private FilterUtils parseFilterFile() {
        FilterUtils filterUtils = new FilterUtils();
        filterUtils.setLogger(this.logger);
        if (this.ditavalFile != null) {
            DitaValReader ditaValReader = new DitaValReader();
            ditaValReader.setLogger(this.logger);
            ditaValReader.initXMLReader(this.setSystemid);
            ditaValReader.read(this.ditavalFile.getAbsolutePath());
            filterUtils.setFilterMap(ditaValReader.getFilterMap());
            this.flagImageSet.addAll(ditaValReader.getImageList());
            this.relFlagImagesSet.addAll(ditaValReader.getRelFlagImageList());
        } else {
            filterUtils.setFilterMap(null);
        }
        return filterUtils;
    }

    private void refactoringResult() {
        this.resourceOnlySet.addAll(this.reader.getResourceOnlySet());
        this.handleConref();
        this.handleCopyto();
    }

    private void handleCopyto() {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        HashSet<String> pureCopytoSources = new HashSet<String>(128);
        HashSet<String> totalCopytoSources = new HashSet<String>(128);
        for (String key : this.copytoMap.keySet()) {
            String value = this.copytoMap.get(key);
            if (!new File(this.baseInputDir + File.separator + this.prefix, value).exists()) continue;
            tempMap.put(key, value);
            if (!this.conrefSet.contains(value)) continue;
            this.conrefSet.add(key);
        }
        this.copytoMap = tempMap;
        this.ditaSet.addAll(this.copytoMap.keySet());
        this.fullTopicSet.addAll(this.copytoMap.keySet());
        totalCopytoSources.addAll(this.copytoMap.values());
        totalCopytoSources.addAll(this.ignoredCopytoSourceSet);
        for (String src : totalCopytoSources) {
            if (this.nonConrefCopytoTargetSet.contains(src) || this.copytoMap.keySet().contains(src)) continue;
            pureCopytoSources.add(src);
        }
        this.copytoSourceSet = pureCopytoSources;
        this.ditaSet.removeAll(pureCopytoSources);
        this.fullTopicSet.removeAll(pureCopytoSources);
    }

    private void handleConref() {
        HashSet<String> pureConrefTargets = new HashSet<String>(128);
        for (String target : this.conrefTargetSet) {
            if (this.nonConrefCopytoTargetSet.contains(target)) continue;
            pureConrefTargets.add(target);
        }
        this.conrefTargetSet = pureConrefTargets;
        this.ditaSet.removeAll(pureConrefTargets);
        this.fullTopicSet.removeAll(pureConrefTargets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputResult() throws DITAOTException {
        File dir = this.tempDir;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Job prop = null;
        try {
            prop = new Job(dir);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to create empty job: " + e.getMessage(), e);
        }
        prop.setProperty("user.input.dir", this.baseInputDir.getAbsolutePath());
        prop.setProperty("user.input.file", this.prefix + this.inputFile);
        prop.setProperty("user.input.file.listfile", "usr.input.file.list");
        File inputfile = new File(this.tempDir, "usr.input.file.list");
        Writer bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(inputfile)));
            bufferedWriter.write(this.prefix + this.inputFile);
            bufferedWriter.flush();
        }
        catch (FileNotFoundException e) {
            this.logger.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
        prop.setProperty("tempdirToinputmapdir.relative.value", this.formatRelativeValue(this.prefix));
        prop.setProperty("uplevels", this.getUpdateLevels());
        this.addSetToProperties(prop, "outditafileslist", this.outDitaFilesSet);
        this.addSetToProperties(prop, "fullditamapandtopiclist", this.ditaSet);
        this.addSetToProperties(prop, "fullditatopiclist", this.fullTopicSet);
        this.addSetToProperties(prop, "fullditamaplist", this.fullMapSet);
        this.addSetToProperties(prop, "hrefditatopiclist", this.hrefTopicSet);
        this.addSetToProperties(prop, "conreflist", this.conrefSet);
        this.addSetToProperties(prop, "imagelist", this.imageSet);
        this.addSetToProperties(prop, "flagimagelist", this.flagImageSet);
        this.addSetToProperties(prop, "htmllist", this.htmlSet);
        this.addSetToProperties(prop, "hreftargetslist", this.hrefTargetSet);
        this.addSetToProperties(prop, "canditopicslist", this.hrefWithIDSet);
        this.addSetToProperties(prop, "skipchunklist", this.chunkTopicSet);
        this.addSetToProperties(prop, "subjectschemelist", this.schemeSet);
        this.addSetToProperties(prop, "conreftargetslist", this.conrefTargetSet);
        this.addSetToProperties(prop, "copytosourcelist", this.copytoSourceSet);
        this.addSetToProperties(prop, "subtargetslist", this.subsidiarySet);
        this.addSetToProperties(prop, "conrefpushlist", this.conrefpushSet);
        this.addSetToProperties(prop, "keyreflist", this.keyrefSet);
        this.addSetToProperties(prop, "codereflist", this.coderefSet);
        this.addSetToProperties(prop, "resourceonlylist", this.resourceOnlySet);
        this.addFlagImagesSetToProperties(prop, "relflagimagelist", this.relFlagImagesSet);
        this.addMapToProperties(prop, "copytotarget2sourcemaplist", this.copytoMap);
        this.addKeyDefSetToProperties(prop, this.keysDefMap);
        try {
            this.logger.logInfo("Serializing job specification");
            prop.write();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize job configuration files: " + e.getMessage(), e);
        }
        this.writeMapToXML(this.reader.getRelationshipGrap(), "subrelation.xml");
        this.writeMapToXML(this.schemeDictionary, "subject_scheme.dictionary");
        if ("eclipsehelp".equals(this.transtype)) {
            File pluginIdFile = new File(this.tempDir, "pluginId.xml");
            DelayConrefUtils delayConrefUtils = new DelayConrefUtils();
            delayConrefUtils.writeMapToXML(this.reader.getPluginMap(), pluginIdFile);
            OutputStream exportStream = null;
            XMLStreamWriter export = null;
            try {
                exportStream = new FileOutputStream(new File(this.tempDir, "export.xml"));
                export = XMLOutputFactory.newInstance().createXMLStreamWriter(exportStream);
                export.writeStartDocument();
                export.writeStartElement(ELEMENT_STUB);
                for (GenListModuleReader.ExportAnchor e : this.reader.getExportAnchors()) {
                    export.writeStartElement("file");
                    export.writeAttribute("name", e.file);
                    for (String t : e.topicids) {
                        export.writeStartElement("topicid");
                        export.writeAttribute("name", t);
                        export.writeEndElement();
                    }
                    for (String i : e.ids) {
                        export.writeStartElement("id");
                        export.writeAttribute("name", i);
                        export.writeEndElement();
                    }
                    for (String k : e.keys) {
                        export.writeStartElement("keyref");
                        export.writeAttribute("name", k);
                        export.writeEndElement();
                    }
                    export.writeEndElement();
                }
                export.writeEndElement();
                export.writeEndDocument();
            }
            catch (FileNotFoundException e) {
                throw new DITAOTException("Failed to write export anchor file: " + e.getMessage(), e);
            }
            catch (XMLStreamException e) {
                throw new DITAOTException("Failed to serialize export anchor file: " + e.getMessage(), e);
            }
            finally {
                if (export != null) {
                    try {
                        export.close();
                    }
                    catch (XMLStreamException e) {
                        this.logger.logError("Failed to close export anchor file: " + e.getMessage(), e);
                    }
                }
                if (exportStream != null) {
                    try {
                        exportStream.close();
                    }
                    catch (IOException e) {
                        this.logger.logError("Failed to close export anchor file: " + e.getMessage(), e);
                    }
                }
            }
        }
        KeyDef.writeKeydef(new File(this.tempDir, "schemekeydef.xml"), this.schemekeydefMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapToXML(Map<String, Set<String>> m, String filename) {
        if (m == null) {
            return;
        }
        Properties prop = new Properties();
        for (Map.Entry<String, Set<String>> entry : m.entrySet()) {
            String key = entry.getKey();
            String value = StringUtils.assembleString(entry.getValue(), ",");
            prop.setProperty(key, value);
        }
        File outputFile = new File(this.tempDir, filename);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(outputFile);
            prop.storeToXML(os, null);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    private void addSetToProperties(Job prop, String key, Set<String> set) {
        LinkedHashSet<String> newSet = new LinkedHashSet<String>(128);
        for (String file : set) {
            if (new File(file).isAbsolute()) {
                newSet.add(FileUtils.normalize(file));
                continue;
            }
            int index = file.indexOf("=");
            if (index != -1) {
                String to = file.substring(0, index);
                String source = file.substring(index + 1);
                newSet.add(FileUtils.separatorsToUnix(FileUtils.normalize(new StringBuffer(this.prefix).append(to).toString())) + "=" + FileUtils.separatorsToUnix(FileUtils.normalize(new StringBuffer(this.prefix).append(source).toString())));
                continue;
            }
            newSet.add(FileUtils.separatorsToUnix(FileUtils.normalize(new StringBuffer(this.prefix).append(file).toString())));
        }
        prop.setSet(key, newSet);
    }

    private void addMapToProperties(Job prop, String key, Map<String, String> map) {
        HashMap<String, String> newSet = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> e : map.entrySet()) {
            String to = e.getKey();
            to = new File(to).isAbsolute() ? FileUtils.normalize(to) : FileUtils.separatorsToUnix(FileUtils.normalize(new StringBuffer(this.prefix).append(to).toString()));
            String source = e.getValue();
            if (new File(source).isAbsolute()) {
                source = FileUtils.normalize(source);
            } else {
                FileUtils.separatorsToUnix(FileUtils.normalize(new StringBuffer(this.prefix).append(source).toString()));
            }
            newSet.put(to, source);
        }
        prop.setMap(key, newSet);
    }

    private void addKeyDefSetToProperties(Job prop, Map<String, KeyDef> keydefs) {
        ArrayList<KeyDef> updated = new ArrayList<KeyDef>(keydefs.size());
        for (KeyDef file : keydefs.values()) {
            String keys = file.keys;
            String href = file.href;
            String source = file.source;
            if (this.prefix.length() != 0) {
                if (href == null) {
                    source = FileUtils.separatorsToUnix(FileUtils.normalize(this.prefix + source));
                } else {
                    if (!this.exKeyDefMap.containsKey(file.keys)) {
                        href = FileUtils.separatorsToUnix(FileUtils.normalize(this.prefix + href));
                    }
                    source = FileUtils.separatorsToUnix(FileUtils.normalize(this.prefix + source));
                }
            }
            KeyDef keyDef = new KeyDef(keys, href, file.scope, source);
            updated.add(keyDef);
        }
        try {
            KeyDef.writeKeydef(new File(this.tempDir, "keydef.xml"), updated);
        }
        catch (DITAOTException e) {
            this.logger.logError("Failed to write key definition file: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFlagImagesSetToProperties(Job prop, String key, Set<String> set) {
        LinkedHashSet<String> newSet = new LinkedHashSet<String>(128);
        for (String file : set) {
            if (new File(file).isAbsolute()) {
                newSet.add(FileUtils.normalize(file));
                continue;
            }
            newSet.add(FileUtils.separatorsToUnix(FileUtils.normalize(new StringBuffer().append(file).toString())));
        }
        String fileKey = key.substring(0, key.lastIndexOf("list")) + "file";
        prop.setProperty(fileKey, key.substring(0, key.lastIndexOf("list")) + ".list");
        File list = new File(this.tempDir, prop.getProperty(fileKey));
        Writer bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(list)));
            Iterator it = newSet.iterator();
            while (it.hasNext()) {
                bufferedWriter.write((String)it.next());
                if (!it.hasNext()) continue;
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            this.logger.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
        prop.setProperty(key, StringUtils.assembleString(newSet, ","));
        set.clear();
        newSet.clear();
    }
}

