/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.Job;
import org.dita.dost.writer.ImageMetadataFilter;

final class ImageMetadataModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        Set<String> imagelist = job.getSet("fullditatopiclist");
        imagelist.removeAll(job.getSet("resourceonlylist"));
        imagelist.addAll(job.getSet("chunkedtopiclist"));
        imagelist.addAll(job.getSet("chunkedditamaplist"));
        ImageMetadataFilter writer = new ImageMetadataFilter(new File(input.getAttribute("outputdir")), tempDir, job.getProperty("uplevels"));
        writer.setLogger(this.logger);
        for (String fileName : imagelist) {
            writer.write(new File(tempDir, fileName).getAbsolutePath());
        }
        return null;
    }
}

