/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermCollection;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.DitamapIndexTermReader;
import org.dita.dost.reader.IndexTermReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class IndexTermExtractModule
implements AbstractPipelineModule {
    private String inputMap = null;
    private String targetExt = null;
    private String baseInputDir = null;
    private List<String> topicList = null;
    private List<String> ditamapList = null;
    private DITAOTLogger logger;
    private IndexTermCollection indexTermCollection;

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        this.indexTermCollection = IndexTermCollection.getInstantce();
        try {
            this.indexTermCollection.clear();
            this.parseAndValidateInput(input);
            this.extractIndexTerm();
            this.indexTermCollection.sort();
            this.indexTermCollection.outputTerms();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        return null;
    }

    private void parseAndValidateInput(AbstractPipelineInput input) throws DITAOTException {
        Job prop;
        String baseDir = input.getAttribute("basedir");
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        String output = input.getAttribute("output");
        if (!new File(output).isAbsolute()) {
            output = new File(baseDir, output).getAbsolutePath();
        }
        String encoding = input.getAttribute("encoding");
        String indextype = input.getAttribute("indextype");
        String indexclass = input.getAttribute("indexclass");
        this.inputMap = input.getAttribute("inputmap");
        this.targetExt = input.getAttribute("targetext");
        this.baseInputDir = tempDir.getAbsolutePath();
        try {
            prop = new Job(tempDir);
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to load job: " + e.getMessage(), e);
        }
        Set<String> topics = prop.getSet("fullditatopiclist");
        Set<String> resource_only_list = prop.getSet("resourceonlylist");
        this.topicList = new ArrayList<String>(topics.size());
        for (String t : topics) {
            if (resource_only_list.contains(t)) continue;
            this.topicList.add(t);
        }
        Set<String> maps = prop.getSet("fullditamaplist");
        this.ditamapList = new ArrayList<String>(maps.size());
        for (String t : maps) {
            if (resource_only_list.contains(t)) continue;
            this.ditamapList.add(t);
        }
        int lastIndexOfDot = output.lastIndexOf(".");
        String outputRoot = lastIndexOfDot == -1 ? output : output.substring(0, lastIndexOfDot);
        this.indexTermCollection.setOutputFileRoot(outputRoot);
        this.indexTermCollection.setIndexType(indextype);
        this.indexTermCollection.setIndexClass(indexclass);
        this.indexTermCollection.setPipelineHashIO((PipelineHashIO)input);
        if (encoding != null && encoding.trim().length() > 0) {
            IndexTerm.setTermLocale(StringUtils.getLocale(encoding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractIndexTerm() throws SAXException {
        int topicNum = this.topicList.size();
        int ditamapNum = this.ditamapList.size();
        FileInputStream inputStream = null;
        XMLReader xmlReader = null;
        IndexTermReader handler = new IndexTermReader(this.indexTermCollection);
        handler.setLogger(this.logger);
        DitamapIndexTermReader ditamapIndexTermReader = new DitamapIndexTermReader(this.indexTermCollection, true);
        ditamapIndexTermReader.setLogger(this.logger);
        xmlReader = StringUtils.getXMLReader();
        try {
            xmlReader.setContentHandler(handler);
            for (int i = 0; i < topicNum; ++i) {
                handler.reset();
                String target = this.topicList.get(i);
                String targetPathFromMap = FileUtils.getRelativePath(this.inputMap, target);
                String targetPathFromMapWithoutExt = targetPathFromMap.substring(0, targetPathFromMap.lastIndexOf("."));
                handler.setTargetFile(new StringBuffer(targetPathFromMapWithoutExt).append(this.targetExt).toString());
                try {
                    inputStream = new FileInputStream(new File(this.baseInputDir, target));
                    xmlReader.parse(new InputSource(inputStream));
                    inputStream.close();
                    continue;
                }
                catch (Exception e) {
                    StringBuffer buff = new StringBuffer();
                    String msg = null;
                    msg = MessageUtils.getInstance().getMessage("DOTJ013E", target).toString();
                    this.logger.logError(buff.append(msg).append(e.getMessage()).toString());
                }
            }
            xmlReader.setContentHandler(ditamapIndexTermReader);
            for (int j = 0; j < ditamapNum; ++j) {
                String ditamap = this.ditamapList.get(j);
                String currentMapPathName = FileUtils.getRelativePath(this.inputMap, ditamap);
                String mapPathFromInputMap = "";
                if (currentMapPathName.lastIndexOf("/") != -1) {
                    mapPathFromInputMap = currentMapPathName.substring(0, currentMapPathName.lastIndexOf("/"));
                }
                ditamapIndexTermReader.setMapPath(mapPathFromInputMap);
                try {
                    inputStream = new FileInputStream(new File(this.baseInputDir, ditamap));
                    xmlReader.parse(new InputSource(inputStream));
                    inputStream.close();
                    continue;
                }
                catch (Exception e) {
                    String msg = null;
                    msg = MessageUtils.getInstance().getMessage("DOTJ013E", ditamap).toString();
                    this.logger.logError(msg, e);
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }
}

