/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.KeyrefReader;
import org.dita.dost.util.Job;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.KeyrefPaser;
import org.w3c.dom.Element;
import org.xml.sax.XMLFilter;

final class KeyrefModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;

    KeyrefModule() {
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        String extName = input.getAttribute("ditaext");
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        HashMap<String, String> keymap = new HashMap<String, String>();
        Hashtable maps = new Hashtable();
        for (KeyDef keyDef : KeyDef.readKeydef(new File(tempDir, "keydef.xml"))) {
            keymap.put(keyDef.keys, keyDef.href);
            String map = keyDef.source;
            if (maps.containsKey(map)) {
                ((Set)maps.get(map)).add(keyDef.keys);
                continue;
            }
            HashSet<String> set = new HashSet<String>();
            set.add(keyDef.keys);
            maps.put(map, set);
        }
        KeyrefReader reader = new KeyrefReader();
        reader.setLogger(this.logger);
        reader.setTempDir(tempDir.getAbsolutePath());
        for (String mapFile : maps.keySet()) {
            this.logger.logInfo("Reading " + new File(tempDir, mapFile).getAbsolutePath());
            reader.setKeys((Set)maps.get(mapFile));
            reader.read(mapFile);
        }
        Map<String, Element> keyDefinition = reader.getKeyDefinition();
        Map<String, Job.FileInfo> files = job.getFileInfo();
        HashSet<String> parseList = new HashSet<String>();
        for (Job.FileInfo f : files.values()) {
            if (!f.hasKeyref && !f.hasConref) continue;
            parseList.add(f.file);
        }
        for (String file : parseList) {
            this.logger.logInfo("Processing " + new File(tempDir, file).getAbsolutePath());
            ArrayList<XMLFilter> filters = new ArrayList<XMLFilter>();
            KeyrefPaser parser = new KeyrefPaser();
            parser.setLogger(this.logger);
            parser.setKeyDefinition(keyDefinition);
            parser.setTempDir(tempDir);
            parser.setCurrentFile(new File(file));
            parser.setKeyMap(keymap);
            filters.add(parser);
            XMLUtils.transform(new File(tempDir, file), filters);
            for (String t : parser.getNormalProcessingRoleTargets()) {
                if (!files.containsKey(t)) continue;
                files.get((Object)t).isResourceOnly = false;
            }
        }
        job.addAll(files.values());
        try {
            job.write();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to store job state: " + e.getMessage(), e);
        }
        return null;
    }
}

