/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;

public final class ModuleFactory {
    private static ModuleFactory moduleFactory = null;
    private static final String packagePrefix = "org.dita.dost.module.";

    public static synchronized ModuleFactory instance() {
        if (moduleFactory == null) {
            moduleFactory = new ModuleFactory();
        }
        return moduleFactory;
    }

    public AbstractPipelineModule createModule(String moduleName) throws DITAOTException {
        String module = packagePrefix + moduleName + "Module";
        try {
            return (AbstractPipelineModule)Class.forName(module).newInstance();
        }
        catch (Exception e) {
            MessageBean msgBean = MessageUtils.getInstance().getMessage("DOTJ005F", module);
            String msg = msgBean.toString();
            throw new DITAOTException(msgBean, e, msg);
        }
    }

    public AbstractPipelineModule createModule(Class<? extends AbstractPipelineModule> moduleClass) throws DITAOTException {
        try {
            return moduleClass.newInstance();
        }
        catch (Exception e) {
            MessageBean msgBean = MessageUtils.getInstance().getMessage("DOTJ005F", moduleClass.getName());
            String msg = msgBean.toString();
            throw new DITAOTException(msgBean, e, msg);
        }
    }
}

