/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.MapIndexReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.writer.DitaIndexWriter;

final class MoveIndexModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;

    MoveIndexModule() {
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        MapIndexReader indexReader = new MapIndexReader();
        indexReader.setLogger(this.logger);
        indexReader.setMatch(new StringBuffer(Constants.MAP_TOPICREF.localName).append("/").append(Constants.MAP_TOPICMETA.localName).append("/").append(Constants.TOPIC_KEYWORDS.localName).toString());
        Set<String> fullditamaplist = job.getSet("fullditamaplist");
        for (String fileName : fullditamaplist) {
            indexReader.read(new File(tempDir, fileName).getAbsolutePath());
        }
        Map<String, String> mapSet = indexReader.getMapping();
        DitaIndexWriter indexInserter = new DitaIndexWriter();
        indexInserter.setLogger(this.logger);
        for (Map.Entry<String, String> entry : mapSet.entrySet()) {
            String targetFileName = entry.getKey();
            String string = targetFileName = targetFileName.indexOf("#") != -1 ? targetFileName.substring(0, targetFileName.indexOf("#")) : targetFileName;
            if (!targetFileName.endsWith(".dita") && !targetFileName.endsWith(".xml")) continue;
            ContentImpl content = new ContentImpl();
            content.setValue(entry.getValue());
            indexInserter.setContent(content);
            if (FileUtils.fileExists(entry.getKey())) {
                this.logger.logInfo("Processing " + targetFileName);
                indexInserter.write(entry.getKey());
                continue;
            }
            this.logger.logError("File " + entry.getKey() + " does not exist");
        }
        return null;
    }
}

