/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.util.Map;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.MapLinksReader;
import org.dita.dost.util.Constants;
import org.dita.dost.writer.DitaLinksWriter;

final class MoveLinksModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;

    MoveLinksModule() {
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        File maplinksFile = new File(input.getAttribute("maplinks"));
        MapLinksReader indexReader = new MapLinksReader();
        indexReader.setLogger(this.logger);
        indexReader.setMatch(new StringBuffer("maplinks").append("/").append(Constants.TOPIC_LINKPOOL.localName).append("/").append(Constants.TOPIC_LINKLIST.localName).toString());
        indexReader.read(maplinksFile.getAbsolutePath());
        Map<String, Map<String, String>> mapSet = indexReader.getMapping();
        DitaLinksWriter indexInserter = new DitaLinksWriter();
        indexInserter.setLogger(this.logger);
        for (Map.Entry<String, Map<String, String>> entry : mapSet.entrySet()) {
            this.logger.logInfo("Processing " + entry.getKey());
            ContentImpl content = new ContentImpl();
            content.setValue(entry.getValue());
            indexInserter.setContent(content);
            indexInserter.write(entry.getKey());
        }
        return null;
    }
}

