/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.MapMetaReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.writer.DitaMapMetaWriter;
import org.dita.dost.writer.DitaMetaWriter;
import org.w3c.dom.Element;

final class MoveMetaModule
implements AbstractPipelineModule {
    private final ContentImpl content = new ContentImpl();
    private DITAOTLogger logger;

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        File tempDir = new File(input.getAttribute("tempDir"));
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        Job job = null;
        try {
            job = new Job(tempDir);
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        MapMetaReader metaReader = new MapMetaReader();
        metaReader.setLogger(this.logger);
        Set<String> fullditamaplist = job.getSet("fullditamaplist");
        for (String mapFile : fullditamaplist) {
            mapFile = new File(tempDir, mapFile).getAbsolutePath();
            this.logger.logInfo("Reading " + mapFile);
            metaReader.read(mapFile);
            File oldMap = new File(mapFile);
            File newMap = new File(mapFile + ".temp");
            if (!newMap.exists()) continue;
            if (!oldMap.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", oldMap.getPath(), newMap.getAbsolutePath() + ".chunk").toString());
            }
            if (newMap.renameTo(oldMap)) continue;
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", oldMap.getPath(), newMap.getAbsolutePath() + ".chunk").toString());
        }
        Map<String, Hashtable<String, Element>> mapSet = metaReader.getMapping();
        DitaMapMetaWriter mapInserter = new DitaMapMetaWriter();
        mapInserter.setLogger(this.logger);
        for (Map.Entry<String, Hashtable<String, Element>> entry : mapSet.entrySet()) {
            String targetFileName = entry.getKey();
            targetFileName = targetFileName.indexOf("#") != -1 ? targetFileName.substring(0, targetFileName.indexOf("#")) : targetFileName;
            if (!targetFileName.endsWith(".ditamap")) continue;
            this.content.setValue(entry.getValue());
            mapInserter.setContent(this.content);
            if (FileUtils.fileExists(entry.getKey())) {
                this.logger.logInfo("Processing " + entry.getKey());
                mapInserter.write(entry.getKey());
                continue;
            }
            this.logger.logError("File " + entry.getKey() + " does not exist");
        }
        DitaMetaWriter topicInserter = new DitaMetaWriter();
        topicInserter.setLogger(this.logger);
        for (Map.Entry<String, Hashtable<String, Element>> entry : mapSet.entrySet()) {
            String targetFileName = entry.getKey();
            String string = targetFileName = targetFileName.indexOf("#") != -1 ? targetFileName.substring(0, targetFileName.indexOf("#")) : targetFileName;
            if (!targetFileName.endsWith(".dita") && !targetFileName.endsWith(".xml")) continue;
            this.content.setValue(entry.getValue());
            topicInserter.setContent(this.content);
            if (FileUtils.fileExists(entry.getKey())) {
                this.logger.logInfo("Processing " + entry.getKey());
                topicInserter.write(entry.getKey());
                continue;
            }
            this.logger.logError("File " + entry.getKey() + " does not exist");
        }
        return null;
    }
}

