/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.MergeMapParser;

final class TopicMergeModule
implements AbstractPipelineModule {
    private DITAOTLogger logger;

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        String ditaInput = input.getAttribute("inputmap");
        String style = input.getAttribute("style");
        String out = input.getAttribute("output");
        String tempdir = input.getAttribute("tempDir");
        MergeMapParser mapParser = new MergeMapParser();
        mapParser.setLogger(this.logger);
        if (ditaInput == null || !new File(ditaInput).exists()) {
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ025E", new String[0]).toString());
            return null;
        }
        if (out == null) {
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ026E", new String[0]).toString());
            return null;
        }
        ByteArrayOutputStream midBuffer = null;
        try {
            midBuffer = new ByteArrayOutputStream();
            midBuffer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>".getBytes("UTF-8"));
            midBuffer.write("<dita-merge xmlns:ditaarch=\"http://dita.oasis-open.org/architecture/2005/\">".getBytes("UTF-8"));
            mapParser.setOutputStream(midBuffer);
            mapParser.read(ditaInput, tempdir);
            midBuffer.write("</dita-merge>".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to merge topics: " + e.getMessage(), e);
        }
        finally {
            if (midBuffer != null) {
                try {
                    midBuffer.close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close output buffer: " + e.getMessage(), e);
                }
            }
        }
        OutputStream output = null;
        try {
            File outputDir = new File(out).getParentFile();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            output = new BufferedOutputStream(new FileOutputStream(out));
            if (style != null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                File styleFile = new File(style);
                Transformer transformer = factory.newTransformer(new StreamSource(styleFile.toURI().toString()));
                transformer.transform(new StreamSource(new ByteArrayInputStream(midBuffer.toByteArray())), new StreamResult(output));
            } else {
                output.write(midBuffer.toByteArray());
                output.flush();
            }
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to process merged topics: " + e.getMessage(), e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {
                this.logger.logError("Failed to close output buffer: " + e.getMessage(), e);
            }
        }
        return null;
    }
}

