/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.pipeline;

import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ModuleFactory;
import org.dita.dost.pipeline.AbstractFacade;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;

public final class PipelineFacade
implements AbstractFacade {
    private DITAOTLogger logger;
    private final ModuleFactory factory = ModuleFactory.instance();

    @Override
    public AbstractPipelineOutput execute(String pipelineModuleName, AbstractPipelineInput input) throws DITAOTException {
        AbstractPipelineModule module = this.factory.createModule(pipelineModuleName);
        if (module != null) {
            module.setLogger(this.logger);
            return module.execute(input);
        }
        return null;
    }

    @Override
    public AbstractPipelineOutput execute(Class<? extends AbstractPipelineModule> moduleClass, AbstractPipelineInput input) throws DITAOTException {
        AbstractPipelineModule module = this.factory.createModule(moduleClass);
        if (module != null) {
            module.setLogger(this.logger);
            return module.execute(input);
        }
        return null;
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }
}

