/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import org.dita.dost.platform.ExtensionPoint;
import org.dita.dost.platform.Features;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class DescParser
extends DefaultHandler {
    private static final String EXTENSION_POINT_ELEM = "extension-point";
    private static final String EXTENSION_POINT_NAME_ATTR = "name";
    private static final String EXTENSION_POINT_ID_ATTR = "id";
    private static final String TEMPLATE_ELEM = "template";
    private static final String TEMPLATE_FILE_ATTR = "file";
    private static final String META_ELEM = "meta";
    private static final String META_VALUE_ATTR = "value";
    private static final String META_TYPE_ATTR = "type";
    private static final String REQUIRE_ELEM = "require";
    private static final String REQUIRE_IMPORTANCE_ATTR = "importance";
    private static final String REQUIRE_PLUGIN_ATTR = "plugin";
    private static final String FEATURE_ELEM = "feature";
    private static final String FEATURE_ID_ATTR = "extension";
    private static final String PLUGIN_ELEM = "plugin";
    private static final String PLUGIN_ID_ATTR = "id";
    private String currentPlugin = null;
    private final Features features;

    public DescParser(File location, File ditaDir) {
        this.features = new Features(location, ditaDir);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("plugin".equals(qName)) {
            this.currentPlugin = attributes.getValue("id");
            this.features.setPluginId(this.currentPlugin);
        } else if (EXTENSION_POINT_ELEM.equals(qName)) {
            this.addExtensionPoint(attributes);
        } else if (FEATURE_ELEM.equals(qName)) {
            this.features.addFeature(attributes.getValue(FEATURE_ID_ATTR), attributes);
        } else if (REQUIRE_ELEM.equals(qName)) {
            this.features.addRequire(attributes.getValue("plugin"), attributes.getValue(REQUIRE_IMPORTANCE_ATTR));
        } else if (META_ELEM.equals(qName)) {
            this.features.addMeta(attributes.getValue(META_TYPE_ATTR), attributes.getValue(META_VALUE_ATTR));
        } else if (TEMPLATE_ELEM.equals(qName)) {
            this.features.addTemplate(attributes.getValue(TEMPLATE_FILE_ATTR));
        }
    }

    public Features getFeatures() {
        return this.features;
    }

    private void addExtensionPoint(Attributes atts) {
        String id = atts.getValue("id");
        if (id == null) {
            throw new IllegalArgumentException("id attribute not set on extension-point");
        }
        String name = atts.getValue(EXTENSION_POINT_NAME_ATTR);
        this.features.addExtensionPoint(new ExtensionPoint(id, name, this.currentPlugin));
    }
}

