/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dita.dost.platform.ExtensionPoint;
import org.dita.dost.platform.PluginRequirement;
import org.dita.dost.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

final class Features {
    private String id;
    private final File location;
    private final File ditaDir;
    private final Map<String, ExtensionPoint> extensionPoints;
    private final Hashtable<String, String> featureTable;
    private final List<PluginRequirement> requireList;
    private final Hashtable<String, String> metaTable;
    private final List<String> templateList;

    public Features(File location, File ditaDir) {
        this.location = location;
        this.ditaDir = ditaDir;
        this.extensionPoints = new HashMap<String, ExtensionPoint>();
        this.featureTable = new Hashtable(16);
        this.requireList = new ArrayList<PluginRequirement>(8);
        this.metaTable = new Hashtable(16);
        this.templateList = new ArrayList<String>(8);
    }

    public File getLocation() {
        return this.location;
    }

    public File getDitaDir() {
        return this.ditaDir;
    }

    void setPluginId(String id) {
        this.id = id;
    }

    String getPluginId() {
        return this.id;
    }

    Map<String, ExtensionPoint> getExtensionPoints() {
        return Collections.unmodifiableMap(this.extensionPoints);
    }

    public String getFeature(String id) {
        return this.featureTable.get(id);
    }

    public Map<String, String> getAllFeatures() {
        return this.featureTable;
    }

    void addExtensionPoint(ExtensionPoint extensionPoint) {
        this.extensionPoints.put(extensionPoint.id, extensionPoint);
    }

    @Deprecated
    public void addFeature(String id, String value, String type) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "value", "value", "CDATA", value);
        if (type != null) {
            atts.addAttribute("", "type", "type", "CDATA", type);
        }
        this.addFeature(id, atts);
    }

    public final void addFeature(String id, Attributes attributes) {
        boolean isFile;
        String value = attributes.getValue("file");
        if (value != null) {
            isFile = true;
        } else {
            value = attributes.getValue("value");
            isFile = "file".equals(attributes.getValue("type"));
        }
        StringTokenizer valueTokenizer = new StringTokenizer(value, ",");
        StringBuffer valueBuffer = new StringBuffer();
        if (this.featureTable.containsKey(id)) {
            valueBuffer.append(this.featureTable.get(id));
            valueBuffer.append(",");
        }
        while (valueTokenizer.hasMoreElements()) {
            String valueElement = valueTokenizer.nextToken();
            if (valueElement == null || valueElement.trim().length() == 0) continue;
            if (isFile && !FileUtils.isAbsolutePath(valueElement)) {
                valueBuffer.append(this.location).append(File.separatorChar);
            }
            valueBuffer.append(valueElement.trim());
            if (!valueTokenizer.hasMoreElements()) continue;
            valueBuffer.append(",");
        }
        this.featureTable.put(id, valueBuffer.toString());
    }

    public void addRequire(String id) {
        PluginRequirement requirement = new PluginRequirement();
        requirement.addPlugins(id);
        this.requireList.add(requirement);
    }

    public void addRequire(String id, String importance) {
        PluginRequirement requirement = new PluginRequirement();
        requirement.addPlugins(id);
        if (importance != null) {
            requirement.setRequired(importance.equals("required"));
        }
        this.requireList.add(requirement);
    }

    public Iterator<PluginRequirement> getRequireListIter() {
        return this.requireList.iterator();
    }

    public void addMeta(String type, String value) {
        this.metaTable.put(type, value);
    }

    public String getMeta(String type) {
        return this.metaTable.get(type);
    }

    public void addTemplate(String file) {
        this.templateList.add(file);
    }

    public List<String> getAllTemplates() {
        return this.templateList;
    }
}

