/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.IAction;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

final class FileGenerator
extends DefaultHandler2 {
    private static final String EXTENSION_ID_ATTR = "id";
    public static final String EXTENSION_ELEM = "extension";
    public static final String EXTENSION_ATTR = "extension";
    public static final String BEHAVIOR_ATTR = "behavior";
    public static final String PARAM_LOCALNAME = "localname";
    public static final String PARAM_TEMPLATE = "template";
    private static final String DITA_OT_NS = "http://dita-ot.sourceforge.net";
    private static final String TEMPLATE_PREFIX = "_template.";
    private final XMLReader reader;
    private DITAOTLogger logger;
    private OutputStreamWriter output = null;
    private final Map<String, String> featureTable;
    private final Map<String, Features> pluginTable;
    private File templateFile;

    public FileGenerator() {
        this(null, null);
    }

    public FileGenerator(Hashtable<String, String> featureTbl, Map<String, Features> pluginTable) {
        this.featureTable = featureTbl;
        this.pluginTable = pluginTable;
        this.output = null;
        this.templateFile = null;
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize parser: " + e.getMessage(), e);
        }
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(File fileName) {
        if (this.logger == null) {
            this.logger = new DITAOTJavaLogger();
        }
        File outputFile = this.removeTemplatePrefix(fileName);
        this.templateFile = fileName;
        try {
            FileOutputStream fileOutput = new FileOutputStream(outputFile);
            this.output = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.reader.parse(fileName.toURI().toString());
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    private File removeTemplatePrefix(File templateFile) {
        String f = templateFile.getAbsolutePath();
        int i = f.lastIndexOf(TEMPLATE_PREFIX);
        if (i != -1) {
            return new File(f.substring(0, i) + f.substring(i + TEMPLATE_PREFIX.length() - 1));
        }
        throw new IllegalArgumentException("File " + templateFile + " does not contain template prefix");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(StringUtils.escapeXML(ch, start, length));
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (!DITA_OT_NS.equals(uri) || !"extension".equals(localName)) {
                this.output.write("</");
                this.output.write(qName);
                this.output.write(">");
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        IAction action = null;
        try {
            if (DITA_OT_NS.equals(uri) && "extension".equals(localName)) {
                action = (IAction)Class.forName(attributes.getValue(BEHAVIOR_ATTR)).newInstance();
                action.setLogger(this.logger);
                action.addParam(PARAM_TEMPLATE, this.templateFile.getAbsolutePath());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    action.addParam(attributes.getLocalName(i), attributes.getValue(i));
                }
                String extension = attributes.getValue(EXTENSION_ID_ATTR);
                if (this.featureTable.containsKey(extension)) {
                    action.setInput(this.featureTable.get(extension));
                }
                action.setFeatures(this.pluginTable);
                this.output.write(action.getResult());
            } else {
                int attLen = attributes.getLength();
                this.output.write("<");
                this.output.write(qName);
                for (int i = 0; i < attLen; ++i) {
                    if (DITA_OT_NS.equals(attributes.getURI(i))) {
                        if ("extension".equals(attributes.getLocalName(i))) continue;
                        String extensions = attributes.getValue(DITA_OT_NS, "extension");
                        StringTokenizer extensionTokenizer = new StringTokenizer(extensions);
                        while (extensionTokenizer.hasMoreTokens()) {
                            String thisExtension = extensionTokenizer.nextToken();
                            String thisExtensionClass = extensionTokenizer.nextToken();
                            if (!thisExtension.equals(attributes.getLocalName(i))) continue;
                            action = (IAction)Class.forName(thisExtensionClass).newInstance();
                            break;
                        }
                        action.setLogger(this.logger);
                        action.setFeatures(this.pluginTable);
                        action.addParam(PARAM_TEMPLATE, this.templateFile.getAbsolutePath());
                        action.addParam(PARAM_LOCALNAME, attributes.getLocalName(i));
                        action.setInput(attributes.getValue(i));
                        this.output.write(action.getResult());
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("xmlns:") && DITA_OT_NS.equals(attributes.getValue(i))) continue;
                    this.output.write(" ");
                    this.output.write(new StringBuffer(attributes.getQName(i)).append("=\"").append(StringUtils.escapeXML(attributes.getValue(i))).append("\"").toString());
                }
                this.output.write(">");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
            this.output.close();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.logger.logError("Skipped entity " + name);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write("<!--");
            this.output.write(ch, start, length);
            this.output.write("-->");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }
}

