/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.util.Map;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.ImportAction;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;

final class ImportPluginCatalogAction
extends ImportAction {
    public static final String PLUGIN_URI_SCHEME = "plugin";

    @Override
    public String getResult() {
        StringBuffer buf = new StringBuffer();
        for (Map.Entry e : this.featureTable.entrySet()) {
            Features f = (Features)e.getValue();
            String name = "plugin:" + (String)e.getKey() + ":";
            StringBuilder location = new StringBuilder();
            if (Boolean.parseBoolean(f.getFeature("dita.basedir-resource-directory"))) {
                location.append("./");
            } else if (f.getLocation().getAbsolutePath().startsWith(f.getDitaDir().getAbsolutePath())) {
                location.append(FileUtils.getRelativePath(new File(f.getDitaDir(), "plugin.xml").toURI().toString(), f.getLocation().toURI().toString()));
            } else {
                location.append(f.getLocation().toURI().toString());
            }
            if (location.length() > 0 && !location.substring(location.length() - 1).equals("/")) {
                location.append("/");
            }
            buf.append("<rewriteURI uriStartString='").append(StringUtils.escapeXML(name)).append("' rewritePrefix='").append(StringUtils.escapeXML(location.toString())).append("'/>");
        }
        return buf.toString();
    }
}

