/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.IAction;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

class InsertAction
extends DefaultHandler2
implements IAction {
    protected final XMLReader reader;
    protected DITAOTLogger logger;
    protected final Set<String> fileNameSet = new LinkedHashSet<String>(16);
    protected final StringBuffer retBuf;
    protected final Hashtable<String, String> paramTable;
    protected int elemLevel = 0;
    protected boolean inCdataSection = false;
    protected String currentFile;

    public InsertAction() {
        this.logger = new DITAOTJavaLogger();
        this.retBuf = new StringBuffer(4096);
        this.paramTable = new Hashtable();
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize parser: " + e.getMessage(), e);
        }
    }

    @Override
    public void setInput(String input) {
        StringTokenizer inputTokenizer = new StringTokenizer(input, ",");
        while (inputTokenizer.hasMoreElements()) {
            this.fileNameSet.add(inputTokenizer.nextToken());
        }
    }

    @Override
    public void addParam(String name, String value) {
        this.paramTable.put(name, value);
    }

    @Override
    public String getResult() {
        try {
            Iterator<String> i$ = this.fileNameSet.iterator();
            while (i$.hasNext()) {
                String fileName;
                this.currentFile = fileName = i$.next();
                this.reader.parse(this.currentFile);
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        return this.retBuf.toString();
    }

    @Override
    public void setFeatures(Map<String, Features> h) {
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.elemLevel != 0) {
            int attLen = attributes.getLength();
            this.retBuf.append(Constants.LINE_SEPARATOR);
            this.retBuf.append("<").append(qName);
            for (int i = 0; i < attLen; ++i) {
                this.retBuf.append(" ").append(attributes.getQName(i)).append("=\"");
                this.retBuf.append(StringUtils.escapeXML(attributes.getValue(i))).append("\"");
            }
            if ("public".equals(localName) || "system".equals(localName) || "uri".equals(localName)) {
                this.retBuf.append("/>");
            } else {
                this.retBuf.append(">");
            }
        }
        ++this.elemLevel;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inCdataSection) {
            this.retBuf.append(ch, start, length);
        } else {
            char[] esc = StringUtils.escapeXML(ch, start, length).toCharArray();
            this.retBuf.append(esc, 0, esc.length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.elemLevel;
        if (!(this.elemLevel == 0 || "public".equals(localName) || "system".equals(localName) || "uri".equals(localName))) {
            this.retBuf.append("</").append(qName).append(">");
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.retBuf.append(ch, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
        this.elemLevel = 0;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.retBuf.append("<!--").append(ch, start, length).append("-->");
    }

    @Override
    public void startCDATA() throws SAXException {
        this.inCdataSection = true;
        this.retBuf.append("<![CDATA[");
    }

    @Override
    public void endCDATA() throws SAXException {
        this.retBuf.append("]]>");
        this.inCdataSection = false;
    }
}

