/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.platform.DescParser;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.FileGenerator;
import org.dita.dost.platform.PluginRequirement;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class Integrator {
    private static final String CONF_PLUGIN_IGNORES = "plugin.ignores";
    private static final String CONF_PLUGIN_DIRS = "plugindirs";
    public static final String FEAT_TOPIC_EXTENSIONS = "dita.topic.extensions";
    public static final String FEAT_MAP_EXTENSIONS = "dita.map.extensions";
    public static final String FEAT_IMAGE_EXTENSIONS = "dita.image.extensions";
    public static final String FEAT_HTML_EXTENSIONS = "dita.html.extensions";
    public static final String FEAT_RESOURCE_EXTENSIONS = "dita.resource.extensions";
    public static final String FEAT_PRINT_TRANSTYPES = "dita.transtype.print";
    public static final String FEAT_VALUE_SEPARATOR = ",";
    public static final String PARAM_VALUE_SEPARATOR = ";";
    public static final String PARAM_NAME_SEPARATOR = "=";
    private static final Pattern ID_PATTERN = Pattern.compile("[0-9a-zA-Z_\\-]+(?:\\.[0-9a-zA-Z_\\-]+)*");
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d+(?:\\.\\d+(?:\\.\\d+(?:\\.[0-9a-zA-Z_\\-])?)?)?");
    private final Map<String, Features> pluginTable;
    private final Set<String> templateSet = new HashSet<String>(16);
    private File ditaDir;
    private final Set<File> descSet;
    private final XMLReader reader;
    private DITAOTLogger logger;
    private final Set<String> loadedPlugin;
    private final Hashtable<String, String> featureTable;
    @Deprecated
    private File propertiesFile;
    private final Set<String> extensionPoints;
    private boolean strict = false;
    private Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.logger == null) {
            this.logger = new DITAOTJavaLogger();
        }
        this.properties = new Properties();
        if (this.propertiesFile != null) {
            FileInputStream propertiesStream = null;
            try {
                propertiesStream = new FileInputStream(this.propertiesFile);
                this.properties.load(propertiesStream);
            }
            catch (Exception e) {
                if (this.strict) {
                    throw new RuntimeException(e);
                }
                this.logger.logError(e.getMessage(), e);
            }
            finally {
                if (propertiesStream != null) {
                    try {
                        propertiesStream.close();
                    }
                    catch (IOException e) {
                        this.logger.logError(e.getMessage(), e);
                    }
                }
            }
        }
        if (!this.properties.containsKey(CONF_PLUGIN_DIRS)) {
            this.properties.setProperty(CONF_PLUGIN_DIRS, Configuration.configuration.containsKey(CONF_PLUGIN_DIRS) ? Configuration.configuration.get(CONF_PLUGIN_DIRS) : "plugins;demo");
        }
        if (!this.properties.containsKey(CONF_PLUGIN_IGNORES)) {
            this.properties.setProperty(CONF_PLUGIN_IGNORES, Configuration.configuration.containsKey(CONF_PLUGIN_IGNORES) ? Configuration.configuration.get(CONF_PLUGIN_IGNORES) : "");
        }
        String[] pluginDirs = this.properties.getProperty(CONF_PLUGIN_DIRS).split(PARAM_VALUE_SEPARATOR);
        HashSet<String> pluginIgnores = new HashSet<String>();
        if (this.properties.getProperty(CONF_PLUGIN_IGNORES) != null) {
            pluginIgnores.addAll(Arrays.asList(this.properties.getProperty(CONF_PLUGIN_IGNORES).split(PARAM_VALUE_SEPARATOR)));
        }
        for (String tmpl : this.properties.getProperty("templates", "").split(PARAM_VALUE_SEPARATOR)) {
            String t = tmpl.trim();
            if (t.length() == 0) continue;
            this.templateSet.add(t);
        }
        for (String pluginDir2 : pluginDirs) {
            File pluginDir = new File(pluginDir2);
            if (!pluginDir.isAbsolute()) {
                pluginDir = new File(this.ditaDir, pluginDir.getPath());
            }
            File[] pluginFiles = pluginDir.listFiles();
            for (int i = 0; pluginFiles != null && i < pluginFiles.length; ++i) {
                File f = pluginFiles[i];
                File descFile = new File(pluginFiles[i], "plugin.xml");
                if (!pluginFiles[i].isDirectory() || pluginIgnores.contains(f.getName()) || !descFile.exists()) continue;
                this.descSet.add(descFile);
            }
        }
        this.parsePlugin();
        this.integrate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void integrate() {
        String printTranstypeValue;
        String e;
        FileGenerator fileGen = new FileGenerator(this.featureTable, this.pluginTable);
        fileGen.setLogger(this.logger);
        for (String currentPlugin : this.pluginTable.keySet()) {
            this.loadPlugin(currentPlugin);
        }
        for (String template : this.templateSet) {
            File templateFile = new File(this.ditaDir, template);
            this.logger.logDebug("Process template " + templateFile.getPath());
            fileGen.generate(templateFile);
        }
        Properties configuration = new Properties();
        HashSet<String> imgExts = new HashSet<String>();
        for (String ext : this.properties.getProperty("supported_image_extensions", "").split(PARAM_VALUE_SEPARATOR)) {
            e = ext.trim();
            if (e.length() == 0) continue;
            imgExts.add(e);
        }
        if (this.featureTable.containsKey(FEAT_IMAGE_EXTENSIONS)) {
            for (String ext : this.featureTable.get(FEAT_IMAGE_EXTENSIONS).split(FEAT_VALUE_SEPARATOR)) {
                e = ext.trim();
                if (e.length() == 0) continue;
                imgExts.add(e);
            }
        }
        configuration.put("supported_image_extensions", StringUtils.assembleString(imgExts, PARAM_VALUE_SEPARATOR));
        configuration.put("supported_topic_extensions", this.readExtensions(FEAT_TOPIC_EXTENSIONS));
        configuration.put("supported_map_extensions", this.readExtensions(FEAT_MAP_EXTENSIONS));
        configuration.put("supported_html_extensions", this.readExtensions(FEAT_HTML_EXTENSIONS));
        configuration.put("supported_resource_extensions", this.readExtensions(FEAT_RESOURCE_EXTENSIONS));
        HashSet<String> printTranstypes = new HashSet<String>();
        if (this.featureTable.containsKey(FEAT_PRINT_TRANSTYPES)) {
            for (String ext : this.featureTable.get(FEAT_PRINT_TRANSTYPES).split(FEAT_VALUE_SEPARATOR)) {
                String e2 = ext.trim();
                if (e2.length() == 0) continue;
                printTranstypes.add(e2);
            }
        }
        if ((printTranstypeValue = this.properties.getProperty("print_transtypes")) != null) {
            printTranstypes.addAll(Arrays.asList(printTranstypeValue.split(PARAM_VALUE_SEPARATOR)));
        }
        configuration.put("print_transtypes", StringUtils.assembleString(printTranstypes, PARAM_VALUE_SEPARATOR));
        OutputStream out = null;
        try {
            File outFile = new File(this.ditaDir, "lib" + File.separator + this.getClass().getPackage().getName() + File.separator + "plugin.properties");
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new RuntimeException("Failed to make directory " + outFile.getParentFile().getAbsolutePath());
            }
            this.logger.logDebug("Generate configuration properties " + outFile.getPath());
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            configuration.store(out, "DITA-OT runtime configuration, do not edit manually");
        }
        catch (Exception e3) {
            if (this.strict) {
                throw new RuntimeException("Failed to write configuration properties: " + e3.getMessage(), e3);
            }
            this.logger.logError(e3.getMessage(), e3);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e4) {
                    this.logger.logError(e4.getMessage(), e4);
                }
            }
        }
    }

    private String readExtensions(String featureName) {
        HashSet<String> exts = new HashSet<String>();
        if (this.featureTable.containsKey(featureName)) {
            for (String ext : this.featureTable.get(featureName).split(FEAT_VALUE_SEPARATOR)) {
                String e = ext.trim();
                if (e.length() == 0) continue;
                exts.add(e);
            }
        }
        return StringUtils.assembleString(exts, PARAM_VALUE_SEPARATOR);
    }

    private boolean loadPlugin(String plugin) {
        if (this.checkPlugin(plugin)) {
            Features pluginFeatures = this.pluginTable.get(plugin);
            Map<String, String> featureSet = pluginFeatures.getAllFeatures();
            for (Map.Entry<String, String> currentFeature : featureSet.entrySet()) {
                if (!this.extensionPoints.contains(currentFeature.getKey())) {
                    String msg = "Plug-in " + plugin + " uses an undefined extension point " + currentFeature.getKey();
                    if (this.strict) {
                        throw new RuntimeException(msg);
                    }
                    this.logger.logDebug(msg);
                }
                if (this.featureTable.containsKey(currentFeature.getKey())) {
                    String value = this.featureTable.remove(currentFeature.getKey());
                    this.featureTable.put(currentFeature.getKey(), new StringBuffer(value).append(FEAT_VALUE_SEPARATOR).append(currentFeature.getValue()).toString());
                    continue;
                }
                this.featureTable.put(currentFeature.getKey(), currentFeature.getValue());
            }
            for (String templateName : pluginFeatures.getAllTemplates()) {
                this.templateSet.add(FileUtils.getRelativePath(this.ditaDir + File.separator + "dummy", pluginFeatures.getLocation() + File.separator + templateName));
            }
            this.loadedPlugin.add(plugin);
            return true;
        }
        return false;
    }

    private boolean checkPlugin(String currentPlugin) {
        Features pluginFeatures = this.pluginTable.get(currentPlugin);
        Iterator<PluginRequirement> iter = pluginFeatures.getRequireListIter();
        while (iter.hasNext()) {
            boolean anyPluginFound = false;
            PluginRequirement requirement = iter.next();
            Iterator<String> requiredPluginIter = requirement.getPlugins();
            while (requiredPluginIter.hasNext()) {
                String requiredPlugin = requiredPluginIter.next();
                if (!this.pluginTable.containsKey(requiredPlugin)) continue;
                if (!this.loadedPlugin.contains(requiredPlugin)) {
                    this.loadPlugin(requiredPlugin);
                }
                anyPluginFound = true;
            }
            if (anyPluginFound || !requirement.getRequired()) continue;
            String msg = MessageUtils.getInstance().getMessage("DOTJ020W", requirement.toString(), currentPlugin).toString();
            if (this.strict) {
                throw new RuntimeException(msg);
            }
            this.logger.logWarn(msg);
            return false;
        }
        return true;
    }

    private void parsePlugin() {
        if (!this.descSet.isEmpty()) {
            for (File descFile : this.descSet) {
                this.logger.logDebug("Read plug-in configuration " + descFile.getPath());
                this.parseDesc(descFile);
            }
        }
    }

    private void parseDesc(File descFile) {
        try {
            DescParser parser = new DescParser(descFile.getParentFile(), this.ditaDir);
            this.reader.setContentHandler(parser);
            this.reader.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            this.reader.parse(descFile.getAbsolutePath());
            Features f = parser.getFeatures();
            String id = f.getPluginId();
            this.validatePlugin(f);
            this.setDefaultValues(f);
            this.extensionPoints.addAll(f.getExtensionPoints().keySet());
            this.pluginTable.put(id, f);
        }
        catch (SAXParseException e) {
            RuntimeException ex = new RuntimeException("Failed to parse " + descFile.getAbsolutePath() + ": " + e.getMessage(), e);
            if (this.strict) {
                throw ex;
            }
            this.logger.logError(ex.getMessage(), ex);
        }
        catch (Exception e) {
            if (this.strict) {
                throw new RuntimeException(e);
            }
            this.logger.logError(e.getMessage(), e);
        }
    }

    private void validatePlugin(Features f) {
        String version;
        String id = f.getPluginId();
        if (!ID_PATTERN.matcher(id).matches()) {
            String msg = "Plug-in ID '" + id + "' doesn't follow recommended syntax rules, support for nonconforming IDs may be removed in future releases.";
            if (this.strict) {
                throw new IllegalArgumentException(msg);
            }
            this.logger.logWarn(msg);
        }
        if ((version = f.getFeature("package.version")) != null && !VERSION_PATTERN.matcher(version).matches()) {
            String msg = "Plug-in version '" + version + "' doesn't follow recommended syntax rules, support for nonconforming version may be removed in future releases.";
            if (this.strict) {
                throw new IllegalArgumentException(msg);
            }
            this.logger.logWarn(msg);
        }
    }

    private void setDefaultValues(Features f) {
        if (f.getFeature("package.version") == null) {
            f.addFeature("package.version", "0.0.0", null);
        }
    }

    public Integrator() {
        this.pluginTable = new HashMap<String, Features>(16);
        this.descSet = new HashSet<File>(16);
        this.loadedPlugin = new HashSet<String>(16);
        this.featureTable = new Hashtable(16);
        this.extensionPoints = new HashSet<String>();
        try {
            this.reader = StringUtils.getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    public void setDitaDir(File ditadir) {
        this.ditaDir = ditadir;
    }

    public void setProperties(File propertiesfile) {
        this.propertiesFile = propertiesfile;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    static final String getValue(Map<String, Features> featureTable, String extension) {
        ArrayList<String> buf = new ArrayList<String>();
        for (Features f : featureTable.values()) {
            String v = f.getFeature(extension);
            if (v == null) continue;
            buf.add(v);
        }
        if (buf.isEmpty()) {
            return null;
        }
        return StringUtils.assembleString(buf, FEAT_VALUE_SEPARATOR);
    }

    public static void main(String[] args) {
        Integrator abc = new Integrator();
        File currentDir = new File(".");
        abc.setDitaDir(currentDir);
        abc.setProperties(new File("integrator.properties"));
        abc.execute();
    }
}

