/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlPropertyTask
extends Task {
    private File src;
    private String prefix = "";
    private boolean validate = false;
    private final boolean collapseAttributes = false;
    private File rootDirectory = null;
    private final FileUtils fileUtils = FileUtils.getFileUtils();
    private final XMLCatalog xmlCatalog = new XMLCatalog();
    private final Properties props = new Properties();
    private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";
    private static final String EXTERNAL_XML_VERSION = "1.0";

    public void init() {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected EntityResolver getEntityResolver() {
        return this.xmlCatalog;
    }

    public void execute() throws BuildException {
        if (this.getFile() == null) {
            String msg = "XmlProperty task requires a file attribute";
            throw new BuildException("XmlProperty task requires a file attribute");
        }
        InputStream in = null;
        try {
            this.log("Loading " + this.src.getAbsolutePath(), 3);
            if (this.src.exists()) {
                in = new FileInputStream(this.src);
                this.load(in);
            } else {
                this.log("Unable to find property file: " + this.src.getAbsolutePath(), 3);
            }
        }
        catch (SAXException se) {
            throw new BuildException((Throwable)se);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.log(e, 0);
                }
            }
        }
    }

    private void load(InputStream in) throws IOException, SAXException {
        int start;
        int numEntries;
        Document doc = XmlPropertyTask.getLoadingDoc(in);
        Element propertiesElement = (Element)doc.getChildNodes().item(1);
        String xmlVersion = propertiesElement.getAttribute("version");
        if (xmlVersion.compareTo(EXTERNAL_XML_VERSION) > 0) {
            throw new SAXException("Exported Properties file format version " + xmlVersion + " is not supported. This java installation can read" + " versions " + EXTERNAL_XML_VERSION + " or older. You" + " may need to install a newer version of JDK.");
        }
        for (int i = start = (numEntries = (entries = propertiesElement.getChildNodes()).getLength()) > 0 && entries.item(0).getNodeName().equals("comment") ? 1 : 0; i < numEntries; ++i) {
            NodeList entries;
            Element entry = (Element)entries.item(i);
            if (!entry.hasAttribute("key")) continue;
            Node n = entry.getFirstChild();
            String val = n == null ? "" : n.getNodeValue();
            this.props.setProperty(entry.getAttribute("key"), val);
            this.addProperty(entry.getAttribute("key"), val, null);
        }
    }

    static Document getLoadingDoc(InputStream in) throws SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new Resolver());
            db.setErrorHandler(new EH());
            InputSource is = new InputSource(in);
            return db.parse(is);
        }
        catch (ParserConfigurationException x) {
            throw new Error(x);
        }
    }

    private void addProperty(String name, String value, String id) {
        String msg = name + ":" + value;
        if (id != null) {
            msg = msg + "(id=" + id + ")";
        }
        this.log(msg, 4);
        this.getProject().setProperty(name, value);
        if (id != null) {
            this.getProject().addReference(id, (Object)value);
        }
    }

    public void setFile(File src) {
        this.src = src;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix.trim();
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(catalog);
    }

    protected File getFile() {
        return this.src;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected boolean getValidate() {
        return this.validate;
    }

    protected boolean getCollapseAttributes() {
        return false;
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        @Override
        public void error(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void fatalError(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void warning(SAXParseException x) throws SAXException {
            throw x;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (sid.equals(XmlPropertyTask.PROPS_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(XmlPropertyTask.PROPS_DTD));
                is.setSystemId(XmlPropertyTask.PROPS_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + sid);
        }
    }
}

