/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.ChunkTopicParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class ChunkMapReader
implements AbstractReader {
    public static final String FILE_NAME_STUB_DITAMAP = "stub.ditamap";
    public static final String FILE_EXTENSION_CHUNK = ".chunk";
    public static final String ATTR_XTRF_VALUE_GENERATED = "generated_by_chunk";
    public static final String CHUNK_BY_DOCUMENT = "by-document";
    public static final String CHUNK_BY_TOPIC = "by-topic";
    public static final String CHUNK_TO_CONTENT = "to-content";
    public static final String CHUNK_TO_NAVIGATION = "to-navigation";
    private DITAOTLogger logger;
    private boolean chunkByTopic = false;
    private String filePath = null;
    private LinkedHashMap<String, String> changeTable = new LinkedHashMap(128);
    private Hashtable<String, String> conflictTable = null;
    private final Random random;
    private Set<String> refFileSet = new HashSet<String>(128);
    private String ditaext = null;
    private String transtype = null;
    private ProcessingInstruction workdir = null;
    private ProcessingInstruction workdirUrl = null;
    private ProcessingInstruction path2proj = null;
    private String processingRole = "normal";

    public ChunkMapReader() {
        this.conflictTable = new Hashtable(128);
        this.random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(String filename) {
        File inputFile = new File(filename);
        this.filePath = inputFile.getParent();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputFile);
            NodeList docNodes = doc.getChildNodes();
            for (int i = 0; i < docNodes.getLength(); ++i) {
                Node node = docNodes.item(i);
                if (node.getNodeType() != 7) continue;
                ProcessingInstruction pi = (ProcessingInstruction)node;
                if (pi.getNodeName() == "workdir") {
                    this.workdir = pi;
                }
                if (pi.getNodeName() == "workdir-uri") {
                    this.workdirUrl = pi;
                    continue;
                }
                if (!pi.getNodeName().equals("path2project")) continue;
                this.path2proj = pi;
            }
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            String rootChunkValue = root.getAttribute("chunk");
            this.chunkByTopic = rootChunkValue != null && rootChunkValue.contains(CHUNK_BY_TOPIC);
            if (rootChunkValue != null && rootChunkValue.indexOf(CHUNK_TO_CONTENT) != -1) {
                String newFilename = inputFile.getName().substring(0, inputFile.getName().indexOf(".ditamap")) + this.ditaext;
                File newFile = new File(inputFile.getParentFile().getAbsolutePath(), newFilename);
                if (newFile.exists()) {
                    newFilename = this.generateFilename("Chunk", this.ditaext);
                    String oldpath = newFile.getAbsolutePath();
                    newFile = new File(FileUtils.resolveFile(inputFile.getParentFile().getAbsolutePath(), newFilename));
                    this.conflictTable.put(newFile.getAbsolutePath(), FileUtils.normalize(oldpath));
                }
                String originClassValue = root.getAttribute("class");
                root.setAttribute("class", originClassValue + Constants.MAP_TOPICREF.matcher);
                root.setAttribute("href", newFilename);
                OutputStreamWriter newFileWriter = null;
                try {
                    newFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8");
                    newFileWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    newFileWriter.write("<");
                    newFileWriter.write("?");
                    newFileWriter.write("workdir");
                    newFileWriter.write(" ");
                    newFileWriter.write("/");
                    newFileWriter.write(newFile.getParentFile().getAbsolutePath());
                    newFileWriter.write("?");
                    newFileWriter.write(">");
                    newFileWriter.write("<");
                    newFileWriter.write("?");
                    newFileWriter.write("workdir-uri");
                    newFileWriter.write(" ");
                    newFileWriter.write("/");
                    newFileWriter.write(newFile.getParentFile().toURI().toString());
                    newFileWriter.write("?");
                    newFileWriter.write(">");
                    newFileWriter.write("<dita></dita>");
                    newFileWriter.flush();
                    newFileWriter.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
                finally {
                    try {
                        if (newFileWriter != null) {
                            newFileWriter.close();
                        }
                    }
                    catch (Exception e) {
                        this.logger.logError(e.getMessage(), e);
                    }
                }
                this.processTopicref(root);
                this.changeTable.put(newFile.getAbsolutePath(), newFile.getAbsolutePath());
                if (originClassValue != null) {
                    root.setAttribute("class", originClassValue);
                }
                root.removeAttribute("href");
            } else {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element currentElem = (Element)node;
                    Node classAttr = node.getAttributes().getNamedItem("class");
                    String classValue = null;
                    if (classAttr != null) {
                        classValue = classAttr.getNodeValue();
                    }
                    if (classValue != null && Constants.MAP_RELTABLE.matches(classValue)) {
                        this.updateReltable(currentElem);
                    }
                    if (classValue == null || !Constants.MAP_TOPICREF.matches(classValue) || Constants.MAPGROUP_D_TOPICGROUP.matches(classValue)) continue;
                    this.processTopicref(currentElem);
                }
            }
            this.outputMapFile(inputFile.getAbsolutePath() + FILE_EXTENSION_CHUNK, root);
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), inputFile.getAbsolutePath() + FILE_EXTENSION_CHUNK).toString());
            }
            if (!new File(inputFile.getAbsolutePath() + FILE_EXTENSION_CHUNK).renameTo(inputFile)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), inputFile.getAbsolutePath() + FILE_EXTENSION_CHUNK).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private String generateFilename(String prefix, String extension) {
        return prefix + this.random.nextInt(Integer.MAX_VALUE) + extension;
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputMapFile(String file, Element root) {
        OutputStreamWriter output = null;
        try {
            output = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            if (this.workdir != null) {
                this.output(this.workdir, (Writer)output);
            }
            if (this.workdirUrl != null) {
                this.output(this.workdirUrl, (Writer)output);
            }
            if (this.path2proj != null) {
                this.output(this.path2proj, (Writer)output);
            }
            this.output(root, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    private void output(ProcessingInstruction instruction, Writer outputWriter) throws IOException {
        outputWriter.write("<");
        outputWriter.write("?");
        outputWriter.write(instruction.getTarget());
        outputWriter.write(" ");
        outputWriter.write(instruction.getData());
        outputWriter.write("?");
        outputWriter.write(">");
    }

    private void output(Text text, Writer outputWriter) throws IOException {
        outputWriter.write(StringUtils.escapeXML(text.getData()));
    }

    private void output(Element elem, Writer outputWriter) throws IOException {
        outputWriter.write("<");
        outputWriter.write(elem.getNodeName());
        NamedNodeMap attrMap = elem.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            outputWriter.write(" ");
            outputWriter.write(attrMap.item(i).getNodeName());
            outputWriter.write("=");
            outputWriter.write("\"");
            outputWriter.write(StringUtils.escapeXML(attrMap.item(i).getNodeValue()));
            outputWriter.write("\"");
        }
        outputWriter.write(">");
        NodeList children = elem.getChildNodes();
        block6: for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            switch (child.getNodeType()) {
                case 3: {
                    this.output((Text)child, outputWriter);
                    continue block6;
                }
                case 7: {
                    this.output((ProcessingInstruction)child, outputWriter);
                    continue block6;
                }
                case 1: {
                    this.output((Element)child, outputWriter);
                }
            }
        }
        outputWriter.write("<");
        outputWriter.write("/");
        outputWriter.write(elem.getNodeName());
        outputWriter.write(">");
    }

    private void processTopicref(Element node) {
        String hrefValue = null;
        String chunkValue = null;
        String copytoValue = null;
        String scopeValue = null;
        String classValue = null;
        String xtrfValue = null;
        String processValue = null;
        String tempRole = this.processingRole;
        boolean prevChunkByTopic = false;
        Attr hrefAttr = node.getAttributeNode("href");
        Attr chunkAttr = node.getAttributeNode("chunk");
        Attr copytoAttr = node.getAttributeNode("copy-to");
        Attr scopeAttr = node.getAttributeNode("scope");
        Attr classAttr = node.getAttributeNode("class");
        Attr xtrfAttr = node.getAttributeNode("xtrf");
        Attr processAttr = node.getAttributeNode("processing-role");
        if (hrefAttr != null) {
            hrefValue = hrefAttr.getNodeValue();
        }
        if (chunkAttr != null) {
            chunkValue = chunkAttr.getNodeValue();
        }
        if (copytoAttr != null) {
            copytoValue = copytoAttr.getNodeValue();
        }
        if (scopeAttr != null) {
            scopeValue = scopeAttr.getNodeValue();
        }
        if (classAttr != null) {
            classValue = classAttr.getNodeValue();
        }
        if (xtrfAttr != null) {
            xtrfValue = xtrfAttr.getNodeValue();
        }
        if (processAttr != null) {
            this.processingRole = processValue = processAttr.getNodeValue();
        }
        if (xtrfValue != null && xtrfValue.contains(ATTR_XTRF_VALUE_GENERATED)) {
            return;
        }
        if (chunkValue != null && (chunkValue.contains(CHUNK_BY_TOPIC) || chunkValue.contains(CHUNK_BY_DOCUMENT))) {
            prevChunkByTopic = this.chunkByTopic;
            this.chunkByTopic = chunkValue.contains(CHUNK_BY_TOPIC);
        }
        if ("external".equalsIgnoreCase(scopeValue) || hrefValue != null && !FileUtils.fileExists(FileUtils.resolveFile(this.filePath, hrefValue)) || Constants.MAPGROUP_D_TOPICHEAD.matches(classValue) && chunkValue == null || Constants.MAP_TOPICREF.matches(classValue) && chunkValue == null && hrefValue == null) {
            if (chunkValue != null && (chunkValue.contains(CHUNK_BY_TOPIC) || chunkValue.contains(CHUNK_BY_DOCUMENT))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
        } else if (chunkValue != null && chunkValue.indexOf(CHUNK_TO_CONTENT) != -1 && (hrefAttr != null || copytoAttr != null || node.hasChildNodes())) {
            this.processChunk(node, false, this.chunkByTopic);
        } else if (chunkValue != null && chunkValue.indexOf(CHUNK_TO_NAVIGATION) != -1 && "eclipsehelp".equals(this.transtype)) {
            if (chunkValue != null && (chunkValue.contains(CHUNK_BY_TOPIC) || chunkValue.contains(CHUNK_BY_DOCUMENT))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
            Node root = node.getOwnerDocument().getDocumentElement().cloneNode(false);
            Element navref = node.getOwnerDocument().createElement(Constants.MAP_NAVREF.localName);
            String newMapFile = this.generateFilename("MAPCHUNK", ".ditamap");
            navref.setAttribute(Constants.MAPGROUP_D_MAPREF.localName, newMapFile);
            navref.setAttribute("class", Constants.MAP_NAVREF.toString());
            node.getParentNode().replaceChild(navref, node);
            root.appendChild(node);
            String navmap = FileUtils.resolveFile(this.filePath, newMapFile);
            this.changeTable.put(navmap, navmap);
            this.outputMapFile(navmap, (Element)root);
        } else if (this.chunkByTopic) {
            this.processChunk(node, true, this.chunkByTopic);
            if (chunkValue != null && (chunkValue.contains(CHUNK_BY_TOPIC) || chunkValue.contains(CHUNK_BY_DOCUMENT))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
        } else {
            String currentPath = null;
            if (copytoValue != null) {
                currentPath = FileUtils.resolveFile(this.filePath, copytoValue);
            } else if (hrefValue != null) {
                currentPath = FileUtils.resolveFile(this.filePath, hrefValue);
            }
            if (currentPath != null) {
                if (this.changeTable.containsKey(currentPath)) {
                    this.changeTable.remove(currentPath);
                }
                if (!this.refFileSet.contains(currentPath)) {
                    this.refFileSet.add(currentPath);
                }
            }
            if (!(chunkValue == null && this.chunkByTopic || currentPath == null || "resource-only".equals(this.processingRole))) {
                this.changeTable.put(currentPath, currentPath);
            }
            if (chunkValue != null && (chunkValue.contains(CHUNK_BY_TOPIC) || chunkValue.contains(CHUNK_BY_DOCUMENT))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
        }
        if (chunkValue != null && (chunkValue.contains(CHUNK_BY_TOPIC) || chunkValue.contains(CHUNK_BY_DOCUMENT))) {
            this.chunkByTopic = prevChunkByTopic;
        }
        this.processingRole = tempRole;
    }

    private void processChildTopicref(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (current.getNodeType() != 1) continue;
            Element currentElem = (Element)current;
            String classValue = currentElem.getAttribute("class");
            String hrefValue = currentElem.getAttribute("href");
            String xtrfValue = currentElem.getAttribute("xtrf");
            if (!Constants.MAP_TOPICREF.matches(classValue)) continue;
            if (hrefValue.length() != 0 && !ATTR_XTRF_VALUE_GENERATED.equals(xtrfValue) && !FileUtils.resolveFile(this.filePath, hrefValue).equals(this.changeTable.get(FileUtils.resolveFile(this.filePath, hrefValue))) || Constants.MAPGROUP_D_TOPICHEAD.matches(classValue)) {
                this.processTopicref(currentElem);
                continue;
            }
            if (hrefValue.length() != 0) continue;
            this.processTopicref(currentElem);
        }
    }

    private void processChunk(Element elem, boolean separate, boolean chunkByTopic) {
        try {
            ChunkTopicParser chunkParser = new ChunkTopicParser();
            chunkParser.setLogger(this.logger);
            chunkParser.setup(this.changeTable, this.conflictTable, this.refFileSet, elem, separate, chunkByTopic, this.ditaext);
            chunkParser.write(this.filePath);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private void updateReltable(Element elem) {
        String hrefValue = elem.getAttribute("href");
        if (hrefValue.length() != 0 && this.changeTable.containsKey(FileUtils.resolveFile(this.filePath, hrefValue))) {
            String resulthrefValue = null;
            resulthrefValue = hrefValue.indexOf("#") != -1 ? FileUtils.getRelativePath(this.filePath + "/" + FILE_NAME_STUB_DITAMAP, FileUtils.resolveFile(this.filePath, hrefValue)) + hrefValue.substring(hrefValue.indexOf("#") + 1) : FileUtils.getRelativePath(this.filePath + "/" + FILE_NAME_STUB_DITAMAP, FileUtils.resolveFile(this.filePath, hrefValue));
            elem.setAttribute("href", resulthrefValue);
        }
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element currentElem;
            String classValue;
            Node current = children.item(i);
            if (current.getNodeType() == 1 && !Constants.MAP_TOPICREF.matches(classValue = (currentElem = (Element)current).getAttribute("class"))) continue;
        }
    }

    @Override
    @Deprecated
    public Content getContent() {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getChangeTable() {
        return Collections.unmodifiableMap(this.changeTable);
    }

    public Hashtable<String, String> getConflicTable() {
        return this.conflictTable;
    }

    public void setup(String ditaext, String transtype) {
        this.ditaext = ditaext;
        this.transtype = transtype;
    }
}

