/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ConrefPushReader
extends AbstractXMLReader {
    private static final String ATTR_CONACTION_VALUE_MARK = "mark";
    private static final String ATTR_CONACTION_VALUE_PUSHAFTER = "pushafter";
    private static final String ATTR_CONACTION_VALUE_PUSHBEFORE = "pushbefore";
    private static final String ATTR_CONACTION_VALUE_PUSHREPLACE = "pushreplace";
    private final Hashtable<String, Hashtable<String, String>> pushtable = new Hashtable();
    private final XMLReader reader;
    private boolean needResolveEntity = true;
    private String filePath = null;
    private String parsefilename = null;
    private StringBuffer pushcontent = null;
    private boolean start = false;
    private int level = 0;
    private String target = null;
    private String pushType = null;

    public Map<String, Hashtable<String, String>> getPushMap() {
        return Collections.unmodifiableMap(this.pushtable);
    }

    @Override
    public void read(String filename) {
        this.filePath = new File(filename).getParentFile().getAbsolutePath();
        this.parsefilename = new File(filename).getName();
        this.start = false;
        this.pushcontent = new StringBuffer(256);
        this.pushType = null;
        try {
            this.reader.parse(new File(filename).toURI().toString());
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    public ConrefPushReader() {
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
            this.needResolveEntity = true;
            this.reader.setContentHandler(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.start) {
            ++this.level;
            this.putElement(this.pushcontent, name, atts, false);
        }
        String conactValue = atts.getValue("conaction");
        if (!this.start && conactValue != null) {
            if (ATTR_CONACTION_VALUE_PUSHBEFORE.equalsIgnoreCase(conactValue)) {
                if (this.pushcontent.length() != 0) {
                    this.pushcontent = new StringBuffer();
                    this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTJ044W", atts.getValue("xtrf"), atts.getValue("xtrc")).toString());
                }
                this.start = true;
                this.level = 0;
                ++this.level;
                this.putElement(this.pushcontent, name, atts, true);
                this.pushType = ATTR_CONACTION_VALUE_PUSHBEFORE;
            } else if (ATTR_CONACTION_VALUE_PUSHAFTER.equalsIgnoreCase(conactValue)) {
                this.start = true;
                this.level = 0;
                ++this.level;
                if (this.target == null) {
                    this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ039E", atts.getValue("xtrf"), atts.getValue("xtrc")).toString());
                } else {
                    this.putElement(this.pushcontent, name, atts, true);
                    this.pushType = ATTR_CONACTION_VALUE_PUSHAFTER;
                }
            } else if (ATTR_CONACTION_VALUE_PUSHREPLACE.equalsIgnoreCase(conactValue)) {
                this.start = true;
                this.level = 0;
                ++this.level;
                this.target = atts.getValue("conref");
                if (this.target == null) {
                    this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ040E", atts.getValue("xtrf"), atts.getValue("xtrc")).toString());
                } else {
                    this.pushType = ATTR_CONACTION_VALUE_PUSHREPLACE;
                    this.putElement(this.pushcontent, name, atts, true);
                }
            } else if (ATTR_CONACTION_VALUE_MARK.equalsIgnoreCase(conactValue)) {
                this.target = atts.getValue("conref");
                if (this.target != null && this.pushcontent != null && this.pushcontent.length() > 0 && ATTR_CONACTION_VALUE_PUSHBEFORE.equals(this.pushType)) {
                    this.replaceContent();
                    this.addtoPushTable(this.target, this.pushcontent.toString(), this.pushType);
                    this.pushcontent = new StringBuffer(256);
                    this.target = null;
                    this.pushType = null;
                }
            }
        }
    }

    private void replaceContent() {
        int index = 0;
        int nextindex = 0;
        int hrefindex = this.pushcontent.indexOf("href=\"", index);
        int conrefindex = this.pushcontent.indexOf("conref=\"", index);
        StringBuffer resultBuffer = new StringBuffer(256);
        if (hrefindex < 0 && conrefindex < 0) {
            return;
        }
        while (hrefindex >= 0 || conrefindex >= 0) {
            if (hrefindex > 0 && conrefindex > 0) {
                nextindex = hrefindex < conrefindex ? hrefindex : conrefindex;
            } else if (hrefindex > 0) {
                nextindex = hrefindex;
            } else if (conrefindex > 0) {
                nextindex = conrefindex;
            }
            int valueindex = this.pushcontent.indexOf("\"", nextindex) + 1;
            resultBuffer.append(this.pushcontent.substring(index, valueindex));
            resultBuffer.append(this.replaceURL(this.pushcontent.substring(valueindex, this.pushcontent.indexOf("\"", valueindex))));
            index = this.pushcontent.indexOf("\"", valueindex);
            if (hrefindex > 0) {
                hrefindex = this.pushcontent.indexOf("href=\"", index);
            }
            if (conrefindex <= 0) continue;
            conrefindex = this.pushcontent.indexOf("conref=\"", index);
        }
        resultBuffer.append(this.pushcontent.substring(index));
        this.pushcontent = resultBuffer;
    }

    private void putElement(StringBuffer buf, String elemName, Attributes atts, boolean removeConref) {
        int index = 0;
        buf.append("<").append(elemName);
        for (index = 0; index < atts.getLength(); ++index) {
            if (removeConref && ("conref".equals(atts.getQName(index)) || "conaction".equals(atts.getQName(index)))) continue;
            buf.append(" ");
            buf.append(atts.getQName(index)).append("=").append("\"");
            String value = atts.getValue(index);
            value = StringUtils.escapeXML(value);
            if ("href".equals(atts.getQName(index)) || "conref".equals(atts.getQName(index))) {
                value = this.replaceURL(value);
            }
            buf.append(value).append("\"");
        }
        if (ATTR_CONACTION_VALUE_PUSHREPLACE.equals(this.pushType) && atts.getValue("id") == null && this.level == 1) {
            int sharpIndex = this.target.indexOf("#");
            if (sharpIndex == -1) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ041E", this.target).toString());
            } else {
                String targetLoc = this.target.substring(sharpIndex + 1);
                String id = "";
                id = targetLoc.contains("/") ? targetLoc.substring(targetLoc.lastIndexOf("/") + 1) : targetLoc;
                buf.append(" ");
                buf.append("id").append("=").append("\"");
                buf.append(id).append("\"");
            }
        }
        buf.append(">");
    }

    private String replaceURL(String value) {
        if (value == null) {
            return null;
        }
        if (this.target == null || FileUtils.isAbsolutePath(value) || value.contains("://") || value.startsWith("#")) {
            return value;
        }
        String source = FileUtils.resolveFile(this.filePath, this.target);
        String urltarget = FileUtils.resolveTopic(this.filePath, value);
        return FileUtils.getRelativePath(source, urltarget);
    }

    private void addtoPushTable(String target, String pushcontent, String type) {
        int sharpIndex = target.indexOf("#");
        if (sharpIndex == -1) {
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ041E", target).toString());
            return;
        }
        if (sharpIndex == 0) {
            target = this.parsefilename + target;
            sharpIndex = target.indexOf("#");
        }
        String key = FileUtils.resolveFile(this.filePath, target);
        Hashtable<Object, Object> table = null;
        if (this.pushtable.containsKey(key)) {
            table = this.pushtable.get(key);
        } else {
            table = new Hashtable();
            this.pushtable.put(key, table);
        }
        String targetLoc = target.substring(sharpIndex);
        String addon = "|" + type;
        if (table.containsKey(targetLoc + addon)) {
            if (ATTR_CONACTION_VALUE_PUSHREPLACE.equalsIgnoreCase(type)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ042E", target).toString());
                return;
            }
            table.put(targetLoc + addon, (String)table.get(targetLoc + addon) + pushcontent);
        } else {
            table.put(targetLoc + addon, pushcontent);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.start && this.needResolveEntity) {
            this.pushcontent.append(StringUtils.escapeXML(ch, start, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.start) {
            --this.level;
            this.pushcontent.append("<").append("/").append(name).append(">");
        }
        if (this.level == 0) {
            this.start = false;
            if ((ATTR_CONACTION_VALUE_PUSHAFTER.equals(this.pushType) || ATTR_CONACTION_VALUE_PUSHREPLACE.equals(this.pushType)) && this.target != null) {
                this.addtoPushTable(this.target, this.pushcontent.toString(), this.pushType);
                this.pushcontent = new StringBuffer(256);
                this.target = null;
                this.pushType = null;
            }
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.pushcontent.append(StringUtils.getEntity(name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }
}

