/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DitaValReader
extends AbstractXMLReader {
    private final Map<FilterUtils.FilterKey, FilterUtils.Action> filterMap = new HashMap<FilterUtils.FilterKey, FilterUtils.Action>();
    private ContentImpl content = null;
    private XMLReader reader;
    private final List<String> imageList = new ArrayList<String>(256);
    private String ditaVal = null;
    private Map<String, Map<String, Set<Element>>> bindingMap;
    private final List<String> relFlagImageList = new ArrayList<String>(256);
    private boolean setSystemid = true;

    public DitaValReader() {
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    public void setSubjectScheme(Map<String, Map<String, Set<Element>>> bindingMap) {
        this.bindingMap = bindingMap;
    }

    public void initXMLReader(boolean arg_setSystemid) {
        this.setSystemid = arg_setSystemid;
        this.reader.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
    }

    @Override
    public void read(String input) {
        this.ditaVal = input;
        try {
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(this.ditaVal, this.logger));
            File file = new File(input);
            InputSource is = new InputSource(new FileInputStream(file));
            if (this.setSystemid) {
                is.setSystemId(file.toURI().toURL().toString());
            }
            this.reader.parse(is);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public Content getContent() {
        this.content = new ContentImpl();
        this.content.setCollection(this.filterMap.entrySet());
        return this.content;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String flagImage = null;
        if (atts.getValue("img") != null) {
            flagImage = atts.getValue("img");
        } else if (atts.getValue("imageref") != null) {
            flagImage = atts.getValue("imageref");
        }
        if ("prop".equals(qName)) {
            FilterUtils.Action action;
            String attAction = atts.getValue("action");
            FilterUtils.Action action2 = action = attAction != null ? FilterUtils.Action.valueOf(attAction.toUpperCase()) : null;
            if (action != null) {
                Map<String, Set<Element>> schemeMap;
                String attName = atts.getValue("att");
                String attValue = atts.getValue("val");
                FilterUtils.FilterKey key = attName != null ? new FilterUtils.FilterKey(attName, attValue) : FilterUtils.DEFAULT;
                this.insertAction(action, key);
                if (attName != null && attValue != null && this.bindingMap != null && !this.bindingMap.isEmpty() && (schemeMap = this.bindingMap.get(attName)) != null && !schemeMap.isEmpty()) {
                    for (Set<Element> submap : schemeMap.values()) {
                        for (Element e : submap) {
                            Element subRoot = this.searchForKey(e, attValue);
                            if (subRoot == null) continue;
                            this.insertAction(subRoot, attName, action);
                        }
                    }
                }
            }
        }
        if (flagImage != null && flagImage.trim().length() > 0) {
            if (new File(flagImage).isAbsolute()) {
                this.imageList.add(flagImage);
                this.relFlagImageList.add(FileUtils.getRelativePath(this.ditaVal, flagImage));
                return;
            }
            String filterDir = new File(this.ditaVal).getParent();
            this.imageList.add(new File(filterDir, flagImage).getAbsolutePath());
            this.relFlagImageList.add(flagImage);
        }
    }

    private void insertAction(Element subTree, String attName, FilterUtils.Action action) {
        if (subTree == null || action == null) {
            return;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        NodeList children = subTree.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            queue.offer((Element)children.item(i));
        }
        while (!queue.isEmpty()) {
            FilterUtils.FilterKey k;
            String key;
            Element node = (Element)queue.poll();
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.offer((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || StringUtils.isEmptyString(key = node.getAttribute("keys")) || this.filterMap.containsKey(k = new FilterUtils.FilterKey(attName, key))) continue;
            this.filterMap.put(k, action);
        }
    }

    private Element searchForKey(Element root, String keyValue) {
        if (root == null || keyValue == null) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.add(root);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.removeFirst();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.add((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || !keyValue.equals(key = node.getAttribute("keys"))) continue;
            return node;
        }
        return null;
    }

    private void insertAction(FilterUtils.Action action, FilterUtils.FilterKey key) {
        if (this.filterMap.get(key) == null) {
            this.filterMap.put(key, action);
        } else {
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ007E", key.toString()).toString());
        }
    }

    public List<String> getImageList() {
        return this.imageList;
    }

    public Map<FilterUtils.FilterKey, FilterUtils.Action> getFilterMap() {
        return Collections.unmodifiableMap(this.filterMap);
    }

    public void reset() {
    }

    public void filterReset() {
        this.filterMap.clear();
    }

    public List<String> getRelFlagImageList() {
        return this.relFlagImageList;
    }
}

