/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.reader.GrammarPoolManager;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DITAAttrUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class GenListModuleReader
extends AbstractXMLReader {
    private XMLReader reader = null;
    private FilterUtils filterUtils;
    private OutputUtils outputUtils;
    private String currentDir = null;
    private boolean hasConRef = false;
    private boolean hasHref = false;
    private boolean hasKeyRef = false;
    private boolean hasCodeRef = false;
    private final Set<Reference> nonConrefCopytoTargets;
    private final Set<String> conrefTargets;
    private final Set<String> hrefTargets;
    private final Set<String> hrefTopicSet;
    private final Set<String> chunkTopicSet;
    private final Set<String> schemeSet;
    private final Set<String> subsidiarySet;
    private final Set<String> ignoredCopytoSourceSet;
    private final Map<String, String> copytoMap;
    private final Map<String, KeyDef> keysDefMap;
    private final Map<String, String> keysRefMap;
    private boolean hasconaction = false;
    private boolean insideExcludedElement = false;
    private int excludedLevel = 0;
    private int foreignLevel = 0;
    private int chunkLevel = 0;
    private int relTableLevel = 0;
    private int chunkToNavLevel = 0;
    private int topicGroupLevel = 0;
    private boolean isValidInput = false;
    private String[][] props = null;
    private final Set<String> outDitaFilesSet;
    private File rootDir = null;
    private File currentFile = null;
    private File rootFilePath = null;
    private boolean setSystemid = true;
    private final Stack<String> processRoleStack;
    private int processRoleLevel = 0;
    private final Set<String> resourceOnlySet;
    private final Set<String> crossSet;
    private final Set<String> schemeRefSet;
    private Map<String, Set<String>> schemeRelationGraph = null;
    private final List<ExportAnchor> resultList = new ArrayList<ExportAnchor>();
    private ExportAnchor currentExportAnchor;
    private boolean hasExport = false;
    private boolean shouldAppendEndTag = false;
    private String topicHref = "";
    private final Set<String> topicMetaSet;
    private String topicId = "";
    private final Map<String, Set<String>> pluginMap = new HashMap<String, Set<String>>();
    private String transtype;
    private final Map<String, List<String>> vaildBranches;
    private int level = 0;
    private final Stack<String> topicrefStack;
    private String primaryDitamap = "";
    private final DITAAttrUtils ditaAttrUtils = DITAAttrUtils.getInstance();
    private final Map<String, String> exKeysDefMap;
    private String extName = null;

    public GenListModuleReader() {
        this.nonConrefCopytoTargets = new HashSet<Reference>(64);
        this.hrefTargets = new HashSet<String>(32);
        this.hrefTopicSet = new HashSet<String>(32);
        this.chunkTopicSet = new HashSet<String>(32);
        this.schemeSet = new HashSet<String>(32);
        this.schemeRefSet = new HashSet<String>(32);
        this.conrefTargets = new HashSet<String>(32);
        this.copytoMap = new HashMap<String, String>(16);
        this.subsidiarySet = new HashSet<String>(16);
        this.ignoredCopytoSourceSet = new HashSet<String>(16);
        this.outDitaFilesSet = new HashSet<String>(64);
        this.keysDefMap = new HashMap<String, KeyDef>();
        this.keysRefMap = new HashMap<String, String>();
        this.exKeysDefMap = new HashMap<String, String>();
        this.processRoleStack = new Stack();
        this.resourceOnlySet = new HashSet<String>(32);
        this.crossSet = new HashSet<String>(32);
        this.topicMetaSet = new HashSet<String>(16);
        this.vaildBranches = new HashMap<String, List<String>>(32);
        this.topicrefStack = new Stack();
        try {
            this.reader = StringUtils.getXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to create XML parser: " + e.getMessage(), e);
        }
        this.reader.setContentHandler(this);
        try {
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotRecognizedException e1) {
            this.logger.logError(e1.getMessage(), e1);
        }
        catch (SAXNotSupportedException e1) {
            this.logger.logError(e1.getMessage(), e1);
        }
    }

    public String getTranstype() {
        return this.transtype;
    }

    public void setTranstype(String transtype) {
        this.transtype = transtype;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }

    public Map<String, Set<String>> getPluginMap() {
        return this.pluginMap;
    }

    public List<ExportAnchor> getExportAnchors() {
        return this.resultList;
    }

    public void setFilterUtils(FilterUtils filterUtils) {
        this.filterUtils = filterUtils;
    }

    public void setOutputUtils(OutputUtils outputUtils) {
        this.outputUtils = outputUtils;
    }

    public Set<String> getOutFilesSet() {
        return this.outDitaFilesSet;
    }

    public Set<String> getHrefTopicSet() {
        return this.hrefTopicSet;
    }

    public Set<String> getChunkTopicSet() {
        return this.chunkTopicSet;
    }

    public Set<String> getSchemeSet() {
        return this.schemeSet;
    }

    public Set<String> getSchemeRefSet() {
        return this.schemeRefSet;
    }

    public Set<String> getResourceOnlySet() {
        HashSet<String> res = new HashSet<String>(this.resourceOnlySet);
        res.removeAll(this.crossSet);
        return res;
    }

    public Map<String, Set<String>> getRelationshipGrap() {
        return this.schemeRelationGraph;
    }

    @Deprecated
    public String getPrimaryDitamap() {
        return this.primaryDitamap;
    }

    public void setPrimaryDitamap(String primaryDitamap) {
        this.primaryDitamap = primaryDitamap;
    }

    public boolean hasConRef() {
        return this.hasConRef;
    }

    public boolean hasKeyRef() {
        return this.hasKeyRef;
    }

    public boolean hasCodeRef() {
        return this.hasCodeRef;
    }

    public boolean hasHref() {
        return this.hasHref;
    }

    public Set<Reference> getNonCopytoResult() {
        HashSet<Reference> nonCopytoSet = new HashSet<Reference>(128);
        nonCopytoSet.addAll(this.nonConrefCopytoTargets);
        for (String f : this.conrefTargets) {
            nonCopytoSet.add(new Reference(f));
        }
        for (String f : this.copytoMap.values()) {
            nonCopytoSet.add(new Reference(f));
        }
        for (String f : this.ignoredCopytoSourceSet) {
            nonCopytoSet.add(new Reference(f));
        }
        for (String filename : this.subsidiarySet) {
            if (!this.isOutFile(filename) || OutputUtils.getGeneratecopyouter() != OutputUtils.Generate.OLDSOLUTION) continue;
            nonCopytoSet.add(new Reference(filename));
        }
        return nonCopytoSet;
    }

    public Set<String> getHrefTargets() {
        return this.hrefTargets;
    }

    public Set<String> getConrefTargets() {
        return this.conrefTargets;
    }

    public Set<String> getSubsidiaryTargets() {
        return this.subsidiarySet;
    }

    public Set<String> getOutDitaFilesSet() {
        return this.outDitaFilesSet;
    }

    public Set<String> getNonConrefCopytoTargets() {
        HashSet<String> res = new HashSet<String>(this.nonConrefCopytoTargets.size());
        for (Reference r : this.nonConrefCopytoTargets) {
            res.add(r.filename);
        }
        return res;
    }

    public Set<String> getIgnoredCopytoSourceSet() {
        return this.ignoredCopytoSourceSet;
    }

    public Map<String, String> getCopytoMap() {
        return this.copytoMap;
    }

    public Map<String, KeyDef> getKeysDMap() {
        return this.keysDefMap;
    }

    public Map<String, String> getExKeysDefMap() {
        return this.exKeysDefMap;
    }

    public void setCurrentDir(String dir) {
        this.currentDir = dir;
    }

    public boolean isValidInput() {
        return this.isValidInput;
    }

    public boolean hasConaction() {
        return this.hasconaction;
    }

    public void initXMLReader(File ditaDir, boolean validate, File rootFile, boolean arg_setSystemid) throws SAXException, IOException {
        this.rootDir = rootFile.getParentFile().getCanonicalFile();
        this.rootFilePath = rootFile.getCanonicalFile();
        this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        if (validate) {
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            try {
                this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXNotRecognizedException e) {}
        } else {
            String msg = MessageUtils.getInstance().getMessage("DOTJ037W", new String[0]).toString();
            this.logger.logWarn(msg);
        }
        XMLGrammarPool grammarPool = GrammarPoolManager.getGrammarPool();
        this.setGrammarPool(this.reader, grammarPool);
        CatalogUtils.setDitaDir(ditaDir);
        this.setSystemid = arg_setSystemid;
        this.reader.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
    }

    public void reset() {
        this.hasKeyRef = false;
        this.hasConRef = false;
        this.hasHref = false;
        this.hasCodeRef = false;
        this.currentDir = null;
        this.insideExcludedElement = false;
        this.excludedLevel = 0;
        this.foreignLevel = 0;
        this.chunkLevel = 0;
        this.relTableLevel = 0;
        this.chunkToNavLevel = 0;
        this.topicGroupLevel = 0;
        this.isValidInput = false;
        this.hasconaction = false;
        this.nonConrefCopytoTargets.clear();
        this.hrefTargets.clear();
        this.hrefTopicSet.clear();
        this.chunkTopicSet.clear();
        this.conrefTargets.clear();
        this.copytoMap.clear();
        this.ignoredCopytoSourceSet.clear();
        this.outDitaFilesSet.clear();
        this.keysDefMap.clear();
        this.keysRefMap.clear();
        this.exKeysDefMap.clear();
        this.schemeSet.clear();
        this.schemeRefSet.clear();
        this.level = 0;
        this.topicrefStack.clear();
        this.processRoleLevel = 0;
        this.processRoleStack.clear();
        this.ditaAttrUtils.reset();
    }

    public void parse(File file) throws FileNotFoundException, IOException, SAXException {
        this.currentFile = file.getAbsoluteFile();
        this.reader.setErrorHandler(new DITAOTXMLErrorHandler(file.getName(), this.logger));
        InputSource is = new InputSource(new FileInputStream(file));
        if (this.setSystemid) {
            is.setSystemId(file.toURI().toURL().toString());
        }
        this.reader.parse(is);
    }

    @Override
    public void startDocument() throws SAXException {
        String href = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), this.currentFile.getAbsolutePath());
        if (FileUtils.isDITAMapFile(this.currentFile.getName()) && this.resourceOnlySet.contains(href) && !this.crossSet.contains(href)) {
            ++this.processRoleLevel;
            this.processRoleStack.push("resource-only");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Set<String> children;
        String classValue;
        String domains = null;
        Properties params = new Properties();
        String printValue = atts.getValue("print");
        this.ditaAttrUtils.increasePrintLevel(printValue);
        if (this.ditaAttrUtils.needExcludeForPrintAttri(this.transtype)) {
            return;
        }
        String processingRole = atts.getValue("processing-role");
        String href = atts.getValue("href");
        String scope = atts.getValue("scope");
        if (processingRole != null) {
            this.processRoleStack.push(processingRole);
            ++this.processRoleLevel;
            if (!"external".equals(scope)) {
                if ("resource-only".equals(processingRole)) {
                    if (href != null) {
                        this.resourceOnlySet.add(FileUtils.resolveFile(this.currentDir, href));
                    }
                } else if ("normal".equalsIgnoreCase(processingRole) && href != null) {
                    this.crossSet.add(FileUtils.resolveFile(this.currentDir, href));
                }
            }
        } else if (this.processRoleLevel > 0) {
            ++this.processRoleLevel;
            if (!"external".equals(scope)) {
                if ("resource-only".equalsIgnoreCase(this.processRoleStack.peek())) {
                    if (href != null) {
                        this.resourceOnlySet.add(FileUtils.resolveFile(this.currentDir, href));
                    }
                } else if ("normal".equalsIgnoreCase(this.processRoleStack.peek()) && href != null) {
                    this.crossSet.add(FileUtils.resolveFile(this.currentDir, href));
                }
            }
        } else if (href != null) {
            this.crossSet.add(FileUtils.resolveFile(this.currentDir, href));
        }
        if ((classValue = atts.getValue("class")) != null) {
            String filename;
            if (Constants.TOPIC_TOPIC.matches(classValue)) {
                this.topicId = atts.getValue("id");
                filename = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), this.currentFile.getAbsolutePath());
                for (ExportAnchor e : this.resultList) {
                    if (!e.topicids.contains(filename + "?")) continue;
                    e.topicids.add(this.topicId);
                    e.topicids.remove(filename + "?");
                }
            }
            if (FileUtils.isDITAMapFile(this.currentFile.getName()) && this.rootFilePath.equals(this.currentFile) && Constants.MAP_MAP.matches(classValue) && "eclipsehelp".equals(this.transtype)) {
                String pluginId = atts.getValue("id");
                if (pluginId == null) {
                    pluginId = "org.sample.help.doc";
                }
                Set<String> set = StringUtils.restoreSet(pluginId);
                this.pluginMap.put("pluginId", set);
            }
            if ("eclipsehelp".equals(this.transtype)) {
                if (Constants.MAP_TOPICMETA.matches(classValue) || Constants.TOPIC_PROLOG.matches(classValue)) {
                    this.topicMetaSet.add(qName);
                }
                if (Constants.DELAY_D_EXPORTANCHORS.matches(classValue)) {
                    this.hasExport = true;
                    if (FileUtils.isDITAMapFile(this.currentFile.getName())) {
                        String editedHref = "";
                        editedHref = this.topicHref.endsWith(".xml") ? this.topicHref.replace(".xml", ".dita") : this.topicHref;
                        this.currentExportAnchor = new ExportAnchor(editedHref);
                        this.currentExportAnchor.topicids.add(this.topicId);
                    } else if (FileUtils.isDITATopicFile(this.currentFile.getName())) {
                        filename = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), this.currentFile.getAbsolutePath());
                        if (filename.endsWith(".xml")) {
                            filename = filename.replace(".xml", ".dita");
                        }
                        filename = FileUtils.separatorsToUnix(filename);
                        this.currentExportAnchor = new ExportAnchor(filename);
                        this.currentExportAnchor.topicids.add(this.topicId);
                        this.shouldAppendEndTag = true;
                    }
                } else if (Constants.DELAY_D_ANCHORKEY.matches(classValue)) {
                    String keyref = atts.getValue("keyref");
                    this.currentExportAnchor.keys.add(keyref);
                } else if (Constants.DELAY_D_ANCHORID.matches(classValue)) {
                    String id = atts.getValue("id");
                    if (FileUtils.isDITAMapFile(this.currentFile.getName())) {
                        if (!this.topicId.equals(id)) {
                            this.currentExportAnchor.ids.add(id);
                        }
                    } else if (FileUtils.isDITATopicFile(this.currentFile.getName()) && !this.topicId.equals(id)) {
                        this.currentExportAnchor.ids.add(id);
                    }
                }
            }
        }
        if (Constants.SUBJECTSCHEME_SUBJECTSCHEME.matches(classValue)) {
            if (this.schemeRelationGraph == null) {
                this.schemeRelationGraph = new LinkedHashMap<String, Set<String>>();
            }
            if ((children = this.schemeRelationGraph.get("ROOT")) == null || children.isEmpty()) {
                children = new LinkedHashSet<String>();
            }
            children.add(this.currentFile.getAbsolutePath());
            this.schemeRelationGraph.put("ROOT", children);
            this.schemeRefSet.add(FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), this.currentFile.getAbsolutePath()));
        } else if (Constants.SUBJECTSCHEME_SCHEMEREF.matches(classValue)) {
            children = this.schemeRelationGraph.get(this.currentFile.getAbsolutePath());
            if (children == null) {
                children = new LinkedHashSet<String>();
                this.schemeRelationGraph.put(this.currentFile.getAbsolutePath(), children);
            }
            if (href != null) {
                children.add(FileUtils.resolveFile(this.rootDir.getAbsolutePath(), href));
            }
        }
        if (this.foreignLevel > 0) {
            ++this.foreignLevel;
            return;
        }
        if (classValue != null && (Constants.TOPIC_FOREIGN.matches(classValue) || Constants.TOPIC_UNKNOWN.matches(classValue))) {
            ++this.foreignLevel;
        }
        if (this.chunkLevel > 0) {
            ++this.chunkLevel;
        } else if (atts.getValue("chunk") != null) {
            ++this.chunkLevel;
        }
        if (this.relTableLevel > 0) {
            ++this.relTableLevel;
        } else if (classValue != null && Constants.MAP_RELTABLE.matches(classValue)) {
            ++this.relTableLevel;
        }
        if (this.chunkToNavLevel > 0) {
            ++this.chunkToNavLevel;
        } else if (atts.getValue("chunk") != null && atts.getValue("chunk").indexOf("to-navigation") != -1) {
            ++this.chunkToNavLevel;
        }
        if (this.topicGroupLevel > 0) {
            ++this.topicGroupLevel;
        } else if (atts.getValue("class") != null && atts.getValue("class").contains(Constants.MAPGROUP_D_TOPICGROUP.matcher)) {
            ++this.topicGroupLevel;
        }
        if (classValue == null && !"dita".equals(localName)) {
            this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ030I", localName).toString());
        }
        if (classValue != null && Constants.TOPIC_TOPIC.matches(classValue)) {
            domains = atts.getValue("domains");
            if (domains == null) {
                this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ029I", localName).toString());
            } else {
                this.props = StringUtils.getExtProps(domains);
            }
        }
        if (this.insideExcludedElement) {
            ++this.excludedLevel;
            return;
        }
        if (this.filterUtils.needExclude(atts, this.props)) {
            this.insideExcludedElement = true;
            ++this.excludedLevel;
            return;
        }
        if (classValue != null) {
            if (Constants.MAP_MAP.matches(classValue) || Constants.TOPIC_TITLE.matches(classValue)) {
                this.isValidInput = true;
            } else if (Constants.TOPIC_OBJECT.matches(classValue)) {
                this.parseAttribute(atts, "data");
            }
        }
        if (this.outputUtils.getOnlyTopicInMap() && this.canResolved() && Constants.MAP_TOPICREF.matches(classValue)) {
            String attrScope;
            String hrefValue = atts.getValue("href");
            String conrefValue = atts.getValue("conref");
            if (!StringUtils.isEmptyString(hrefValue)) {
                attrScope = atts.getValue("scope");
                if (!("external".equalsIgnoreCase(attrScope) || "peer".equalsIgnoreCase(attrScope) || hrefValue.indexOf("://") != -1 || hrefValue.startsWith("#"))) {
                    File target = new File(hrefValue);
                    String fileName = null;
                    if (target.isAbsolute()) {
                        fileName = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), hrefValue);
                    }
                    fileName = FileUtils.normalizeDirectory(this.currentDir, hrefValue);
                    boolean canParse = this.parseBranch(atts, hrefValue, fileName = FileUtils.separatorsToUnix(fileName));
                    if (canParse) {
                        this.topicrefStack.push(localName);
                    }
                }
            } else if (!(StringUtils.isEmptyString(conrefValue) || "external".equalsIgnoreCase(attrScope = atts.getValue("scope")) || "peer".equalsIgnoreCase(attrScope) || conrefValue.indexOf("://") != -1 || conrefValue.startsWith("#"))) {
                File target = new File(conrefValue);
                String fileName = null;
                if (target.isAbsolute()) {
                    fileName = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), conrefValue);
                }
                fileName = FileUtils.normalizeDirectory(this.currentDir, conrefValue);
                boolean canParse = this.parseBranch(atts, conrefValue, fileName = FileUtils.separatorsToUnix(fileName));
                if (canParse) {
                    this.topicrefStack.push(localName);
                }
            }
        }
        this.parseAttribute(atts, "conref");
        this.parseAttribute(atts, "href");
        this.parseAttribute(atts, "copy-to");
        this.parseAttribute(atts, "img");
        this.parseAttribute(atts, "conaction");
        this.parseAttribute(atts, "keys");
        this.parseAttribute(atts, "conkeyref");
        this.parseAttribute(atts, "keyref");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.processRoleLevel > 0) {
            if (this.processRoleLevel == this.processRoleStack.size()) {
                this.processRoleStack.pop();
            }
            --this.processRoleLevel;
        }
        if (this.foreignLevel > 0) {
            --this.foreignLevel;
            return;
        }
        if (this.chunkLevel > 0) {
            --this.chunkLevel;
        }
        if (this.relTableLevel > 0) {
            --this.relTableLevel;
        }
        if (this.chunkToNavLevel > 0) {
            --this.chunkToNavLevel;
        }
        if (this.topicGroupLevel > 0) {
            --this.topicGroupLevel;
        }
        if (this.insideExcludedElement) {
            if (this.excludedLevel == 1) {
                this.insideExcludedElement = false;
            }
            --this.excludedLevel;
        }
        if (this.topicMetaSet.contains(qName) && this.hasExport) {
            if (FileUtils.isDITAMapFile(this.currentFile.getName())) {
                this.resultList.add(this.currentExportAnchor);
                this.currentExportAnchor = null;
            }
            this.hasExport = false;
            this.topicMetaSet.clear();
        }
        if (!this.topicrefStack.isEmpty() && localName.equals(this.topicrefStack.peek())) {
            --this.level;
            this.topicrefStack.pop();
        }
        this.ditaAttrUtils.decreasePrintLevel();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.processRoleLevel > 0) {
            --this.processRoleLevel;
            this.processRoleStack.pop();
        }
        if (FileUtils.isDITATopicFile(this.currentFile.getName()) && this.shouldAppendEndTag) {
            this.resultList.add(this.currentExportAnchor);
            this.currentExportAnchor = null;
            this.shouldAppendEndTag = false;
        }
        this.checkMultiLevelKeys(this.keysDefMap, this.keysRefMap);
    }

    private boolean parseBranch(Attributes atts, String hrefValue, String fileName) {
        String currentFileRelative = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), this.currentFile.getAbsolutePath());
        if (this.currentDir == null && currentFileRelative.equals(this.primaryDitamap)) {
            this.addReferredBranches(hrefValue, fileName);
            return true;
        }
        String id = atts.getValue("id");
        if (this.level == 0 && StringUtils.isEmptyString(id)) {
            boolean found = this.searchBrachesMap(id);
            if (found) {
                this.addReferredBranches(hrefValue, fileName);
                ++this.level;
                return true;
            }
            return false;
        }
        if (this.level != 0) {
            this.addReferredBranches(hrefValue, fileName);
            ++this.level;
            return true;
        }
        if (!StringUtils.isEmptyString(id)) {
            boolean found = this.searchBrachesMap(id);
            if (found) {
                this.addReferredBranches(hrefValue, fileName);
                ++this.level;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean searchBrachesMap(String id) {
        String currentFileRelative = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), this.currentFile.getAbsolutePath());
        if (this.vaildBranches.containsKey(currentFileRelative)) {
            List<String> branchIdList = this.vaildBranches.get(currentFileRelative);
            if (branchIdList.contains(id)) {
                return true;
            }
            return branchIdList.size() == 0;
        }
        return false;
    }

    private void addReferredBranches(String hrefValue, String fileName) {
        String branchId = null;
        if (hrefValue.contains("#")) {
            branchId = hrefValue.substring(hrefValue.lastIndexOf("#") + 1);
            if (this.vaildBranches.containsKey(fileName)) {
                List<String> branchIdList = this.vaildBranches.get(fileName);
                branchIdList.add(branchId);
            } else {
                ArrayList<String> branchIdList = new ArrayList<String>();
                branchIdList.add(branchId);
                this.vaildBranches.put(fileName, branchIdList);
            }
        } else {
            this.vaildBranches.put(fileName, new ArrayList());
        }
    }

    private void parseAttribute(Attributes atts, String attrName) throws SAXException {
        Object target;
        String attrValue = atts.getValue(attrName);
        String filename = null;
        String attrClass = atts.getValue("class");
        String attrScope = atts.getValue("scope");
        String attrFormat = atts.getValue("format");
        String attrType = atts.getValue("type");
        String codebase = atts.getValue("codebase");
        if (attrValue == null) {
            return;
        }
        if ("conref".equals(attrName) || "conkeyref".equals(attrName)) {
            this.hasConRef = true;
        } else if ("href".equals(attrName)) {
            if (attrClass != null && Constants.PR_D_CODEREF.matches(attrClass)) {
                this.hasCodeRef = true;
            } else {
                this.hasHref = true;
            }
        } else if ("keyref".equals(attrName)) {
            this.hasKeyRef = true;
        }
        if ("keys".equals(attrName) && attrValue.length() != 0) {
            target = atts.getValue("href");
            if (target != null && (attrFormat == null || attrFormat.equals("dita")) && this.extName != null) {
                target = FileUtils.replaceExtension((String)target, this.extName);
            }
            String keyRef = atts.getValue("keyref");
            String copy_to = atts.getValue("copy-to");
            if (!StringUtils.isEmptyString(copy_to)) {
                target = copy_to;
            }
            if (target == null) {
                target = "";
            }
            String temp = target;
            for (String key : attrValue.split(" ")) {
                if (!this.keysDefMap.containsKey(key) && !key.equals("")) {
                    if (target != null && ((String)target).length() != 0) {
                        if (attrScope != null && (attrScope.equals("external") || attrScope.equals("peer"))) {
                            this.exKeysDefMap.put(key, (String)target);
                            this.keysDefMap.put(key, new KeyDef(key, (String)target, attrScope, null));
                        } else {
                            String tail = "";
                            if (((String)target).indexOf("#") != -1) {
                                tail = ((String)target).substring(((String)target).indexOf("#"));
                                target = ((String)target).substring(0, ((String)target).indexOf("#"));
                            }
                            if (new File((String)target).isAbsolute()) {
                                target = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), (String)target);
                            }
                            target = FileUtils.separatorsToUnix(FileUtils.normalizeDirectory(this.currentDir, (String)target));
                            this.keysDefMap.put(key, new KeyDef(key, (String)target + tail, "local", null));
                        }
                    } else if (!StringUtils.isEmptyString(keyRef)) {
                        this.keysRefMap.put(key, keyRef);
                    } else {
                        this.keysDefMap.put(key, new KeyDef(key, null, null, null));
                    }
                } else {
                    this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ045I", new String[]{key, target}).toString());
                }
                target = temp;
            }
        }
        if ("external".equalsIgnoreCase(attrScope) || "peer".equalsIgnoreCase(attrScope) || attrValue.indexOf("://") != -1 || attrValue.startsWith("#")) {
            return;
        }
        if (attrValue.startsWith("file:/") && attrValue.indexOf("file://") == -1) {
            attrValue = attrValue.substring("file:/".length());
            if ("/".equals(File.separator)) {
                attrValue = "/" + attrValue;
            }
        } else if (attrValue.startsWith("file:") && !attrValue.startsWith("file:/")) {
            attrValue = attrValue.substring("file:".length());
        }
        if (((File)(target = new File(attrValue))).isAbsolute() && !"data".equals(attrName)) {
            attrValue = FileUtils.getRelativePath(this.rootFilePath.getAbsolutePath(), attrValue);
        } else {
            filename = "data".equals(attrName) ? (!StringUtils.isEmptyString(codebase) ? FileUtils.normalizeDirectory(codebase, attrValue) : FileUtils.normalizeDirectory(this.currentDir, attrValue)) : FileUtils.normalizeDirectory(this.currentDir, attrValue);
        }
        filename = this.toFile(filename);
        if (Constants.MAP_TOPICREF.matches(attrClass)) {
            if ("subjectScheme".equalsIgnoreCase(attrType)) {
                this.schemeSet.add(filename);
            }
            if ("eclipsehelp".equals(this.transtype)) {
                if (attrFormat == null || "dita".equalsIgnoreCase(attrFormat)) {
                    if (attrName.equals("href")) {
                        this.topicHref = filename;
                        this.topicHref = FileUtils.separatorsToUnix(this.topicHref);
                        if (attrValue.lastIndexOf("#") != -1) {
                            int position = attrValue.lastIndexOf("#");
                            this.topicId = attrValue.substring(position + 1);
                        } else if (FileUtils.isDITAFile(this.topicHref)) {
                            this.topicId = this.topicHref + "?";
                        }
                    }
                } else {
                    this.topicHref = "";
                    this.topicId = "";
                }
            }
        }
        if ("DITA-foreign".equals(attrType) && "data".equals(attrName) || attrClass != null && Constants.PR_D_CODEREF.matches(attrClass)) {
            this.subsidiarySet.add(filename);
            return;
        }
        if (filename != null && FileUtils.isValidTarget(filename.toLowerCase()) && (StringUtils.isEmptyString(atts.getValue("copy-to")) || !FileUtils.isDITATopicFile(atts.getValue("copy-to").toLowerCase()) || atts.getValue("chunk") != null && atts.getValue("chunk").contains("to-content")) && !"conref".equals(attrName) && !"copy-to".equals(attrName) && (this.canResolved() || FileUtils.isSupportedImageFile(filename.toLowerCase()))) {
            this.nonConrefCopytoTargets.add(new Reference(filename, attrFormat));
        }
        if (attrFormat != null && !"dita".equalsIgnoreCase(attrFormat)) {
            return;
        }
        if ("href".equals(attrName) && FileUtils.isDITATopicFile(filename) && this.canResolved()) {
            this.hrefTargets.add(new File(filename).getPath());
            this.toOutFile(new File(filename).getPath());
            if (this.chunkLevel > 0 && this.chunkToNavLevel == 0 && this.topicGroupLevel == 0 && this.relTableLevel == 0) {
                this.chunkTopicSet.add(filename);
            } else {
                this.hrefTopicSet.add(filename);
            }
        }
        if ("conref".equals(attrName) && FileUtils.isDITAFile(filename)) {
            this.conrefTargets.add(filename);
            this.toOutFile(new File(filename).getPath());
        }
        if ("copy-to".equals(attrName) && FileUtils.isDITATopicFile(filename)) {
            String href = atts.getValue("href");
            if (href != null) {
                String value = this.toFile(FileUtils.normalizeDirectory(this.currentDir, href));
                if (StringUtils.isEmptyString(href)) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("[WARN]: Copy-to task [href=\"\" copy-to=\"");
                    buff.append(filename);
                    buff.append("\"] was ignored.");
                    this.logger.logWarn(buff.toString());
                } else if (this.copytoMap.get(filename) != null) {
                    if (!value.equals(this.copytoMap.get(filename))) {
                        this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTX065W", href, filename).toString());
                    }
                    this.ignoredCopytoSourceSet.add(href);
                } else if (atts.getValue("chunk") == null || !atts.getValue("chunk").contains("to-content")) {
                    this.copytoMap.put(filename, value);
                }
            }
            String pathWithoutID = FileUtils.resolveFile(this.currentDir, this.toFile(attrValue));
            if (this.chunkLevel > 0 && this.chunkToNavLevel == 0 && this.topicGroupLevel == 0) {
                this.chunkTopicSet.add(pathWithoutID);
            } else {
                this.hrefTopicSet.add(pathWithoutID);
            }
        }
        if ("conaction".equals(attrName) && (attrValue.equals("mark") || attrValue.equals("pushreplace"))) {
            this.hasconaction = true;
        }
    }

    private String toFile(String filename) {
        if (filename == null) {
            return null;
        }
        String f = filename;
        try {
            f = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (Configuration.processingMode == Configuration.Mode.LAX) {
            f = f.replace("\\", File.separator);
        }
        f = f.replace("/", File.separator);
        return f;
    }

    private List<String> getKeysList(String key, Map<String, String> keysRefMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : keysRefMap.entrySet()) {
            if (!entry.getValue().equals(key)) continue;
            String entryKey = entry.getKey();
            list.add(entryKey);
            if (!keysRefMap.containsValue(entryKey)) continue;
            List<String> tempList = this.getKeysList(entryKey, keysRefMap);
            list.addAll(tempList);
        }
        return list;
    }

    private void checkMultiLevelKeys(Map<String, KeyDef> keysDefMap, Map<String, String> keysRefMap) {
        String key = null;
        KeyDef value = null;
        HashMap<String, KeyDef> tempMap = new HashMap<String, KeyDef>();
        for (Map.Entry<String, KeyDef> entry : keysDefMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!keysRefMap.containsValue(key)) continue;
            List<String> keysList = this.getKeysList(key, keysRefMap);
            for (String multikey : keysList) {
                tempMap.put(multikey, value);
            }
        }
        keysDefMap.putAll(tempMap);
    }

    private boolean isOutFile(String toCheckPath) {
        return toCheckPath.startsWith("..");
    }

    private boolean isMapFile() {
        String current = FileUtils.normalize(this.currentFile.getAbsolutePath());
        return FileUtils.isDITAMapFile(current);
    }

    private boolean canResolved() {
        return !this.outputUtils.getOnlyTopicInMap() || this.isMapFile();
    }

    private void addToOutFilesSet(String hrefedFile) {
        if (this.canResolved()) {
            this.outDitaFilesSet.add(hrefedFile);
        }
    }

    private void toOutFile(String filename) throws SAXException {
        String[] prop = new String[]{FileUtils.normalizeDirectory(this.rootDir.getAbsolutePath(), filename), FileUtils.normalize(this.currentFile.getAbsolutePath())};
        if ((OutputUtils.getGeneratecopyouter() == OutputUtils.Generate.NOT_GENERATEOUTTER || OutputUtils.getGeneratecopyouter() == OutputUtils.Generate.GENERATEOUTTER) && this.isOutFile(filename)) {
            if (this.outputUtils.getOutterControl() == OutputUtils.OutterControl.FAIL) {
                MessageBean msgBean = MessageUtils.getInstance().getMessage("DOTJ035F", prop);
                throw new SAXParseException(null, null, new DITAOTException(msgBean, null, msgBean.toString()));
            }
            if (this.outputUtils.getOutterControl() == OutputUtils.OutterControl.WARN) {
                String message = MessageUtils.getInstance().getMessage("DOTJ036W", prop).toString();
                this.logger.logWarn(message);
            }
            this.addToOutFilesSet(filename);
        }
    }

    public static class ExportAnchor {
        public final String file;
        public final Set<String> topicids = new HashSet<String>();
        public final Set<String> keys = new HashSet<String>();
        public final Set<String> ids = new HashSet<String>();

        ExportAnchor(String file) {
            this.file = file;
        }
    }

    public static class Reference {
        public final String filename;
        public final String format;

        public Reference(String filename, String format) {
            this.filename = filename;
            this.format = format;
        }

        public Reference(String filename) {
            this(filename, null);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Reference)) {
                return false;
            }
            Reference other = (Reference)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            return !(this.format == null ? other.format != null : !this.format.equals(other.format));
        }
    }
}

