/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.module.Content;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.resolver.DitaURIResolverFactory;
import org.dita.dost.resolver.URIResolverAdapter;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class KeyrefReader
extends AbstractXMLReader {
    private final XMLReader reader;
    private final Map<String, Element> keyDefTable = new HashMap<String, Element>();
    private Stack<KeyDef> keyDefs;
    private Set<String> keys;

    public KeyrefReader() {
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setContentHandler(this);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Unable to initialize XML parser: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.keyDefs.isEmpty()) {
            this.keyDefAppend(StringUtils.escapeXML(ch, start, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!this.keyDefs.isEmpty()) {
            --this.keyDefs.peek().keyDefLevel;
            this.keyDefAppend("<");
            this.keyDefAppend("/");
            this.keyDefAppend(name);
            this.keyDefAppend(">");
            if (this.keyDefs.peek().keyDefLevel == 0) {
                KeyDef keyDef = this.keyDefs.pop();
                for (String keyName : keyDef.key.split(" ")) {
                    if (keyName.equals("")) continue;
                    this.keyDefTable.put(keyName, this.keyDefToDoc(keyDef.keyDefContent.toString()).getDocumentElement());
                }
            }
        }
    }

    @Override
    public Content getContent() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Element> getKeyDefinition() {
        return Collections.unmodifiableMap(this.keyDefTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(String filename) {
        this.keyDefs = new Stack();
        try {
            InputSource source = URIResolverAdapter.convertToInputSource(DitaURIResolverFactory.getURIResolver().resolve(filename, null));
            this.reader.parse(source);
        }
        catch (Exception ex) {
            this.logger.logError(ex.getMessage(), ex);
        }
        finally {
            this.keys = null;
        }
    }

    public void setKeys(Set<String> set) {
        this.keys = set;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String classValue = atts.getValue("class");
        String keyName = atts.getValue("keys");
        if (keyName != null && Constants.MAP_TOPICREF.matches(classValue)) {
            boolean hasKnownKey = false;
            for (String k : keyName.split(" ")) {
                if (!this.keys.contains(k)) continue;
                hasKnownKey = true;
                break;
            }
            if (hasKnownKey) {
                this.keyDefs.push(new KeyDef(keyName));
                this.putElement(name, atts);
            }
        } else if (!this.keyDefs.isEmpty()) {
            ++this.keyDefs.peek().keyDefLevel;
            this.putElement(name, atts);
        }
    }

    private void putElement(String elemName, Attributes atts) {
        this.keyDefAppend("<");
        this.keyDefAppend(elemName);
        for (int index = 0; index < atts.getLength(); ++index) {
            this.keyDefAppend(" ");
            this.keyDefAppend(atts.getQName(index));
            this.keyDefAppend("=");
            this.keyDefAppend("\"");
            String value = atts.getValue(index);
            value = StringUtils.escapeXML(value);
            this.keyDefAppend(value);
            this.keyDefAppend("\"");
        }
        this.keyDefAppend(">");
    }

    public void setTempDir(String tempDir) {
    }

    private void keyDefAppend(String content) {
        for (KeyDef keyDef : this.keyDefs) {
            keyDef.keyDefContent.append(content);
        }
    }

    private Document keyDefToDoc(String key) {
        InputSource inputSource = new InputSource(new StringReader(key));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception e) {
            this.logger.logError("Failed to parse key definition: " + e.getMessage(), e);
        }
        return document;
    }

    protected static final class KeyDef {
        protected final String key;
        protected final StringBuffer keyDefContent;
        protected int keyDefLevel = 1;

        public KeyDef(String key) {
            this.key = key;
            this.keyDefContent = new StringBuffer();
        }
    }
}

