/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.resolver.DitaURIResolverFactory;
import org.dita.dost.resolver.URIResolverAdapter;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class MapLinksReader
extends AbstractXMLReader {
    private static final String INTERNET_LINK_MARK = "://";
    private final List<String> ancestorList;
    private String filePath = null;
    private String firstMatchElement = null;
    private StringBuffer indexEntries;
    private File inputFile = null;
    private final Set<String> lastMatchElement;
    private int level = 0;
    private final Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
    private boolean match = false;
    private final List<String> matchList;
    private boolean needResolveEntity = false;
    private XMLReader reader;
    private String topicPath = null;
    private boolean validHref = true;

    private static boolean verifyIndexEntries(StringBuffer str) {
        int end;
        if (str.length() == 0) {
            return false;
        }
        int start = str.indexOf(">");
        String temp = str.substring(start + 1, end = str.lastIndexOf("<"));
        return temp.trim().length() != 0;
    }

    public MapLinksReader() {
        this.ancestorList = new ArrayList<String>(16);
        this.matchList = new ArrayList<String>(16);
        this.indexEntries = new StringBuffer(1024);
        this.lastMatchElement = new HashSet<String>();
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
            this.reader.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.match && this.needResolveEntity && this.validHref) {
            String temp = new String(ch, start, length);
            this.indexEntries.append(StringUtils.escapeXML(temp));
        }
    }

    private boolean checkMatch() {
        int matchSize = this.matchList.size();
        int ancestorSize = this.ancestorList.size();
        ListIterator<String> matchIterator = this.matchList.listIterator();
        ListIterator<String> ancestorIterator = this.ancestorList.listIterator(ancestorSize - matchSize);
        while (matchIterator.hasNext()) {
            String ancestor;
            String currentMatchString = matchIterator.next();
            if (currentMatchString.contains(ancestor = ancestorIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.match && this.validHref) {
            this.indexEntries.append("]]>");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.match) {
            if (this.validHref) {
                this.indexEntries.append("<");
                this.indexEntries.append("/");
                this.indexEntries.append(qName);
                this.indexEntries.append(">");
            }
            --this.level;
        }
        if (this.lastMatchElement.contains(qName) && this.level == 0 && this.match) {
            this.match = false;
        }
        if (!this.match) {
            this.ancestorList.remove(this.ancestorList.size() - 1);
        }
        if (qName.equals(this.firstMatchElement) && MapLinksReader.verifyIndexEntries(this.indexEntries) && this.topicPath != null) {
            Map<String, String> m;
            String t = this.topicPath;
            String frag = "#";
            if (t.contains("#")) {
                frag = t.indexOf("#") + 1 >= t.length() ? "#" : t.substring(t.indexOf("#") + 1);
                t = t.substring(0, t.indexOf("#"));
            }
            if ((m = this.map.get(t)) != null) {
                String orig = m.get(frag);
                m.put(frag, StringUtils.setOrAppend(orig, this.indexEntries.toString(), false));
            } else {
                m = new HashMap<String, String>(16);
                m.put(frag, this.indexEntries.toString());
                this.map.put(t, m);
            }
            this.indexEntries = new StringBuffer(1024);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    public Map<String, Map<String, String>> getMapping() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.match && this.validHref) {
            String temp = new String(ch, start, length);
            this.indexEntries.append(temp);
        }
    }

    @Override
    public void read(String filename) {
        if (this.matchList.isEmpty()) {
            throw new IllegalStateException("matchList not initialized");
        }
        this.match = false;
        this.needResolveEntity = true;
        this.inputFile = new File(filename);
        this.filePath = this.inputFile.getParent();
        this.inputFile.getPath();
        if (this.indexEntries.length() != 0) {
            this.indexEntries = new StringBuffer(1024);
        }
        try {
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(filename, this.logger));
            InputSource source = URIResolverAdapter.convertToInputSource(DitaURIResolverFactory.getURIResolver().resolve(filename, null));
            this.reader.parse(source);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    public void setMatch(String matchPattern) {
        int index = 0;
        String string = this.firstMatchElement = matchPattern.indexOf("/") != -1 ? matchPattern.substring(0, matchPattern.indexOf("/")) : matchPattern;
        while (index != -1) {
            int start = matchPattern.indexOf("/", index);
            int end = matchPattern.indexOf("/", start + 1);
            if (start != -1 && end != -1) {
                this.lastMatchElement.add(matchPattern.substring(start + 1, end));
                index = end;
                continue;
            }
            if (start == -1 || end != -1) continue;
            this.lastMatchElement.add(matchPattern.substring(start + 1));
            index = -1;
        }
        this.matchList.add(this.firstMatchElement);
        Iterator<String> it = this.lastMatchElement.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append(it.next() + " ");
        }
        this.matchList.add(sb.toString());
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.match && this.validHref) {
            this.indexEntries.append("<![CDATA[");
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int attsLen = atts.getLength();
        String attrScope = atts.getValue("scope");
        String attrFormat = atts.getValue("format");
        if (qName.equals(this.firstMatchElement)) {
            String hrefValue = atts.getValue("href");
            if (MapLinksReader.verifyIndexEntries(this.indexEntries) && this.topicPath != null) {
                Map<String, String> m;
                String t = this.topicPath;
                String frag = "#";
                if (t.contains("#")) {
                    frag = t.indexOf("#") + 1 >= t.length() ? "#" : t.substring(t.indexOf("#") + 1);
                    t = t.substring(0, t.indexOf("#"));
                }
                if ((m = this.map.get(t)) != null) {
                    String orig = m.get(frag);
                    m.put(frag, StringUtils.setOrAppend(orig, this.indexEntries.toString(), false));
                } else {
                    m = new HashMap<String, String>(16);
                    m.put(frag, this.indexEntries.toString());
                    this.map.put(t, m);
                }
                this.indexEntries = new StringBuffer(1024);
            }
            this.topicPath = null;
            if (hrefValue != null && hrefValue.indexOf(INTERNET_LINK_MARK) == -1 && (attrScope == null || "local".equalsIgnoreCase(attrScope)) && (attrFormat == null || "dita".equalsIgnoreCase(attrFormat))) {
                this.topicPath = FileUtils.resolveTopic(this.filePath, hrefValue);
                this.validHref = true;
            } else {
                this.topicPath = null;
                this.validHref = false;
            }
        }
        if (!this.match) {
            this.ancestorList.add(qName);
            if (this.lastMatchElement.contains(qName) && this.checkMatch()) {
                this.match = true;
                this.level = 0;
            }
        }
        if (this.match) {
            if (this.validHref) {
                this.indexEntries.append("<" + qName + " ");
                for (int i = 0; i < attsLen; ++i) {
                    this.indexEntries.append(atts.getQName(i));
                    this.indexEntries.append("=");
                    this.indexEntries.append("\"");
                    this.indexEntries.append(StringUtils.escapeXML(atts.getValue(i)));
                    this.indexEntries.append("\"");
                    this.indexEntries.append(" ");
                }
                this.indexEntries.append(">");
            }
            ++this.level;
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.needResolveEntity = StringUtils.checkEntity(name);
        if (this.match && !this.needResolveEntity && this.validHref) {
            this.indexEntries.append(StringUtils.getEntity(name));
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        String pi;
        String string = pi = data != null ? target + " " + data : target;
        if (this.match && this.needResolveEntity && this.validHref) {
            String temp = "<?" + StringUtils.escapeXML(pi) + "?" + ">";
            this.indexEntries.append(temp);
        }
    }
}

