/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.Content;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MapMetaReader
implements AbstractReader {
    private static final String INTERNET_LINK_MARK = "://";
    private final Hashtable<String, Hashtable<String, Element>> resultTable = new Hashtable(16);
    public static final Set<String> uniqueSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_SOURCE.matcher, Constants.MAP_SEARCHTITLE.matcher)));
    private static final Set<String> cascadeSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_SOURCE.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_OTHERMETA.matcher, Constants.TOPIC_PUBLISHER.matcher)));
    private static final Set<String> metaSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_SOURCE.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_KEYWORDS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_OTHERMETA.matcher, Constants.TOPIC_RESOURCEID.matcher, Constants.TOPIC_DATA.matcher, Constants.TOPIC_DATA_ABOUT.matcher, Constants.TOPIC_FOREIGN.matcher, Constants.TOPIC_UNKNOWN.matcher)));
    private static final List<String> metaPos = Collections.unmodifiableList(Arrays.asList(Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_SOURCE.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_KEYWORDS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_OTHERMETA.matcher, Constants.TOPIC_RESOURCEID.matcher, Constants.TOPIC_DATA.matcher, Constants.TOPIC_DATA_ABOUT.matcher, Constants.TOPIC_FOREIGN.matcher, Constants.TOPIC_UNKNOWN.matcher, Constants.MAP_LINKTEXT.matcher, Constants.MAP_SHORTDESC.matcher, Constants.TOPIC_NAVTITLE.matcher, Constants.TOPIC_METADATA.matcher, Constants.DELAY_D_EXPORTANCHORS.matcher));
    private DITAOTLogger logger;
    private final Hashtable<String, Element> globalMeta = new Hashtable(16);
    private Document doc = null;
    private String filePath = null;

    public MapMetaReader() {
        this.resultTable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(String filename) {
        File inputFile = new File(filename);
        this.filePath = inputFile.getParent();
        inputFile.getPath();
        this.globalMeta.clear();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new DITAOTXMLErrorHandler(filename, this.logger));
            this.doc = builder.parse(inputFile);
            Element root = this.doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                Node classAttr = null;
                if (node.getNodeType() == 1) {
                    classAttr = node.getAttributes().getNamedItem("class");
                }
                if (classAttr != null && Constants.MAP_TOPICMETA.matches(classAttr.getNodeValue())) {
                    this.handleGlobalMeta(node);
                    continue;
                }
                if (classAttr == null || !Constants.MAP_TOPICREF.matches(classAttr.getNodeValue())) continue;
                this.handleTopicref(node, this.globalMeta);
            }
            for (Hashtable<String, Element> resultTableEntry : this.resultTable.values()) {
                for (Map.Entry<String, Element> mapEntry : resultTableEntry.entrySet()) {
                    String key = mapEntry.getKey();
                    if (!Constants.TOPIC_KEYWORDS.matcher.equals(key)) continue;
                    this.removeIndexTermRecursive(mapEntry.getValue());
                }
            }
            FileOutputStream file = null;
            try {
                file = new FileOutputStream(inputFile.getCanonicalPath() + ".temp");
                StreamResult res = new StreamResult(file);
                DOMSource ds = new DOMSource(this.doc);
                TransformerFactory tff = TransformerFactory.newInstance();
                Transformer tf = tff.newTransformer();
                tf.transform(ds, res);
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    private void removeIndexTermRecursive(Element parent) {
        if (parent == null) {
            return;
        }
        NodeList children = parent.getChildNodes();
        Element child = null;
        for (int i = 0; i < children.getLength(); ++i) {
            boolean hasEnd;
            if (children.item(i).getNodeType() != 1) continue;
            child = (Element)children.item(i);
            boolean isIndexTerm = Constants.TOPIC_INDEXTERM.matches(child.getAttribute("class"));
            boolean hasStart = !StringUtils.isEmptyString(child.getAttribute("start"));
            boolean bl = hasEnd = !StringUtils.isEmptyString(child.getAttribute("end"));
            if (isIndexTerm && (hasStart || hasEnd)) {
                parent.removeChild(child);
                continue;
            }
            this.removeIndexTermRecursive(child);
        }
    }

    private void handleTopicref(Node topicref, Hashtable<String, Element> inheritance) {
        Node hrefAttr = topicref.getAttributes().getNamedItem("href");
        Node copytoAttr = topicref.getAttributes().getNamedItem("copy-to");
        Node scopeAttr = topicref.getAttributes().getNamedItem("scope");
        Node formatAttr = topicref.getAttributes().getNamedItem("format");
        Hashtable<String, Element> current = this.mergeMeta(null, inheritance, cascadeSet);
        String topicPath = null;
        Node metaNode = null;
        NodeList children = topicref.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            Node classAttr = null;
            if (node.getNodeType() == 1) {
                classAttr = node.getAttributes().getNamedItem("class");
            }
            if (classAttr != null && hrefAttr != null && Constants.MAP_TOPICMETA.matches(classAttr.getNodeValue()) && hrefAttr != null && hrefAttr.getNodeValue().indexOf(INTERNET_LINK_MARK) == -1 && (scopeAttr == null || "local".equalsIgnoreCase(scopeAttr.getNodeValue())) && (formatAttr == null || "dita".equalsIgnoreCase(formatAttr.getNodeValue()) || formatAttr == null || "ditamap".equalsIgnoreCase(formatAttr.getNodeValue()))) {
                metaNode = node;
                current = this.handleMeta(node, inheritance);
                continue;
            }
            if (classAttr == null || !Constants.MAP_TOPICREF.matches(classAttr.getNodeValue())) continue;
            this.handleTopicref(node, current);
        }
        if (!current.isEmpty() && hrefAttr != null) {
            topicPath = copytoAttr != null && new File(FileUtils.resolveFile(this.filePath, URLUtils.decode(copytoAttr.getNodeValue()))).exists() ? FileUtils.resolveTopic(this.filePath, URLUtils.decode(copytoAttr.getNodeValue())) : FileUtils.resolveTopic(this.filePath, URLUtils.decode(hrefAttr.getNodeValue()));
            if ((formatAttr == null || "dita".equalsIgnoreCase(formatAttr.getNodeValue()) || formatAttr == null || "ditamap".equalsIgnoreCase(formatAttr.getNodeValue())) && (scopeAttr == null || "local".equalsIgnoreCase(scopeAttr.getNodeValue())) && hrefAttr.getNodeValue().indexOf(INTERNET_LINK_MARK) == -1) {
                if (this.resultTable.containsKey(topicPath)) {
                    Hashtable<String, Element> previous = this.resultTable.get(topicPath);
                    this.resultTable.put(topicPath, this.mergeMeta(previous, current, metaSet));
                } else {
                    this.resultTable.put(topicPath, this.cloneElementMap(current));
                }
                Hashtable<String, Element> metas = this.resultTable.get(topicPath);
                if (!metas.isEmpty()) {
                    if (metaNode != null) {
                        topicref.removeChild(metaNode);
                    }
                    Element newMeta = this.doc.createElement(Constants.MAP_TOPICMETA.localName);
                    newMeta.setAttribute("class", "-" + Constants.MAP_TOPICMETA.matcher);
                    for (int i = 0; i < metaPos.size(); ++i) {
                        Node stub = metas.get(metaPos.get(i));
                        if (stub == null) continue;
                        NodeList clist = stub.getChildNodes();
                        for (int j = 0; j < clist.getLength(); ++j) {
                            newMeta.appendChild(topicref.getOwnerDocument().importNode(clist.item(j), true));
                        }
                    }
                    topicref.insertBefore(newMeta, topicref.getFirstChild());
                }
            }
        }
    }

    private Hashtable<String, Element> cloneElementMap(Hashtable<String, Element> current) {
        Hashtable<String, Element> topicMetaTable = new Hashtable<String, Element>(16);
        for (Map.Entry<String, Element> topicMetaItem : current.entrySet()) {
            Element inheritStub = this.doc.createElement("stub");
            Node currentStub = topicMetaItem.getValue();
            NodeList stubChildren = currentStub.getChildNodes();
            for (int i = 0; i < stubChildren.getLength(); ++i) {
                Node item = stubChildren.item(i).cloneNode(true);
                item = inheritStub.getOwnerDocument().importNode(item, true);
                inheritStub.appendChild(item);
            }
            topicMetaTable.put(topicMetaItem.getKey(), inheritStub);
        }
        return topicMetaTable;
    }

    private Hashtable<String, Element> handleMeta(Node meta, Hashtable<String, Element> inheritance) {
        Hashtable<String, Element> topicMetaTable = new Hashtable<String, Element>(16);
        this.getMeta(meta, topicMetaTable);
        return this.mergeMeta(topicMetaTable, inheritance, cascadeSet);
    }

    private void getMeta(Node meta, Hashtable<String, Element> topicMetaTable) {
        NodeList children = meta.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            Node attr = null;
            if (node.getNodeType() == 1) {
                attr = node.getAttributes().getNamedItem("class");
            }
            if (attr == null) continue;
            String attrValue = attr.getNodeValue();
            String metaKey = attrValue.substring(1, attrValue.indexOf(" ", attrValue.indexOf("/")) + 1);
            if (Constants.TOPIC_METADATA.matches(attrValue)) {
                this.getMeta(node, topicMetaTable);
                continue;
            }
            if (topicMetaTable.containsKey(metaKey)) {
                topicMetaTable.get(metaKey).appendChild(node.cloneNode(true));
                continue;
            }
            Element stub = this.doc.createElement("stub");
            stub.appendChild(node.cloneNode(true));
            topicMetaTable.put(metaKey, stub);
        }
    }

    private Hashtable<String, Element> mergeMeta(Hashtable<String, Element> topicMetaTable, Hashtable<String, Element> inheritance, Set<String> enableSet) {
        if (topicMetaTable == null) {
            topicMetaTable = new Hashtable(16);
        }
        Node item = null;
        for (String key : enableSet) {
            Node inheritStub;
            if (!inheritance.containsKey(key)) continue;
            if (uniqueSet.contains(key)) {
                if (topicMetaTable.containsKey(key)) continue;
                topicMetaTable.put(key, inheritance.get(key));
                continue;
            }
            if (!topicMetaTable.containsKey(key)) {
                topicMetaTable.put(key, inheritance.get(key));
                continue;
            }
            Node stub = topicMetaTable.get(key);
            if (stub != (inheritStub = (Node)inheritance.get(key))) {
                NodeList children = inheritStub.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    item = children.item(i).cloneNode(true);
                    item = stub.getOwnerDocument().importNode(item, true);
                    stub.appendChild(item);
                }
            }
            topicMetaTable.put(key, (Element)stub);
        }
        return topicMetaTable;
    }

    private void handleGlobalMeta(Node metadata) {
        NodeList children = metadata.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            Node attr = null;
            if (node.getNodeType() == 1) {
                attr = node.getAttributes().getNamedItem("class");
            }
            if (attr == null) continue;
            String attrValue = attr.getNodeValue();
            String metaKey = attrValue.substring(1, attrValue.indexOf(" ", attrValue.indexOf("/")) + 1);
            if (Constants.TOPIC_METADATA.matches(attrValue)) {
                this.handleGlobalMeta(node);
                continue;
            }
            if (cascadeSet.contains(metaKey) && this.globalMeta.containsKey(metaKey)) {
                this.globalMeta.get(metaKey).appendChild(node.cloneNode(true));
                continue;
            }
            if (!cascadeSet.contains(metaKey)) continue;
            Element stub = this.doc.createElement("stub");
            stub.appendChild(node.cloneNode(true));
            this.globalMeta.put(metaKey, stub);
        }
    }

    @Override
    @Deprecated
    public Content getContent() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Hashtable<String, Element>> getMapping() {
        return Collections.unmodifiableMap(this.resultTable);
    }
}

