/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.MergeTopicParser;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class MergeMapParser
extends XMLFilterImpl {
    public static final String ATTRIBUTE_NAME_FIRST_TOPIC_ID = "first_topic_id";
    public static final String ATTRIBUTE_NAME_OHREF = "ohref";
    public static final String ATTRIBUTE_NAME_OID = "oid";
    private final XMLReader reader;
    private final MergeTopicParser topicParser;
    private final MergeUtils util;
    private String dirPath = null;
    private String tempdir = null;
    private final Stack<String> processStack = new Stack();
    private int processLevel = 0;
    private final ByteArrayOutputStream topicBuffer;
    private final SAXTransformerFactory stf;
    private OutputStream output;
    private DITAOTLogger logger;

    public MergeMapParser() {
        this.util = new MergeUtils();
        this.topicParser = new MergeTopicParser(this.util);
        this.topicBuffer = new ByteArrayOutputStream();
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            TransformerFactory tf = TransformerFactory.newInstance();
            if (!tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw new RuntimeException("SAX transformation factory not supported");
            }
            this.stf = (SAXTransformerFactory)tf;
            TransformerHandler s = this.stf.newTransformerHandler();
            s.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
            s.setResult(new StreamResult(this.topicBuffer));
            this.topicParser.setContentHandler(s);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    public final void setLogger(DITAOTLogger logger) {
        this.logger = logger;
        this.topicParser.setLogger(logger);
    }

    public void setOutputStream(OutputStream output) {
        this.output = output;
    }

    public void read(String filename, String tmpDir) {
        this.tempdir = tmpDir != null ? tmpDir : new File(filename).getParent();
        try {
            TransformerHandler s = this.stf.newTransformerHandler();
            s.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
            s.setResult(new StreamResult(this.output));
            this.setContentHandler(s);
            File input = new File(filename);
            this.dirPath = input.getParent();
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(input.getAbsolutePath(), this.logger));
            this.topicParser.getContentHandler().startDocument();
            this.reader.parse(input.toURI().toString());
            this.topicParser.getContentHandler().endDocument();
            this.output.write(this.topicBuffer.toByteArray());
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.processLevel > 0) {
            String value = this.processStack.peek();
            if (this.processLevel == this.processStack.size()) {
                value = this.processStack.pop();
            }
            --this.processLevel;
            if ("resource-only".equalsIgnoreCase(value)) {
                return;
            }
        }
        this.getContentHandler().endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.processStack.empty() || !"resource-only".equalsIgnoreCase(this.processStack.peek())) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String attValue;
        String attrValue = attributes.getValue("processing-role");
        if (attrValue != null) {
            this.processStack.push(attrValue);
            ++this.processLevel;
            if ("resource-only".equalsIgnoreCase(attrValue)) {
                return;
            }
        } else if (this.processLevel > 0) {
            ++this.processLevel;
            if ("resource-only".equalsIgnoreCase(this.processStack.peek())) {
                return;
            }
        }
        Attributes atts = null;
        if (Constants.MAP_TOPICREF.matches(attributes) && (attValue = attributes.getValue("href")) != null) {
            atts = new AttributesImpl(attributes);
            String scopeValue = ((AttributesImpl)atts).getValue("scope");
            String formatValue = ((AttributesImpl)atts).getValue("format");
            if ((scopeValue == null || "local".equalsIgnoreCase(scopeValue)) && (formatValue == null || "dita".equalsIgnoreCase(formatValue))) {
                String ohref = attValue;
                String copyToValue = ((AttributesImpl)atts).getValue("copy-to");
                if (!StringUtils.isEmptyString(copyToValue)) {
                    attValue = copyToValue;
                }
                XMLUtils.addOrSetAttribute((AttributesImpl)atts, ATTRIBUTE_NAME_OHREF, ohref);
                if (this.util.isVisited(attValue)) {
                    attValue = "#" + this.util.getIdValue(attValue);
                } else {
                    String p = null;
                    try {
                        p = FileUtils.normalize(URLDecoder.decode(FileUtils.stripFragment(attValue), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    this.util.visit(p);
                    if (p != null) {
                        File f = new File(this.dirPath, p);
                        if (f.exists()) {
                            this.topicParser.parse(p, this.dirPath);
                            String fileId = this.topicParser.getFirstTopicId();
                            this.util.addId(attValue, fileId);
                            if (FileUtils.getFragment(attValue) != null) {
                                this.util.addId(FileUtils.stripFragment(attValue), fileId);
                            }
                            String firstTopicId = "#" + fileId;
                            attValue = this.util.getIdValue(attValue) != null ? "#" + this.util.getIdValue(attValue) : firstTopicId;
                            XMLUtils.addOrSetAttribute((AttributesImpl)atts, ATTRIBUTE_NAME_FIRST_TOPIC_ID, firstTopicId);
                        } else {
                            String fileName = new File(this.dirPath, attValue).getAbsolutePath();
                            this.logger.logError(MessageUtils.getInstance().getMessage("DOTX008E", fileName).toString());
                        }
                    }
                }
            }
            XMLUtils.addOrSetAttribute((AttributesImpl)atts, "href", attValue);
        }
        this.getContentHandler().startElement(uri, localName, qName, atts != null ? atts : attributes);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            Job job = new Job(new File(this.tempdir));
            Set<String> resourceOnlySet = job.getSet("resourceonlylist");
            Set<String> skipTopicSet = job.getSet("skipchunklist");
            Set<String> chunkedTopicSet = job.getSet("chunkedtopiclist");
            for (String element : job.getSet("hreftargetslist")) {
                if (!new File(this.dirPath).equals(new File(this.tempdir))) {
                    element = FileUtils.getRelativePath(new File(this.dirPath, "a.ditamap").getAbsolutePath(), new File(this.tempdir, element).getAbsolutePath());
                }
                if (this.util.isVisited(element)) continue;
                this.util.visit(element);
                if (resourceOnlySet.contains(element) || !chunkedTopicSet.contains(element) && skipTopicSet.contains(element)) continue;
                File f = new File(this.dirPath, element);
                if (f.exists()) {
                    this.topicParser.parse(element, this.dirPath);
                    continue;
                }
                String fileName = f.getAbsolutePath();
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTX008E", fileName).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        this.getContentHandler().endDocument();
    }
}

