/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.net.URI;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class MergeTopicParser
extends XMLFilterImpl {
    private String dirPath = null;
    private String filePath = null;
    private boolean isFirstTopic = false;
    private String rootLang = null;
    private final XMLReader reader;
    private String firstTopicId = null;
    private final MergeUtils util;
    private DITAOTLogger logger;

    public MergeTopicParser(MergeUtils util) {
        this.util = util;
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    public final void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public String getFirstTopicId() {
        return this.firstTopicId;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("dita".equalsIgnoreCase(qName)) {
            return;
        }
        this.getContentHandler().endElement(uri, localName, qName);
    }

    private void handleID(String classValue, AttributesImpl atts) {
        String idValue = atts.getValue("id");
        if (idValue != null) {
            String value = this.filePath + "#" + idValue;
            if (this.util.findId(value)) {
                XMLUtils.addOrSetAttribute(atts, "oid", idValue);
                idValue = this.util.getIdValue(value);
            } else {
                XMLUtils.addOrSetAttribute(atts, "oid", idValue);
                idValue = this.util.addId(value);
            }
            XMLUtils.addOrSetAttribute(atts, "id", idValue);
        }
    }

    private String handleLocalDita(int sharpIndex, String attValue, AttributesImpl atts) {
        String retAttValue = attValue;
        if (sharpIndex != -1) {
            String pathFromMap = sharpIndex == 0 ? FileUtils.separatorsToUnix(this.filePath) : FileUtils.separatorsToUnix(FileUtils.resolveTopic(new File(this.filePath).getParent(), attValue.substring(0, sharpIndex)));
            pathFromMap = URLUtils.decode(pathFromMap);
            XMLUtils.addOrSetAttribute(atts, "ohref", URLUtils.clean(pathFromMap + attValue.substring(sharpIndex), false));
            String topicId = attValue.substring(sharpIndex);
            int slashIndex = topicId.indexOf("/");
            int index = attValue.indexOf("/", sharpIndex);
            String string = topicId = slashIndex != -1 ? pathFromMap + topicId.substring(0, slashIndex) : pathFromMap + topicId;
            if (this.util.findId(topicId)) {
                String prefix = "#" + this.util.getIdValue(topicId);
                retAttValue = index != -1 ? prefix + attValue.substring(index) : prefix;
            } else {
                String prefix = "#" + this.util.addId(topicId);
                retAttValue = index != -1 ? prefix + attValue.substring(index) : prefix;
            }
        } else {
            String pathFromMap = FileUtils.resolveTopic(new File(this.filePath).getParent(), attValue);
            pathFromMap = URLUtils.decode(pathFromMap);
            XMLUtils.addOrSetAttribute(atts, "ohref", URLUtils.clean(pathFromMap, false));
            if (this.util.findId(pathFromMap)) {
                retAttValue = "#" + this.util.getIdValue(pathFromMap);
            } else {
                String fileId = MergeUtils.getFirstTopicId(pathFromMap, this.dirPath, false);
                String key = pathFromMap + "#" + fileId;
                if (this.util.findId(key)) {
                    this.util.addId(pathFromMap, this.util.getIdValue(key));
                    retAttValue = "#" + this.util.getIdValue(key);
                } else {
                    retAttValue = "#" + this.util.addId(pathFromMap);
                    this.util.addId(key, this.util.getIdValue(pathFromMap));
                }
            }
        }
        return URLUtils.clean(retAttValue, false);
    }

    public void parse(String filename, String dir) {
        int index = filename.indexOf("#");
        this.filePath = index != -1 ? filename.substring(0, index) : filename;
        this.dirPath = dir;
        try {
            File f = new File(dir + File.separator + this.filePath);
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(f.getAbsolutePath(), this.logger));
            this.reader.parse(f.toURI().toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse " + filename + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.firstTopicId = null;
        this.isFirstTopic = true;
        this.rootLang = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("dita".equalsIgnoreCase(qName)) {
            this.rootLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
            return;
        }
        AttributesImpl atts = new AttributesImpl(attributes);
        String classValue = atts.getValue("class");
        if (Constants.TOPIC_TOPIC.matches(classValue)) {
            if (this.isFirstTopic) {
                if (atts.getIndex("http://www.w3.org/XML/1998/namespace", "lang") == -1) {
                    atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", this.rootLang != null ? this.rootLang : Configuration.configuration.get("default.language"));
                    this.rootLang = null;
                }
                this.isFirstTopic = false;
            }
            this.handleID(classValue, atts);
            if (this.firstTopicId == null) {
                this.firstTopicId = atts.getValue("id");
            }
        }
        this.handleHref(classValue, atts);
        this.getContentHandler().startElement(uri, localName, qName, atts);
    }

    private void handleHref(String classValue, AttributesImpl atts) {
        String attValue = atts.getValue("href");
        if (attValue != null) {
            String scopeValue = atts.getValue("scope");
            int sharpIndex = attValue.indexOf("#");
            if ((scopeValue == null || "local".equalsIgnoreCase(scopeValue)) && attValue.indexOf("://") == -1) {
                String formatValue = atts.getValue("format");
                if ((Constants.TOPIC_XREF.matches(classValue) || Constants.TOPIC_LINK.matches(classValue) || Constants.TOPIC_TERM.matches(classValue) || Constants.TOPIC_KEYWORD.matches(classValue)) && (formatValue == null || "dita".equalsIgnoreCase(formatValue))) {
                    XMLUtils.addOrSetAttribute(atts, "href", this.handleLocalDita(sharpIndex, attValue, atts));
                } else {
                    XMLUtils.addOrSetAttribute(atts, "href", this.handleLocalHref(attValue));
                }
            }
        }
    }

    private String handleLocalHref(String attValue) {
        File parentFile = new File(this.filePath).getParentFile();
        if (parentFile != null) {
            URI d = new File(this.dirPath).toURI();
            URI p = new File(this.dirPath, this.filePath).getParentFile().toURI();
            String b = d.relativize(p).toASCIIString();
            StringBuilder ret = new StringBuilder(b);
            if (!b.endsWith("/")) {
                ret.append("/");
            }
            ret.append(attValue);
            return FileUtils.normalize(ret.toString(), "/");
        }
        return attValue;
    }
}

