/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SubjectSchemeReader {
    private DITAOTLogger logger;
    private final Map<String, Map<String, Set<Element>>> bindingMap;
    private final Map<String, Map<String, Set<String>>> validValuesMap = new HashMap<String, Map<String, Set<String>>>();
    private final Map<String, Map<String, String>> defaultValueMap = new HashMap<String, Map<String, String>>();

    public SubjectSchemeReader() {
        this.bindingMap = new HashMap<String, Map<String, Set<Element>>>();
    }

    public void reset() {
        this.validValuesMap.clear();
        this.defaultValueMap.clear();
        this.bindingMap.clear();
    }

    public Map<String, Map<String, Set<String>>> getValidValuesMap() {
        return this.validValuesMap;
    }

    public Map<String, Map<String, String>> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    public Map<String, Map<String, Set<Element>>> getSubjectSchemeMap() {
        return this.bindingMap;
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void loadSubjectScheme(String scheme) {
        if (!FileUtils.fileExists(scheme)) {
            return;
        }
        this.logger.logDebug("Load subject scheme " + scheme);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new FileInputStream(new File(scheme))));
            Element schemeRoot = doc.getDocumentElement();
            if (schemeRoot == null) {
                return;
            }
            NodeList rootChildren = schemeRoot.getChildNodes();
            for (int i = 0; i < rootChildren.getLength(); ++i) {
                Element node;
                String attrValue;
                if (rootChildren.item(i).getNodeType() != 1 || !Constants.SUBJECTSCHEME_ENUMERATIONDEF.matches(attrValue = (node = (Element)rootChildren.item(i)).getAttribute("class"))) continue;
                NodeList enumChildren = node.getChildNodes();
                String elementName = "*";
                String attributeName = null;
                for (int j = 0; j < enumChildren.getLength(); ++j) {
                    Set<Element> A;
                    Element subTree;
                    String keyValue;
                    if (enumChildren.item(j).getNodeType() != 1) continue;
                    node = (Element)enumChildren.item(j);
                    attrValue = node.getAttribute("class");
                    if (Constants.SUBJECTSCHEME_ELEMENTDEF.matches(attrValue)) {
                        elementName = node.getAttribute("name");
                        continue;
                    }
                    if (Constants.SUBJECTSCHEME_ATTRIBUTEDEF.matches(attrValue)) {
                        attributeName = node.getAttribute("name");
                        Map<String, Set<Element>> S = this.bindingMap.get(attributeName);
                        if (S != null) continue;
                        S = new HashMap<String, Set<Element>>();
                        this.bindingMap.put(attributeName, S);
                        continue;
                    }
                    if (Constants.SUBJECTSCHEME_DEFAULTSUBJECT.matches(attrValue)) {
                        keyValue = node.getAttribute("keyref");
                        if (keyValue == null) continue;
                        Map<String, String> S = this.defaultValueMap.get(attributeName);
                        if (S == null) {
                            S = new HashMap<String, String>();
                        }
                        S.put(elementName, keyValue);
                        this.defaultValueMap.put(attributeName, S);
                        continue;
                    }
                    if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(attrValue)) continue;
                    keyValue = node.getAttribute("keyref");
                    if (StringUtils.isEmptyString(keyValue)) {
                        keyValue = node.getAttribute("keys");
                    }
                    if ((subTree = this.searchForKey(schemeRoot, keyValue)) == null) continue;
                    Map<String, Set<Element>> S = this.bindingMap.get(attributeName);
                    if (S == null) {
                        S = new HashMap<String, Set<Element>>();
                    }
                    if ((A = S.get(elementName)) == null) {
                        A = new HashSet<Element>();
                    }
                    if (!A.contains(subTree)) {
                        this.putValuePairsIntoMap(subTree, elementName, attributeName);
                    }
                    A.add(subTree);
                    S.put(elementName, A);
                    this.bindingMap.put(attributeName, S);
                }
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private Element searchForKey(Element root, String keyValue) {
        if (root == null || keyValue == null) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.add(root);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.removeFirst();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.add((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || !keyValue.equals(key = node.getAttribute("keys"))) continue;
            return node;
        }
        return null;
    }

    private void putValuePairsIntoMap(Element subtree, String elementName, String attName) {
        Set<String> valueSet;
        if (subtree == null || attName == null) {
            return;
        }
        Map<String, Set<String>> valueMap = this.validValuesMap.get(attName);
        if (valueMap == null) {
            valueMap = new HashMap<String, Set<String>>();
        }
        if ((valueSet = valueMap.get(elementName)) == null) {
            valueSet = new HashSet<String>();
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(subtree);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.poll();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.offer((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || StringUtils.isEmptyString(key = node.getAttribute("keys"))) continue;
            valueSet.add(key);
        }
        valueMap.put(elementName, valueSet);
        this.validValuesMap.put(attName, valueMap);
    }
}

