/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dita.dost.log.DITAOTJavaLogger;

public final class CatalogUtils {
    private static DITAOTJavaLogger logger = new DITAOTJavaLogger();
    private static CatalogResolver catalogResolver = null;
    private static File ditaDir;

    private CatalogUtils() {
    }

    public static synchronized void setDitaDir(File ditaDir) {
        catalogResolver = null;
        CatalogUtils.ditaDir = ditaDir;
    }

    public static synchronized CatalogResolver getCatalogResolver() {
        if (catalogResolver == null) {
            CatalogManager manager = new CatalogManager();
            manager.setIgnoreMissingProperties(true);
            manager.setUseStaticCatalog(false);
            manager.setPreferPublic(true);
            catalogResolver = new CatalogResolver(manager);
            File catalogFilePath = new File(ditaDir, "catalog-dita.xml");
            Catalog catalog = catalogResolver.getCatalog();
            try {
                catalog.parseCatalog(catalogFilePath.toURI().toASCIIString());
            }
            catch (Exception e) {
                logger.logError(e.getMessage(), e);
            }
        }
        return catalogResolver;
    }
}

