/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Job;
import org.dita.dost.util.LangParser;
import org.dita.dost.util.StringUtils;
import org.xml.sax.helpers.DefaultHandler;

public final class CheckLang
extends Task {
    private String basedir;
    private String tempdir;
    private String outputdir;
    private String inputmap;
    private String message;
    private DITAOTLogger logger;

    public void execute() {
        this.logger = new DITAOTAntLogger(this.getProject());
        this.logger.logInfo(this.message);
        new Properties();
        if (!new File(this.tempdir).isAbsolute()) {
            this.tempdir = new File(this.basedir, this.tempdir).getAbsolutePath();
        }
        if (!new File(this.outputdir).isAbsolute()) {
            this.outputdir = new File(this.basedir, this.outputdir).getAbsolutePath();
        }
        if (!new File(this.inputmap).isAbsolute()) {
            this.inputmap = new File(this.tempdir, this.inputmap).getAbsolutePath();
        }
        Job job = null;
        try {
            job = new Job(new File(this.tempdir));
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        LangParser parser = new LangParser();
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse(this.inputmap, (DefaultHandler)parser);
            String langCode = parser.getLangCode();
            if (!StringUtils.isEmptyString(langCode)) {
                this.setActiveProjectProperty("htmlhelp.locale", langCode);
            } else {
                Set<String> topicList = job.getSet("fullditatopiclist");
                for (String topicFileName : topicList) {
                    File topicFile = new File(this.tempdir, topicFileName);
                    if (!topicFile.exists()) continue;
                    saxParser.parse(topicFile, (DefaultHandler)parser);
                    langCode = parser.getLangCode();
                    if (StringUtils.isEmptyString(langCode)) continue;
                    this.setActiveProjectProperty("htmlhelp.locale", langCode);
                    break;
                }
                if (StringUtils.isEmptyString(langCode)) {
                    this.setActiveProjectProperty("htmlhelp.locale", "en-us");
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().equals("Search finished")) {
                System.out.println("Lang search finished");
            }
            e.printStackTrace();
        }
    }

    private void setActiveProjectProperty(String propertyName, String propertyValue) {
        Project activeProject = this.getProject();
        if (activeProject != null) {
            activeProject.setProperty(propertyName, propertyValue);
        }
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setTempdir(String tempdir) {
        this.tempdir = tempdir;
    }

    public void setInputmap(String inputmap) {
        this.inputmap = inputmap;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }
}

