/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.platform.Integrator;
import org.dita.dost.util.FileUtils;

public final class Configuration {
    private static final DITAOTJavaLogger logger = new DITAOTJavaLogger();
    public static final Map<String, String> configuration;
    public static final Mode processingMode;

    private Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        HashMap<String, String> c = new HashMap<String, String>();
        Properties pluginProperties = new Properties();
        InputStream plugingConfigurationInputStream = null;
        try {
            ClassLoader loader = FileUtils.class.getClassLoader();
            plugingConfigurationInputStream = loader.getResourceAsStream(Integrator.class.getPackage().getName() + "/" + "plugin.properties");
            if (plugingConfigurationInputStream != null) {
                pluginProperties.load(plugingConfigurationInputStream);
            } else {
                File configurationFile = new File("lib", Integrator.class.getPackage().getName() + File.separator + "plugin.properties");
                if (configurationFile.exists()) {
                    plugingConfigurationInputStream = new BufferedInputStream(new FileInputStream(configurationFile));
                    pluginProperties.load(plugingConfigurationInputStream);
                }
            }
        }
        catch (IOException e) {
            logger.logError(e.getMessage(), e);
        }
        finally {
            if (plugingConfigurationInputStream != null) {
                try {
                    plugingConfigurationInputStream.close();
                }
                catch (IOException ex) {
                    logger.logError(ex.getMessage(), ex);
                }
            }
        }
        for (Map.Entry<Object, Object> e : pluginProperties.entrySet()) {
            c.put(e.getKey().toString(), e.getValue().toString());
        }
        Properties properties = new Properties();
        InputStream configurationInputStream = null;
        try {
            ClassLoader loader = FileUtils.class.getClassLoader();
            configurationInputStream = loader.getResourceAsStream("configuration.properties");
            if (configurationInputStream != null) {
                properties.load(configurationInputStream);
            } else {
                File configurationFile = new File("lib", "configuration.properties");
                if (configurationFile.exists()) {
                    configurationInputStream = new BufferedInputStream(new FileInputStream(configurationFile));
                    properties.load(configurationInputStream);
                }
            }
        }
        catch (IOException e) {
            logger.logError(e.getMessage(), e);
        }
        finally {
            if (configurationInputStream != null) {
                try {
                    configurationInputStream.close();
                }
                catch (IOException ex) {
                    logger.logError(ex.getMessage(), ex);
                }
            }
        }
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            c.put(e.getKey().toString(), e.getValue().toString());
        }
        configuration = Collections.unmodifiableMap(c);
        String mode = configuration.get("processing-mode");
        processingMode = mode != null ? Mode.valueOf(mode.toUpperCase()) : Mode.LAX;
    }

    public static enum Mode {
        STRICT,
        SKIP,
        LAX;

    }
}

