/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConvertLang
extends Task {
    private static final String tag1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String tag2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>[OPTIONS]";
    private static final String tag3 = "&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;";
    private String basedir;
    private String outputdir;
    private String message;
    private String langcode;
    private final Map<String, String> charsetMap = new HashMap<String, String>();
    private final Map<String, String> langMap = new HashMap<String, String>();
    private final Map<String, String> entityMap = new HashMap<String, String>();
    private DITAOTLogger logger;

    public void execute() {
        this.logger = new DITAOTAntLogger(this.getProject());
        this.logger.logInfo(this.message);
        if (!new File(this.outputdir).isAbsolute()) {
            this.outputdir = new File(this.basedir, this.outputdir).getAbsolutePath();
        }
        this.createLangMap();
        this.createEntityMap();
        this.createCharsetMap();
        this.convertHtmlCharset();
        this.updateAllEntitiesAndLangs();
    }

    private void createLangMap() {
        Properties entities = new Properties();
        InputStream in = null;
        try {
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/dita/dost/util/languages.properties");
            entities.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read language property file: " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        for (Map.Entry<Object, Object> e : entities.entrySet()) {
            this.langMap.put((String)e.getKey(), (String)e.getValue());
        }
    }

    private void createEntityMap() {
        Properties entities = new Properties();
        InputStream in = null;
        try {
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/dita/dost/util/entities.properties");
            entities.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read entities property file: " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        for (Map.Entry<Object, Object> e : entities.entrySet()) {
            this.entityMap.put((String)e.getKey(), (String)e.getValue());
        }
    }

    private void createCharsetMap() {
        InputStream in = null;
        try {
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/dita/dost/util/codepages.xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element e;
                String lang;
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1 || !this.langcode.equalsIgnoreCase(lang = (e = (Element)node).getAttribute("lang")) && !lang.startsWith(this.langcode)) continue;
                NodeList subChild = e.getChildNodes();
                for (int j = 0; j < subChild.getLength(); ++j) {
                    Node subNode = subChild.item(j);
                    if (subNode.getNodeType() != 1) continue;
                    Element elem = (Element)subNode;
                    String format = elem.getAttribute("format");
                    String charset = elem.getAttribute("charset");
                    this.charsetMap.put(format, charset);
                }
                break;
            }
            if (this.charsetMap.size() == 0) {
                this.charsetMap.put("html", "iso-8859-1");
                this.charsetMap.put("windows", "windows-1252");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read charset configuration file: " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String replaceXmlTag(String source, String tag) {
        int startPos = source.indexOf(tag);
        int endPos = startPos + tag.length();
        StringBuilder sb = new StringBuilder();
        sb.append(source.substring(0, startPos)).append(source.substring(endPos));
        return sb.toString();
    }

    private void convertHtmlCharset() {
        File[] files;
        File outputDir = new File(this.outputdir);
        for (File file : files = outputDir.listFiles()) {
            this.convertCharset(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertCharset(File inputFile) {
        if (inputFile.isDirectory()) {
            File[] files;
            for (File file : files = inputFile.listFiles()) {
                this.convertCharset(file);
            }
            return;
        }
        if (!FileUtils.isHTMLFile(inputFile.getName()) && !FileUtils.isHHCFile(inputFile.getName()) && !FileUtils.isHHKFile(inputFile.getName())) return;
        String fileName = inputFile.getAbsolutePath();
        File outputFile = new File(fileName + ".temp");
        this.log("Processing " + fileName, 2);
        BufferedReader reader = null;
        Writer writer = null;
        try {
            FileInputStream inputStream = new FileInputStream(inputFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(streamReader);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            writer = new BufferedWriter(streamWriter);
            String value = reader.readLine();
            while (value != null) {
                if (value.contains("<meta http-equiv") && value.contains("charset")) {
                    int insertPoint = value.indexOf("charset=") + "charset=".length();
                    String subString = value.substring(0, insertPoint);
                    int remainIndex = value.indexOf("UTF-8") + "UTF-8".length();
                    String remainString = value.substring(remainIndex);
                    String newValue = subString + this.charsetMap.get("html") + remainString;
                    writer.write(newValue);
                    writer.write(Constants.LINE_SEPARATOR);
                } else {
                    if (value.contains(tag1)) {
                        value = this.replaceXmlTag(value, tag1);
                    } else if (value.contains(tag2)) {
                        value = this.replaceXmlTag(value, tag2);
                    } else if (value.contains(tag3)) {
                        value = this.replaceXmlTag(value, tag3);
                    }
                    writer.write(value);
                    writer.write(Constants.LINE_SEPARATOR);
                }
                value = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.logError(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close input stream: " + e.getMessage());
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close output stream: " + e.getMessage());
                }
            }
        }
        try {
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (outputFile.renameTo(inputFile)) return;
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            return;
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private void updateAllEntitiesAndLangs() {
        File[] files;
        File outputDir = new File(this.outputdir);
        for (File file : files = outputDir.listFiles()) {
            this.updateEntityAndLang(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateEntityAndLang(File inputFile) {
        if (inputFile.isDirectory()) {
            File[] files;
            for (File file : files = inputFile.listFiles()) {
                this.updateEntityAndLang(file);
            }
            return;
        }
        if (FileUtils.isHTMLFile(inputFile.getName()) || FileUtils.isHHCFile(inputFile.getName()) || FileUtils.isHHKFile(inputFile.getName())) {
            this.convertEntityAndCharset(inputFile, "html");
            return;
        }
        if (!FileUtils.isHHPFile(inputFile.getName())) return;
        this.convertEntityAndCharset(inputFile, "windows");
        String fileName = inputFile.getAbsolutePath();
        File outputFile = new File(fileName + ".temp");
        String charset = this.charsetMap.get("windows");
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            FileInputStream inputStream = new FileInputStream(inputFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, charset);
            reader = new BufferedReader(streamReader);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
            writer = new BufferedWriter(streamWriter);
            String value = reader.readLine();
            while (value != null) {
                if (value.contains(tag1)) {
                    value = this.replaceXmlTag(value, tag1);
                } else if (value.contains(tag2)) {
                    value = this.replaceXmlTag(value, tag2);
                } else if (value.contains(tag3)) {
                    value = this.replaceXmlTag(value, tag3);
                }
                if (value.contains("Language=")) {
                    String newValue = this.langMap.get(this.langcode);
                    if (newValue == null) {
                        newValue = this.langMap.get(this.langcode.split("-")[0]);
                    }
                    if (newValue == null) throw new IllegalArgumentException("Unsupported language code '" + this.langcode + "', unable to map to a Locale ID.");
                    writer.write("Language=" + newValue);
                    writer.write(Constants.LINE_SEPARATOR);
                } else {
                    writer.write(value);
                    writer.write(Constants.LINE_SEPARATOR);
                }
                value = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.logError(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close input stream: " + e.getMessage());
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close output stream: " + e.getMessage());
                }
            }
        }
        try {
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (outputFile.renameTo(inputFile)) return;
            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            return;
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertEntityAndCharset(File inputFile, String format) {
        String fileName = inputFile.getAbsolutePath();
        File outputFile = new File(fileName + ".temp");
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            FileInputStream inputStream = new FileInputStream(inputFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(streamReader);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            String charset = this.charsetMap.get(format);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
            writer = new BufferedWriter(streamWriter);
            int charCode = reader.read();
            while (charCode != -1) {
                String key = String.valueOf(charCode);
                if (this.entityMap.containsKey(key)) {
                    String value = this.entityMap.get(key);
                    writer.write(value);
                } else {
                    writer.write(charCode);
                }
                charCode = reader.read();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.logError(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close input stream: " + e.getMessage());
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close output stream: " + e.getMessage());
                }
            }
        }
        try {
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setLangcode(String langcode) {
        this.langcode = langcode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }
}

