/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DITAAttrUtils {
    private static final List<String> printTranstype;
    private static final List<String> excludeList;
    private int printLevel = 0;
    private static DITAAttrUtils util;

    private DITAAttrUtils() {
    }

    public static DITAAttrUtils getInstance() {
        return util;
    }

    public boolean increasePrintLevel(String printValue) {
        if (printValue != null) {
            if ("printonly".equals(printValue)) {
                ++this.printLevel;
                return true;
            }
            if (this.printLevel > 0) {
                ++this.printLevel;
                return true;
            }
        } else if (this.printLevel > 0) {
            ++this.printLevel;
            return true;
        }
        return false;
    }

    public boolean decreasePrintLevel() {
        if (this.printLevel > 0) {
            --this.printLevel;
            return true;
        }
        return false;
    }

    public boolean needExcludeForPrintAttri(String transtype) {
        return this.printLevel > 0 && !printTranstype.contains(transtype);
    }

    public void reset() {
        this.printLevel = 0;
    }

    public Element searchForNode(Element root, String searchKey, String attrName, String classValue) {
        if (root == null || StringUtils.isEmptyString(searchKey)) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            String value;
            Element pe = (Element)queue.poll();
            NodeList pchildrenList = pe.getChildNodes();
            for (int i = 0; i < pchildrenList.getLength(); ++i) {
                Node node = pchildrenList.item(i);
                if (node.getNodeType() != 1) continue;
                queue.offer((Element)node);
            }
            String clazzValue = pe.getAttribute("class");
            if (StringUtils.isEmptyString(clazzValue) || !clazzValue.contains(classValue) || StringUtils.isEmptyString(value = pe.getAttribute(attrName)) || !searchKey.equals(value)) continue;
            return pe;
        }
        return null;
    }

    public String getText(Node root) {
        StringBuffer result = new StringBuffer(1024);
        if (root == null) {
            return "";
        }
        if (root.hasChildNodes()) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() == 1) {
                    Element e = (Element)childNode;
                    String value = e.getAttribute("class");
                    if (excludeList.contains(value)) continue;
                    String s = this.getText(e);
                    result.append(s);
                    continue;
                }
                if (childNode.getNodeType() != 3) continue;
                result.append(childNode.getNodeValue());
            }
        } else if (root.getNodeType() == 3) {
            result.append(root.getNodeValue());
        }
        return result.toString();
    }

    public Element getTopicDoc(String absolutePathToFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(absolutePathToFile);
            Element root = doc.getDocumentElement();
            return root;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getChildElementValueOfTopicmeta(Element element, String classValue) {
        String returnValue = null;
        if (element.hasChildNodes()) {
            Element topicMeta = this.getElementNode(element, Constants.MAP_TOPICMETA.matcher);
            if (topicMeta == null) {
                return returnValue;
            }
            Element elem = this.getElementNode(topicMeta, classValue);
            if (elem == null) {
                return returnValue;
            }
            returnValue = this.getText(elem);
        }
        return returnValue;
    }

    public Element getElementNode(Element element, String classValue) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element child;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !(child = (Element)node).getAttribute("class").contains(classValue)) continue;
            return child;
        }
        return null;
    }

    static {
        ArrayList<String> types = new ArrayList<String>();
        String printTranstypes = Configuration.configuration.get("print_transtypes");
        if (printTranstypes != null) {
            if (printTranstypes.trim().length() > 0) {
                for (String transtype : printTranstypes.split(";")) {
                    types.add(transtype.trim());
                }
            }
        } else {
            new DITAOTJavaLogger().logError("Failed to read print transtypes from configuration, using defaults.");
            types.add("pdf");
        }
        printTranstype = Collections.unmodifiableList(types);
        ArrayList<String> el = new ArrayList<String>();
        el.add(Constants.TOPIC_INDEXTERM.toString());
        el.add(Constants.TOPIC_DRAFT_COMMENT.toString());
        el.add(Constants.TOPIC_REQUIRED_CLEANUP.toString());
        el.add(Constants.TOPIC_DATA.toString());
        el.add(Constants.TOPIC_DATA_ABOUT.toString());
        el.add(Constants.TOPIC_UNKNOWN.toString());
        el.add(Constants.TOPIC_FOREIGN.toString());
        excludeList = Collections.unmodifiableList(el);
        util = new DITAAttrUtils();
    }
}

