/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;

public final class DITAOTCollator
implements Comparator {
    static HashMap<Locale, DITAOTCollator> cache = new HashMap();
    private Object collatorInstance = null;
    private Method compareMethod = null;

    public static DITAOTCollator getInstance() {
        return DITAOTCollator.getInstance(Locale.US);
    }

    public static DITAOTCollator getInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale may not be null");
        }
        DITAOTCollator instance = null;
        instance = cache.get(locale);
        if (instance == null) {
            instance = new DITAOTCollator(locale);
            cache.put(locale, instance);
        }
        return instance;
    }

    private DITAOTCollator() {
        this(Locale.US);
    }

    private DITAOTCollator(Locale locale) {
        this.init(locale);
    }

    public int compare(Object source, Object target) {
        try {
            return (Integer)this.compareMethod.invoke(this.collatorInstance, source, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void init(Locale locale) {
        Class<Object> c = null;
        try {
            c = Class.forName("com.ibm.icu.text.Collator");
        }
        catch (Exception e) {
            c = Collator.class;
        }
        try {
            Method m = c.getDeclaredMethod("getInstance", Locale.class);
            this.collatorInstance = m.invoke(null, locale);
            this.compareMethod = c.getDeclaredMethod("compare", Object.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize collator: " + e.getMessage(), e);
        }
    }
}

