/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;

public final class DITAOTCopy
extends Task {
    private String includes = null;
    private String relativePaths = null;
    private String destDir = null;
    private DITAOTLogger logger;

    public void setIncludes(String incld) {
        this.includes = incld;
    }

    public void setTodir(String destdir) {
        this.destDir = destdir;
    }

    public void setRelativePaths(String relPaths) {
        this.relativePaths = relPaths;
    }

    public void execute() throws BuildException {
        this.logger = new DITAOTAntLogger(this.getProject());
        FileUtils fileUitls = FileUtils.newFileUtils();
        if (this.includes == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.includes, ",");
        if (this.relativePaths == null) {
            try {
                while (tokenizer.hasMoreTokens()) {
                    File srcFile = new File(tokenizer.nextToken());
                    if (!srcFile.exists()) continue;
                    File destFile = new File(this.destDir, srcFile.getName());
                    fileUitls.copyFile(srcFile, destFile);
                }
            }
            catch (IOException e) {
                this.logger.logError(e.getMessage(), e);
            }
        } else {
            StringTokenizer pathTokenizer = new StringTokenizer(this.relativePaths, ",");
            StringBuffer realDest = null;
            try {
                while (tokenizer.hasMoreTokens()) {
                    File srcFile = new File(tokenizer.nextToken());
                    File destFile = null;
                    pathTokenizer = new StringTokenizer(this.relativePaths, ",");
                    while (pathTokenizer.hasMoreTokens()) {
                        if (this.destDir == null || this.destDir.trim().length() <= 0) continue;
                        realDest = new StringBuffer();
                        realDest.append(this.destDir).append(File.separator).append(pathTokenizer.nextToken());
                        File temp = new File(realDest.toString());
                        if (!temp.getName().equalsIgnoreCase(srcFile.getName())) continue;
                        destFile = temp;
                        break;
                    }
                    if (!srcFile.exists() || destFile == null) continue;
                    fileUitls.copyFile(srcFile, destFile);
                }
            }
            catch (IOException e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }
}

