/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DelayConrefUtils {
    private Document root = null;
    private DITAOTLogger logger;

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public boolean findTopicId(String absolutePathToFile, String id) {
        if (!FileUtils.fileExists(absolutePathToFile)) {
            return false;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                Class.forName("org.apache.xml.resolver.tools.CatalogResolver");
                builder.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
            }
            catch (ClassNotFoundException e) {
                builder.setEntityResolver(null);
            }
            Document root = builder.parse(new InputSource(new FileInputStream(absolutePathToFile)));
            Element doc = root.getDocumentElement();
            LinkedList<Element> queue = new LinkedList<Element>();
            queue.offer(doc);
            while (!queue.isEmpty()) {
                Element pe = (Element)queue.poll();
                NodeList pchildrenList = pe.getChildNodes();
                for (int i = 0; i < pchildrenList.getLength(); ++i) {
                    Node node = pchildrenList.item(i);
                    if (node.getNodeType() != 1) continue;
                    queue.offer((Element)node);
                }
                String classValue = pe.getAttribute("class");
                if (classValue == null || !Constants.TOPIC_TOPIC.matches(classValue) || !pe.getAttribute("id").equals(id)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.logError("Failed to read document: " + e.getMessage(), e);
            return false;
        }
    }

    public List<Boolean> checkExport(String href, String id, String key, File tempDir) {
        boolean keyrefExported;
        boolean idExported;
        block14: {
            File exportFile = new File(tempDir, "export.xml");
            idExported = false;
            keyrefExported = false;
            try {
                Element fileNode;
                if (this.root == null) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    try {
                        Class.forName("org.apache.xml.resolver.tools.CatalogResolver");
                        builder.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
                    }
                    catch (ClassNotFoundException e) {
                        builder.setEntityResolver(null);
                    }
                    this.root = builder.parse(new InputSource(new FileInputStream(exportFile)));
                }
                if (href.endsWith(".xml")) {
                    href = href.replace(".xml", ".dita");
                }
                if ((fileNode = this.searchForKey(this.root.getDocumentElement(), href, "file")) == null) break block14;
                NodeList pList = fileNode.getChildNodes();
                for (int j = 0; j < pList.getLength(); ++j) {
                    Node node = pList.item(j);
                    if (1 == node.getNodeType()) {
                        Element child = (Element)node;
                        if (child.getNodeName().equals("keyref") && child.getAttribute("name").equals(key)) {
                            keyrefExported = true;
                        } else if (child.getNodeName().equals("topicid") && child.getAttribute("name").equals(id)) {
                            idExported = true;
                        } else if (child.getNodeName().equals("id") && child.getAttribute("name").equals(id)) {
                            idExported = true;
                        }
                    }
                    if (!idExported || !keyrefExported) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        list.add(idExported);
        list.add(keyrefExported);
        return list;
    }

    public Element searchForKey(Element root, String key, String tagName) {
        if (root == null || StringUtils.isEmptyString(key)) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Element pe = (Element)queue.poll();
            NodeList pchildrenList = pe.getChildNodes();
            for (int i = 0; i < pchildrenList.getLength(); ++i) {
                Node node = pchildrenList.item(i);
                if (node.getNodeType() != 1) continue;
                queue.offer((Element)node);
            }
            String value = pe.getNodeName();
            if (StringUtils.isEmptyString(value) || !value.equals(tagName) || StringUtils.isEmptyString(value = pe.getAttribute("name")) || !value.equals(key)) continue;
            return pe;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMapToXML(Map<String, Set<String>> m, File outputFile) {
        Transformer t;
        Document doc;
        block20: {
            DocumentBuilder db;
            Properties prop;
            block19: {
                if (m == null) {
                    return;
                }
                prop = new Properties();
                for (Map.Entry<String, Set<String>> entry : m.entrySet()) {
                    String key = entry.getKey();
                    String value = StringUtils.assembleString(entry.getValue(), ",");
                    prop.setProperty(key, value);
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                db = null;
                try {
                    db = dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException pce) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError();
                }
            }
            doc = db.newDocument();
            Element properties = (Element)doc.appendChild(doc.createElement("properties"));
            Set<Object> keys = prop.keySet();
            for (String string : keys) {
                Element entry = (Element)properties.appendChild(doc.createElement("entry"));
                entry.setAttribute("key", string);
                entry.appendChild(doc.createTextNode(prop.getProperty(string)));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            t = null;
            try {
                t = transformerFactory.newTransformer();
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("method", "xml");
                t.setOutputProperty("encoding", "UTF-8");
            }
            catch (TransformerConfigurationException tce) {
                if ($assertionsDisabled) break block20;
                throw new AssertionError();
            }
        }
        DOMSource doms = new DOMSource(doc);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            StreamResult sr = new StreamResult(out);
            t.transform(doms, sr);
        }
        catch (Exception e) {
            this.logger.logError("Failed to process map: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logger.logError("Failed to close output stream: " + e.getMessage());
                }
            }
        }
    }
}

