/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public final class DitaClass {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    public final String matcher;
    public final String localName;
    private final String stringValue;

    public DitaClass(String cls) {
        String[] tokens = WHITESPACE.split(cls);
        String last = tokens[tokens.length - 1];
        this.matcher = ' ' + last + ' ';
        this.localName = last.substring(last.indexOf(47) + 1);
        StringBuilder sb = new StringBuilder();
        for (String s : tokens) {
            sb.append(s).append(' ');
        }
        this.stringValue = sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DitaClass other = (DitaClass)obj;
        return !(this.stringValue == null ? other.stringValue != null : !this.stringValue.equals(other.stringValue));
    }

    public String toString() {
        return this.stringValue;
    }

    public boolean matches(DitaClass cls) {
        return cls != null && cls.toString().indexOf(this.matcher) != -1;
    }

    public boolean matches(String classString) {
        return classString != null && classString.indexOf(this.matcher) != -1;
    }

    public boolean matches(Attributes atts) {
        return this.matches(atts.getValue("class"));
    }

    public boolean matches(Node node) {
        if (node.getNodeType() == 1) {
            return this.matches(((Element)node).getAttribute("class"));
        }
        return false;
    }
}

