/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;

public final class FileUtils {
    private static DITAOTJavaLogger logger = new DITAOTJavaLogger();
    private static final List<String> supportedTopicExtensions;
    private static final List<String> supportedMapExtensions;
    private static final List<String> supportedImageExtensions;
    private static final List<String> supportedHTMLExtensions;
    private static final List<String> supportedResourceExtensions;
    private static final List<String> supportedExtensions;

    private FileUtils() {
    }

    public static boolean isHTMLFile(String lcasefn) {
        for (String ext : supportedHTMLExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHHPFile(String lcasefn) {
        return lcasefn.endsWith(".hhp");
    }

    public static boolean isHHCFile(String lcasefn) {
        return lcasefn.endsWith(".hhc");
    }

    public static boolean isHHKFile(String lcasefn) {
        return lcasefn.endsWith(".hhk");
    }

    public static boolean isResourceFile(String lcasefn) {
        for (String ext : supportedResourceExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDITAFile(String lcasefn) {
        if (lcasefn == null) {
            return false;
        }
        return FileUtils.isDITATopicFile(lcasefn = FileUtils.stripFragment(lcasefn)) || FileUtils.isDITAMapFile(lcasefn);
    }

    public static boolean isDITATopicFile(String lcasefn) {
        for (String ext : supportedTopicExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDITAMapFile(String lcasefn) {
        for (String ext : supportedMapExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupportedImageFile(String lcasefn) {
        for (String ext : supportedImageExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidTarget(String lcasefn) {
        for (String ext : supportedExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static String getRelativePath(String basePath, String refPath) {
        StringBuffer upPathBuffer = new StringBuffer(128);
        StringBuffer downPathBuffer = new StringBuffer(128);
        StringTokenizer mapTokenizer = new StringTokenizer(FileUtils.normalize(FileUtils.separatorsToUnix(basePath), "/"), "/");
        StringTokenizer topicTokenizer = new StringTokenizer(FileUtils.normalize(FileUtils.separatorsToUnix(refPath), "/"), "/");
        while (mapTokenizer.countTokens() > 1 && topicTokenizer.countTokens() > 1) {
            String mapToken = mapTokenizer.nextToken();
            String topicToken = topicTokenizer.nextToken();
            boolean equals = false;
            equals = Constants.OS_NAME.toLowerCase().indexOf("windows") != -1 ? mapToken.equalsIgnoreCase(topicToken) : mapToken.equals(topicToken);
            if (equals) continue;
            if (mapToken.endsWith(":") || topicToken.endsWith(":")) {
                return refPath;
            }
            upPathBuffer.append("..");
            upPathBuffer.append("/");
            downPathBuffer.append(topicToken);
            downPathBuffer.append("/");
            break;
        }
        while (mapTokenizer.countTokens() > 1) {
            mapTokenizer.nextToken();
            upPathBuffer.append("..");
            upPathBuffer.append("/");
        }
        while (topicTokenizer.hasMoreTokens()) {
            downPathBuffer.append(topicTokenizer.nextToken());
            if (!topicTokenizer.hasMoreTokens()) continue;
            downPathBuffer.append("/");
        }
        return upPathBuffer.append(downPathBuffer).toString();
    }

    public static String getRelativePath(String relativePath) {
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        StringBuffer buffer = new StringBuffer();
        if (tokenizer.countTokens() == 1) {
            return null;
        }
        while (tokenizer.countTokens() > 1) {
            tokenizer.nextToken();
            buffer.append("..");
            buffer.append("/");
        }
        return buffer.toString();
    }

    public static String resolveTopic(String rootPath, String relativePath) {
        String begin = relativePath;
        String end = "";
        if (relativePath.indexOf("#") != -1) {
            begin = relativePath.substring(0, relativePath.indexOf(35));
            end = relativePath.substring(relativePath.indexOf(35));
        }
        return FileUtils.normalizeDirectory(rootPath, begin) + end;
    }

    public static String resolveFile(String rootPath, String relativePath) {
        String begin = FileUtils.stripFragment(relativePath);
        return FileUtils.normalizeDirectory(rootPath, begin);
    }

    public static String normalizeDirectory(String basedir, String filepath) {
        String pathname = FileUtils.stripFragment(filepath);
        String normilizedPath = new File(basedir, pathname).getPath();
        if (basedir == null || basedir.length() == 0) {
            return normilizedPath;
        }
        return FileUtils.normalize(normilizedPath);
    }

    public static String normalize(String path) {
        return FileUtils.normalize(path, File.separator);
    }

    public static String normalize(String path, String separator) {
        LinkedList<String> dirs = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, separator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (".".equals(token)) continue;
            dirs.add(token);
        }
        int dirNum = dirs.size();
        int i = 0;
        while (i < dirNum) {
            if (i > 0) {
                String lastDir = (String)dirs.get(i - 1);
                String dir = (String)dirs.get(i);
                if ("..".equals(dir) && !"..".equals(lastDir)) {
                    dirs.remove(i);
                    dirs.remove(i - 1);
                    dirNum = dirs.size();
                    --i;
                    continue;
                }
            }
            ++i;
        }
        StringBuffer buff = new StringBuffer(path.length());
        if (path.startsWith(separator + separator)) {
            buff.append(separator).append(separator);
        } else if (path.startsWith(separator)) {
            buff.append(separator);
        }
        Iterator iter = dirs.iterator();
        while (iter.hasNext()) {
            buff.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buff.append(separator);
        }
        if (path.endsWith(separator)) {
            buff.append(separator);
        }
        return buff.toString();
    }

    public static String separatorsToUnix(String path) {
        return path.replace("\\", "/");
    }

    public static boolean isAbsolutePath(String path) {
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        if (File.separator.equals("/")) {
            return path.startsWith("/");
        }
        if (File.separator.equals("\\") && path.length() > 2) {
            return path.matches("([a-zA-Z]:|\\\\)\\\\.*");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File target) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(target);
            FileUtils.copy(fis, fos);
        }
        catch (IOException ex) {
            logger.logError(ex.getMessage(), ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.logError(e.getMessage(), e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    public static void copy(InputStream fis, OutputStream fos) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, len);
        }
        fos.flush();
    }

    public static String replaceExtension(String attValue, String extName) {
        int index = attValue.indexOf("#");
        if (attValue.startsWith("#")) {
            return attValue;
        }
        if (index != -1) {
            String fileName = attValue.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(0, fileExtIndex) + extName + attValue.substring(index) : attValue;
        }
        int fileExtIndex = attValue.lastIndexOf(".");
        return fileExtIndex != -1 ? attValue.substring(0, fileExtIndex) + extName : attValue;
    }

    public static String getExtension(String file) {
        int index = file.indexOf("#");
        if (file.startsWith("#")) {
            return null;
        }
        if (index != -1) {
            String fileName = file.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(fileExtIndex + 1, fileName.length()) : null;
        }
        int fileExtIndex = file.lastIndexOf(".");
        return fileExtIndex != -1 ? file.substring(fileExtIndex + 1, file.length()) : null;
    }

    public static boolean fileExists(String filename) {
        String string = filename = filename.indexOf("#") != -1 ? filename.substring(0, filename.indexOf("#")) : filename;
        return new File(filename).exists();
    }

    public static String getName(String aURLString) {
        int pathnameEndIndex;
        if (FileUtils.isWindows()) {
            if (aURLString.contains("#")) {
                pathnameEndIndex = aURLString.lastIndexOf("#");
            } else {
                pathnameEndIndex = aURLString.lastIndexOf("\\");
                if (pathnameEndIndex == -1) {
                    pathnameEndIndex = aURLString.lastIndexOf("/");
                }
            }
        } else {
            if (aURLString.contains("#")) {
                pathnameEndIndex = aURLString.lastIndexOf("#");
            }
            pathnameEndIndex = aURLString.lastIndexOf("/");
        }
        String schemaLocation = null;
        schemaLocation = aURLString.contains("#") ? aURLString.substring(0, pathnameEndIndex) : aURLString.substring(pathnameEndIndex + 1);
        return schemaLocation;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Win");
    }

    public static String getFullPathNoEndSeparator(String aURLString) {
        int pathnameStartIndex = aURLString.indexOf("/");
        int pathnameEndIndex = aURLString.lastIndexOf("/");
        String aPath = aURLString.substring(pathnameStartIndex, pathnameEndIndex);
        aPath = aURLString.substring(0, pathnameEndIndex);
        return aPath;
    }

    public static String stripFragment(String path) {
        int i = path.indexOf("#");
        if (i != -1) {
            return path.substring(0, i);
        }
        return path;
    }

    public static String getFragment(String path) {
        int i = path.indexOf("#");
        if (i != -1) {
            return path.substring(i + 1);
        }
        return null;
    }

    static {
        ArrayList<String> ste = new ArrayList<String>();
        String extensions = Configuration.configuration.get("supported_topic_extensions");
        if (extensions != null && extensions.length() > 0) {
            for (String ext : extensions.split(";")) {
                ste.add(ext);
            }
        } else {
            logger.logError("Failed to read supported DITA topic extensions from configuration, using defaults.");
            ste.add(".dita");
            ste.add(".xml");
        }
        supportedTopicExtensions = Collections.unmodifiableList(ste);
        ArrayList<String> sme = new ArrayList<String>();
        extensions = Configuration.configuration.get("supported_map_extensions");
        if (extensions != null && extensions.length() > 0) {
            for (String ext : extensions.split(";")) {
                sme.add(ext);
            }
        } else {
            logger.logError("Failed to read supported DITA map extensions from configuration, using defaults.");
            sme.add(".ditamap");
        }
        supportedMapExtensions = Collections.unmodifiableList(sme);
        ArrayList<String> sie = new ArrayList<String>();
        String imageExtensions = Configuration.configuration.get("supported_image_extensions");
        if (imageExtensions != null && imageExtensions.length() > 0) {
            for (String ext : imageExtensions.split(";")) {
                sie.add(ext);
            }
        } else {
            logger.logError("Failed to read supported image extensions from configuration, using defaults.");
            sie.add(".jpg");
            sie.add(".gif");
            sie.add(".eps");
            sie.add(".jpeg");
            sie.add(".png");
            sie.add(".svg");
            sie.add(".tiff");
            sie.add(".tif");
        }
        supportedImageExtensions = Collections.unmodifiableList(sie);
        ArrayList<String> she = new ArrayList<String>();
        extensions = Configuration.configuration.get("supported_html_extensions");
        if (extensions != null && extensions.length() > 0) {
            for (String ext : extensions.split(";")) {
                she.add(ext);
            }
        } else {
            logger.logError("Failed to read supported HTML extensions from configuration, using defaults.");
            she.add(".html");
            she.add(".htm");
        }
        supportedHTMLExtensions = Collections.unmodifiableList(she);
        ArrayList<String> sre = new ArrayList<String>();
        extensions = Configuration.configuration.get("supported_resource_extensions");
        if (extensions != null && extensions.length() > 0) {
            for (String ext : extensions.split(";")) {
                sre.add(ext);
            }
        } else {
            logger.logError("Failed to read supported resource file extensions from configuration, using defaults.");
            sre.add(".swf");
            sre.add(".pdf");
        }
        supportedResourceExtensions = Collections.unmodifiableList(sre);
        ArrayList<String> se = new ArrayList<String>();
        se.addAll(supportedTopicExtensions);
        se.addAll(supportedMapExtensions);
        se.addAll(supportedImageExtensions);
        se.addAll(supportedHTMLExtensions);
        se.addAll(supportedResourceExtensions);
        supportedExtensions = Collections.unmodifiableList(se);
    }
}

