/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.xml.sax.Attributes;

public final class FilterUtils {
    public static final FilterKey DEFAULT = new FilterKey("default", null);
    private DITAOTLogger logger;
    private Map<FilterKey, Action> filterMap = null;
    private final Set<FilterKey> notMappingRules = new HashSet<FilterKey>();

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void setFilterMap(Map<FilterKey, Action> filtermap) {
        this.filterMap = filtermap;
    }

    public Map<FilterKey, Action> getFilterMap() {
        return this.filterMap;
    }

    public boolean needExclude(Attributes atts, String[][] extProps) {
        if (this.filterMap == null) {
            return false;
        }
        boolean ret = false;
        boolean extRet = false;
        if (this.filterMap == null) {
            return false;
        }
        boolean bl = ret = this.checkExclude("audience", atts.getValue("audience")) || this.checkExclude("platform", atts.getValue("platform")) || this.checkExclude("product", atts.getValue("product")) || this.checkExclude("otherprops", atts.getValue("otherprops")) || this.checkExclude("props", atts.getValue("props"));
        if (extProps == null) {
            return ret;
        }
        for (String[] propList : extProps) {
            int propListIndex = propList.length - 1;
            String propName = propList[propListIndex];
            String propValue = atts.getValue(propName);
            while (propValue == null && propListIndex > 0) {
                String attrPropsValue;
                if ((attrPropsValue = atts.getValue(propList[--propListIndex])) == null) continue;
                int propStart = -1;
                if (attrPropsValue.startsWith(propName + "(") || attrPropsValue.indexOf(" " + propName + "(", 0) != -1) {
                    propStart = attrPropsValue.indexOf(propName + "(");
                }
                if (propStart != -1) {
                    propStart = propStart + propName.length() + 1;
                }
                int propEnd = attrPropsValue.indexOf(")", propStart);
                if (propStart == -1 || propEnd == -1) continue;
                propValue = attrPropsValue.substring(propStart, propEnd).trim();
            }
            extRet = extRet || this.extCheckExclude(propList, propValue);
        }
        return ret || extRet;
    }

    private boolean extCheckExclude(String[] propList, String attValue) {
        if (attValue == null || attValue.trim().length() == 0 || propList.length == 0 || attValue.indexOf("(") != -1) {
            return false;
        }
        int propListIndex = 0;
        boolean hasNullAction = false;
        boolean hasExcludeAction = false;
        this.checkRuleMapping(propList[propListIndex], attValue);
        for (propListIndex = propList.length - 1; propListIndex >= 0; --propListIndex) {
            hasNullAction = false;
            hasExcludeAction = false;
            StringTokenizer tokenizer = new StringTokenizer(attValue, " ");
            String attName = propList[propListIndex];
            while (tokenizer.hasMoreTokens()) {
                String attSubValue = tokenizer.nextToken();
                FilterKey filterKey = new FilterKey(attName, attSubValue);
                Action filterAction = this.filterMap.get(filterKey);
                if (filterAction == null) {
                    Action attDefaultAction = this.filterMap.get(new FilterKey(attName, null));
                    if (attDefaultAction != null) {
                        if (Action.EXCLUDE != attDefaultAction) {
                            return false;
                        }
                        hasExcludeAction = true;
                        if (!hasNullAction) continue;
                        if (this.checkExcludeOfGlobalDefaultAction()) {
                            hasNullAction = false;
                            continue;
                        }
                        return false;
                    }
                    if (hasExcludeAction) {
                        if (this.checkExcludeOfGlobalDefaultAction()) continue;
                        return false;
                    }
                    hasNullAction = true;
                    continue;
                }
                if (Action.EXCLUDE == filterAction) {
                    hasExcludeAction = true;
                    if (!hasNullAction) continue;
                    if (this.checkExcludeOfGlobalDefaultAction()) {
                        hasNullAction = false;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            if (hasNullAction) {
                if (0 != propListIndex) continue;
                return this.checkExcludeOfGlobalDefaultAction();
            }
            if (!hasExcludeAction) continue;
            return true;
        }
        return false;
    }

    private boolean checkExclude(String attName, String attValue) {
        if (attValue == null || attValue.trim().length() == 0) {
            return false;
        }
        this.checkRuleMapping(attName, attValue);
        StringTokenizer tokenizer = new StringTokenizer(attValue, " ");
        while (tokenizer.hasMoreTokens()) {
            String attSubValue = tokenizer.nextToken();
            FilterKey filterKey = new FilterKey(attName, attSubValue);
            Action filterAction = this.filterMap.get(filterKey);
            if (filterAction == null) {
                Action attDefaultAction = this.filterMap.get(new FilterKey(attName, null));
                if (attDefaultAction != null) {
                    filterAction = attDefaultAction;
                    if (Action.EXCLUDE == attDefaultAction) continue;
                    return false;
                }
                if (this.checkExcludeOfGlobalDefaultAction()) continue;
                return false;
            }
            if (Action.EXCLUDE == filterAction) continue;
            return false;
        }
        return true;
    }

    private boolean checkExcludeOfGlobalDefaultAction() {
        Action defaultAction = this.filterMap.get(DEFAULT);
        if (defaultAction == null) {
            return false;
        }
        return Action.EXCLUDE == defaultAction;
    }

    private void checkRuleMapping(String attName, String attValue) {
        if (attValue == null || attValue.trim().length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(attValue, " ");
        while (tokenizer.hasMoreTokens()) {
            String attSubValue = tokenizer.nextToken();
            FilterKey filterKey = new FilterKey(attName, attSubValue);
            Action filterAction = this.filterMap.get(filterKey);
            if (filterAction != null) continue;
            this.noRuleMapping(filterKey);
        }
    }

    private void noRuleMapping(FilterKey notMappingKey) {
        if (!this.alreadyShowed(notMappingKey)) {
            this.showInfoOfNoRuleMapping(notMappingKey);
        }
    }

    private void showInfoOfNoRuleMapping(FilterKey notMappingKey) {
        this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ031I", notMappingKey.toString()).toString());
    }

    private boolean alreadyShowed(FilterKey notMappingKey) {
        if (!this.notMappingRules.contains(notMappingKey)) {
            this.notMappingRules.add(notMappingKey);
            return false;
        }
        return true;
    }

    public static class FilterKey {
        public final String attribute;
        public final String value;

        public FilterKey(String attribute, String value) {
            if (attribute == null) {
                throw new IllegalArgumentException("Attribute may not be null");
            }
            this.attribute = attribute;
            this.value = value;
        }

        public String toString() {
            return this.value != null ? this.attribute + "=" + this.value : this.attribute;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FilterKey)) {
                RuntimeException t = new RuntimeException("Not comparing FilterKey");
                t.printStackTrace();
                return false;
            }
            FilterKey other = (FilterKey)obj;
            if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static enum Action {
        INCLUDE,
        EXCLUDE,
        PASSTHROUGH,
        FLAG;

    }
}

