/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.ListUtils;
import org.dita.dost.util.OutputUtils;

public final class ImgUtils {
    private ImgUtils() {
    }

    private static String getImageOutPutPath(String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        String uplevelPath = null;
        File outDir = OutputUtils.getOutputDir();
        String filename = FileUtils.separatorsToUnix(fileName);
        File imgoutDir = outDir;
        if (OutputUtils.getGeneratecopyouter() != OutputUtils.Generate.OLDSOLUTION) {
            Properties propterties = null;
            try {
                propterties = ListUtils.getDitaList();
                uplevelPath = propterties.getProperty("uplevels");
                if (uplevelPath != null && uplevelPath.length() > 0) {
                    imgoutDir = new File(outDir, uplevelPath);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Reading list file failed: " + e.getMessage(), e);
            }
        }
        String imagePath = null;
        try {
            imagePath = new File(imgoutDir, filename).getCanonicalPath();
        }
        catch (IOException e) {
            logger.logError(e.getMessage(), e);
        }
        return imagePath;
    }

    private static boolean checkDirName(String dirName) {
        File outDir = OutputUtils.getOutputDir();
        if (outDir != null) {
            String o = FileUtils.separatorsToUnix(outDir.getAbsolutePath());
            if (FileUtils.separatorsToUnix(new File(dirName).getPath()).equalsIgnoreCase(o)) {
                return true;
            }
        }
        return false;
    }

    public static int getWidth(String dirName, String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        File imgInput = new File(dirName + File.separatorChar + fileName);
        if (ImgUtils.checkDirName(dirName)) {
            imgInput = new File(ImgUtils.getImageOutPutPath(fileName));
        }
        try {
            BufferedImage img = ImageIO.read(imgInput);
            return img.getWidth();
        }
        catch (Exception e) {
            logger.logError(MessageUtils.getInstance().getMessage("DOTJ023E", dirName + File.separatorChar + fileName).toString(), e);
            return -1;
        }
    }

    public static int getHeight(String dirName, String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        File imgInput = new File(dirName + File.separatorChar + fileName);
        if (ImgUtils.checkDirName(dirName)) {
            imgInput = new File(ImgUtils.getImageOutPutPath(fileName));
        }
        try {
            BufferedImage img = ImageIO.read(imgInput);
            return img.getHeight();
        }
        catch (Exception e) {
            logger.logError(MessageUtils.getInstance().getMessage("DOTJ023E", dirName + File.separatorChar + fileName).toString(), e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBinData(String dirName, String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        File imgInput = new File(dirName + File.separatorChar + fileName);
        if (ImgUtils.checkDirName(dirName)) {
            imgInput = new File(ImgUtils.getImageOutPutPath(fileName));
        }
        FileInputStream binInput = null;
        try {
            String binStr = null;
            StringBuffer ret = new StringBuffer(16384);
            binInput = new FileInputStream(imgInput);
            int bin = binInput.read();
            while (bin != -1) {
                binStr = Integer.toHexString(bin);
                if (binStr.length() < 2) {
                    ret.append("0");
                }
                ret.append(binStr);
                bin = binInput.read();
            }
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            logger.logError(MessageUtils.getInstance().getMessage("DOTJ023E", new String[0]).toString());
            logger.logError(e.getMessage(), e);
            String string = null;
            return string;
        }
        finally {
            try {
                binInput.close();
            }
            catch (IOException ioe) {
                logger.logError(ioe.getMessage(), ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBASE64(String dirName, String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        File imgInput = new File(dirName + File.separatorChar + fileName);
        if (ImgUtils.checkDirName(dirName)) {
            imgInput = new File(ImgUtils.getImageOutPutPath(fileName));
        }
        Base64 encoder = new Base64();
        byte[] buff = new byte[(int)imgInput.length()];
        FileInputStream file = null;
        try {
            String ret;
            file = new FileInputStream(imgInput);
            file.read(buff);
            String string = ret = encoder.encodeToString(buff);
            return string;
        }
        catch (FileNotFoundException e) {
            logger.logError(MessageUtils.getInstance().getMessage("DOTJ023E", new String[0]).toString());
            logger.logError(e.getMessage(), e);
            String string = null;
            return string;
        }
        catch (IOException e) {
            logger.logError(MessageUtils.getInstance().getMessage("DOTJ023E", new String[0]).toString());
            logger.logError(e.getMessage(), e);
            String string = null;
            return string;
        }
        finally {
            try {
                file.close();
            }
            catch (IOException ioe) {
                logger.logError(ioe.getMessage(), ioe);
            }
        }
    }
}

