/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class Job {
    private static final String JOB_FILE = ".job.xml";
    private static final String ELEMENT_JOB = "job";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ELEMENT_MAP = "map";
    private static final String ELEMENT_SET = "set";
    private static final String ELEMENT_STRING = "string";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_FILES = "files";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_FORMAT = "format";
    private static final String ATTRIBUTE_CHUNKED = "chunked";
    private static final String ATTRIBUTE_HAS_CONREF = "has-conref";
    private static final String ATTRIBUTE_HAS_KEYREF = "has-keyref";
    private static final String ATTRIBUTE_HAS_CODEREF = "has-coderef";
    private static final String ATTRIBUTE_RESOURCE_ONLY = "resource-only";
    private static final String ATTRIBUTE_TARGET = "target";
    private static final String ATTRIBUTE_CONREF_TARGET = "conref-target";
    private static final String ATTRIBUTE_NON_CONREF_TARGET = "non-conref-target";
    private static final String ATTRIBUTE_CONREF_PUSH = "conrefpush";
    private static final String ATTRIBUTE_SUBJECT_SCHEME = "subjectscheme";
    private static final String ATTRIBUTE_HAS_LINK = "has-link";
    private static final String ATTRIBUTE_COPYTO_SOURCE_LIST = "copy-to-source";
    private static final String ATTRIBUTE_OUT_DITA_FILES_LIST = "out-dita";
    private static final String ATTRIBUTE_CHUNKED_DITAMAP_LIST = "chunked-ditamap";
    private static final String ATTRIBUTE_FLAG_IMAGE_LIST = "flag-image";
    private static final String ATTRIBUTE_SUBSIDIARY_TARGET_LIST = "subtarget";
    private static final String ATTRIBUTE_CHUNK_TOPIC_LIST = "skip-chunk";
    private static final String ATTRIBUTE_ACTIVE = "active";
    public static final String CHUNKED_DITAMAP_LIST_FILE = "chunkedditamap.list";
    public static final String CHUNKED_TOPIC_LIST_FILE = "chunkedtopic.list";
    public static final String CHUNK_TOPIC_LIST_FILE = "skipchunk.list";
    public static final String CODEREF_LIST_FILE = "coderef.list";
    public static final String CONREF_LIST_FILE = "conref.list";
    public static final String CONREF_PUSH_LIST_FILE = "conrefpush.list";
    public static final String CONREF_TARGET_LIST_FILE = "conreftargets.list";
    public static final String COPYTO_SOURCE_LIST_FILE = "copytosource.list";
    public static final String COPYTO_TARGET_TO_SOURCE_MAP_LIST_FILE = "copytotarget2sourcemap.list";
    public static final String FLAG_IMAGE_LIST_FILE = "flagimage.list";
    public static final String FULL_DITAMAP_LIST_FILE = "fullditamap.list";
    public static final String FULL_DITAMAP_TOPIC_LIST_FILE = "fullditamapandtopic.list";
    public static final String FULL_DITA_TOPIC_LIST_FILE = "fullditatopic.list";
    public static final String HREF_DITA_TOPIC_LIST_FILE = "hrefditatopic.list";
    public static final String HREF_TARGET_LIST_FILE = "hreftargets.list";
    public static final String HREF_TOPIC_LIST_FILE = "canditopics.list";
    public static final String HTML_LIST_FILE = "html.list";
    public static final String IMAGE_LIST_FILE = "image.list";
    public static final String INPUT_DITAMAP_LIST_FILE = "user.input.file.list";
    public static final String KEYDEF_LIST_FILE = "keydef.xml";
    public static final String SUBJECT_SCHEME_KEYDEF_LIST_FILE = "schemekeydef.xml";
    public static final String KEYREF_LIST_FILE = "keyref.list";
    public static final String KEY_LIST_FILE = "key.list";
    public static final String OUT_DITA_FILES_LIST_FILE = "outditafiles.list";
    public static final String REL_FLAGIMAGE_LIST_FILE = "relflagimage.list";
    public static final String RESOURCE_ONLY_LIST_FILE = "resourceonly.list";
    public static final String SUBJEC_SCHEME_LIST_FILE = "subjectscheme.list";
    public static final String SUBSIDIARY_TARGET_LIST_FILE = "subtargets.list";
    public static final String USER_INPUT_FILE_LIST_FILE = "usr.input.file.list";
    private static final Map<String, Field> listToFieldMap = new HashMap<String, Field>();
    private static final Map<String, Field> attrToFieldMap = new HashMap<String, Field>();
    private final Map<String, Object> prop;
    private final File tempDir;
    private final Map<String, FileInfo> files = new HashMap<String, FileInfo>();

    public Job(File tempDir) throws IOException {
        this.tempDir = tempDir;
        this.prop = new HashMap<String, Object>();
        this.read();
    }

    private void read() throws IOException {
        File jobFile = new File(this.tempDir, JOB_FILE);
        if (jobFile.exists()) {
            InputStream in = null;
            try {
                XMLReader parser = StringUtils.getXMLReader();
                parser.setContentHandler(new JobHandler(this.prop, this.files));
                in = new FileInputStream(jobFile);
                parser.parse(new InputSource(in));
            }
            catch (SAXException e) {
                throw new IOException("Failed to read job file: " + e.getMessage());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return;
        }
        Properties p = new Properties();
        File ditalist = new File(this.tempDir, "dita.list");
        File xmlDitalist = new File(this.tempDir, "dita.xml.properties");
        InputStream in = null;
        try {
            if (xmlDitalist.exists()) {
                in = new FileInputStream(xmlDitalist);
                p.loadFromXML(in);
            } else if (ditalist.exists()) {
                in = new FileInputStream(ditalist);
                p.load(in);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to read file: " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new IOException("Failed to close file: " + e.getMessage());
                }
            }
        }
        this.readProperties(p);
    }

    private void readProperties(Properties p) {
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            if (((String)e.getValue()).length() <= 0) continue;
            String key = e.getKey().toString();
            if (key.equals("copytotarget2sourcemaplist")) {
                this.setMap(e.getKey().toString(), StringUtils.restoreMap(e.getValue().toString()));
                continue;
            }
            if (key.endsWith("list")) {
                this.setSet(e.getKey().toString(), StringUtils.restoreSet(e.getValue().toString()));
                continue;
            }
            this.setProperty(e.getKey().toString(), e.getValue().toString());
        }
    }

    public void write() throws IOException {
        OutputStream outStream = null;
        XMLStreamWriter out = null;
        try {
            outStream = new FileOutputStream(new File(this.tempDir, JOB_FILE));
            out = XMLOutputFactory.newInstance().createXMLStreamWriter(outStream, "UTF-8");
            out.writeStartDocument();
            out.writeStartElement(ELEMENT_JOB);
            for (Map.Entry<String, Object> e : this.prop.entrySet()) {
                Object s;
                out.writeStartElement(ELEMENT_PROPERTY);
                out.writeAttribute(ATTRIBUTE_NAME, e.getKey());
                if (e.getValue() instanceof String) {
                    out.writeStartElement(ELEMENT_STRING);
                    out.writeCharacters(e.getValue().toString());
                    out.writeEndElement();
                } else if (e.getValue() instanceof Set) {
                    out.writeStartElement(ELEMENT_SET);
                    s = (Set)e.getValue();
                    Iterator<Object> i$ = s.iterator();
                    while (i$.hasNext()) {
                        Object e2 = i$.next();
                        out.writeStartElement(ELEMENT_STRING);
                        out.writeCharacters(e2.toString());
                        out.writeEndElement();
                    }
                    out.writeEndElement();
                } else if (e.getValue() instanceof Map) {
                    out.writeStartElement(ELEMENT_MAP);
                    s = (Map)e.getValue();
                    for (Map.Entry entry : s.entrySet()) {
                        out.writeStartElement(ELEMENT_ENTRY);
                        out.writeAttribute(ATTRIBUTE_KEY, entry.getKey().toString());
                        out.writeStartElement(ELEMENT_STRING);
                        out.writeCharacters(entry.getValue().toString());
                        out.writeEndElement();
                        out.writeEndElement();
                    }
                    out.writeEndElement();
                } else {
                    out.writeStartElement(e.getValue().getClass().getName());
                    out.writeCharacters(e.getValue().toString());
                    out.writeEndElement();
                }
                out.writeEndElement();
            }
            out.writeStartElement(ELEMENT_FILES);
            for (FileInfo i : this.files.values()) {
                out.writeStartElement(ELEMENT_FILE);
                out.writeAttribute(ATTRIBUTE_PATH, i.file);
                if (i.format != null) {
                    out.writeAttribute(ATTRIBUTE_FORMAT, i.format);
                }
                try {
                    for (Map.Entry<String, Field> e : attrToFieldMap.entrySet()) {
                        out.writeAttribute(e.getKey(), Boolean.toString(e.getValue().getBoolean(i)));
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                out.writeEndElement();
            }
            out.writeEndElement();
            out.writeEndElement();
            out.writeEndDocument();
        }
        catch (IOException e) {
            throw new IOException("Failed to write file: " + e.getMessage());
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to serialize job file: " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (XMLStreamException e) {
                    throw new IOException("Failed to close file: " + e.getMessage());
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    throw new IOException("Failed to close file: " + e.getMessage());
                }
            }
        }
        Properties p = new Properties();
        for (Map.Entry<String, Object> e : this.prop.entrySet()) {
            if (e.getValue() instanceof Set) {
                p.put(e.getKey(), StringUtils.assembleString((Collection)e.getValue(), ","));
                continue;
            }
            if (e.getValue() instanceof Map) {
                p.put(e.getKey(), StringUtils.assembleString((Map)e.getValue(), ","));
                continue;
            }
            p.put(e.getKey(), e.getValue());
        }
        FileOutputStream propertiesOutputStream = null;
        try {
            propertiesOutputStream = new FileOutputStream(new File(this.tempDir, "dita.list"));
            p.store(propertiesOutputStream, null);
            propertiesOutputStream.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed to write file: " + e.getMessage());
        }
        finally {
            if (propertiesOutputStream != null) {
                try {
                    propertiesOutputStream.close();
                }
                catch (IOException e) {
                    throw new IOException("Failed to close file: " + e.getMessage());
                }
            }
        }
        FileOutputStream xmlOutputStream = null;
        try {
            xmlOutputStream = new FileOutputStream(new File(this.tempDir, "dita.xml.properties"));
            p.storeToXML(xmlOutputStream, null);
            xmlOutputStream.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed to write file: " + e.getMessage());
        }
        finally {
            if (xmlOutputStream != null) {
                try {
                    xmlOutputStream.close();
                }
                catch (IOException e) {
                    throw new IOException("Failed to close file: " + e.getMessage());
                }
            }
        }
    }

    public String getProperty(String key) {
        Object value = this.prop.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Set) {
            return StringUtils.assembleString((Collection)value, ",");
        }
        if (value instanceof Map) {
            return StringUtils.assembleString((Map)value, ",");
        }
        return (String)value;
    }

    public Map<String, String> getMap(String key) {
        Object value = this.prop.get(key);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof String) {
            return StringUtils.restoreMap((String)value);
        }
        return (Map)value;
    }

    public Set<String> getSet(String key) {
        if (key.equals("fullditamapandtopiclist")) {
            HashSet<String> ret = new HashSet<String>();
            ret.addAll(this.getSet("fullditatopiclist"));
            ret.addAll(this.getSet("fullditamaplist"));
            return ret;
        }
        if (key.equals("fullditatopiclist")) {
            HashSet<String> ret = new HashSet<String>();
            for (FileInfo f : this.files.values()) {
                if (!f.isActive || !"dita".equals(f.format)) continue;
                ret.add(f.file);
            }
            return ret;
        }
        if (key.equals("fullditamaplist")) {
            HashSet<String> ret = new HashSet<String>();
            for (FileInfo f : this.files.values()) {
                if (!f.isActive || !"ditamap".equals(f.format)) continue;
                ret.add(f.file);
            }
            return ret;
        }
        if (key.equals("htmllist")) {
            return this.getFilesByFormat("html");
        }
        if (key.equals("imagelist")) {
            return this.getFilesByFormat("image");
        }
        if (listToFieldMap.containsKey(key)) {
            HashSet<String> ret = new HashSet<String>();
            try {
                Field field = listToFieldMap.get(key);
                for (FileInfo f : this.files.values()) {
                    if (!field.getBoolean(f)) continue;
                    ret.add(f.file);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return ret;
        }
        Object value = this.prop.get(key);
        if (value == null) {
            return Collections.emptySet();
        }
        if (value instanceof String) {
            return StringUtils.restoreSet((String)value);
        }
        return (Set)value;
    }

    private Set<String> getFilesByFormat(String ... formats) {
        HashSet<String> ret = new HashSet<String>();
        block0: for (FileInfo f : this.files.values()) {
            for (String format : formats) {
                if (!format.equals(f.format)) continue;
                ret.add(f.file);
                continue block0;
            }
        }
        return ret;
    }

    public Object setProperty(String key, String value) {
        return this.prop.put(key, value);
    }

    public Set<String> setSet(String key, Set<String> value) {
        Set<String> previous = null;
        if (!key.equals("fullditamapandtopiclist")) {
            if (key.equals("fullditatopiclist")) {
                for (FileInfo fileInfo : this.files.values()) {
                    if (!"dita".equals(fileInfo.format)) continue;
                    fileInfo.isActive = false;
                }
                for (String string : value) {
                    FileInfo ff = this.getOrAdd(string);
                    ff.format = "dita";
                    ff.isActive = true;
                }
            } else if (key.equals("fullditamaplist")) {
                for (FileInfo fileInfo : this.files.values()) {
                    if (!"ditamap".equals(fileInfo.format)) continue;
                    fileInfo.isActive = false;
                }
                for (String string : value) {
                    FileInfo ff = this.getOrAdd(string);
                    ff.format = "ditamap";
                    ff.isActive = true;
                }
            } else if (key.equals("htmllist")) {
                for (String string : value) {
                    this.getOrAdd((String)string).format = "html";
                }
            } else if (key.equals("imagelist")) {
                for (String string : value) {
                    this.getOrAdd((String)string).format = "image";
                }
            } else if (listToFieldMap.containsKey(key)) {
                try {
                    Field field = listToFieldMap.get(key);
                    for (String f : value) {
                        field.setBoolean(this.getOrAdd(f), true);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            } else {
                previous = this.prop.put(key, value);
                if (previous == null) {
                    return null;
                }
                if (previous instanceof String) {
                    return StringUtils.restoreSet((String)((Object)previous));
                }
                return previous;
            }
        }
        return previous;
    }

    private FileInfo getOrAdd(String f) {
        FileInfo i = this.files.get(f);
        if (i == null) {
            i = new FileInfo(f);
            this.files.put(f, i);
        }
        return i;
    }

    public Map<String, String> setMap(String key, Map<String, String> value) {
        Map<String, String> previous = this.prop.put(key, value);
        if (previous == null) {
            return null;
        }
        if (previous instanceof String) {
            return StringUtils.restoreMap((String)((Object)previous));
        }
        return previous;
    }

    public Map<String, String> getCopytoMap() {
        return this.getMap("copytotarget2sourcemaplist");
    }

    public Set<String> getSchemeSet() {
        return this.getSet("subjectschemelist");
    }

    public String getInputMap() {
        return this.getProperty("user.input.file");
    }

    public String getInputDir() {
        return this.getProperty("user.input.dir");
    }

    public Map<String, FileInfo> getFileInfo() {
        return Collections.unmodifiableMap(this.files);
    }

    public void addAll(Collection<FileInfo> fs) {
        for (FileInfo f : fs) {
            this.files.put(f.file, f);
        }
    }

    @Deprecated
    public void writeList(String prop) throws IOException {
        String filename = prop.equals("user.input.file") ? INPUT_DITAMAP_LIST_FILE : prop.substring(0, prop.lastIndexOf("list")) + ".list";
        this.writeList(prop, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void writeList(String prop, String filename) throws IOException {
        File listFile = new File(this.tempDir, filename);
        BufferedWriter topicWriter = null;
        try {
            topicWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(listFile)));
            Set<String> topics = this.getSet(prop);
            Iterator<String> i = topics.iterator();
            while (i.hasNext()) {
                topicWriter.write(i.next());
                if (!i.hasNext()) continue;
                topicWriter.write("\n");
            }
            topicWriter.flush();
        }
        finally {
            if (topicWriter != null) {
                topicWriter.close();
            }
        }
    }

    static {
        try {
            listToFieldMap.put("chunkedtopiclist", FileInfo.class.getField("isChunked"));
            listToFieldMap.put("conreflist", FileInfo.class.getField("hasConref"));
            listToFieldMap.put("hrefditatopiclist", FileInfo.class.getField("hasLink"));
            listToFieldMap.put("keyreflist", FileInfo.class.getField("hasKeyref"));
            listToFieldMap.put("codereflist", FileInfo.class.getField("hasCoderef"));
            listToFieldMap.put("resourceonlylist", FileInfo.class.getField("isResourceOnly"));
            listToFieldMap.put("hreftargetslist", FileInfo.class.getField("isTarget"));
            listToFieldMap.put("conreftargetslist", FileInfo.class.getField("isConrefTarget"));
            listToFieldMap.put("canditopicslist", FileInfo.class.getField("isNonConrefTarget"));
            listToFieldMap.put("conrefpushlist", FileInfo.class.getField("isConrefPush"));
            listToFieldMap.put("subjectschemelist", FileInfo.class.getField("isSubjectScheme"));
            listToFieldMap.put("copytosourcelist", FileInfo.class.getField("isCopyToSource"));
            listToFieldMap.put("outditafileslist", FileInfo.class.getField("isOutDita"));
            listToFieldMap.put("chunkedditamaplist", FileInfo.class.getField("isChunkedDitaMap"));
            listToFieldMap.put("flagimagelist", FileInfo.class.getField("isFlagImage"));
            listToFieldMap.put("subtargetslist", FileInfo.class.getField("isSubtarget"));
            listToFieldMap.put("skipchunklist", FileInfo.class.getField("isSkipChunk"));
            attrToFieldMap.put(ATTRIBUTE_CHUNKED, FileInfo.class.getField("isChunked"));
            attrToFieldMap.put(ATTRIBUTE_HAS_LINK, FileInfo.class.getField("hasLink"));
            attrToFieldMap.put(ATTRIBUTE_HAS_CONREF, FileInfo.class.getField("hasConref"));
            attrToFieldMap.put(ATTRIBUTE_HAS_KEYREF, FileInfo.class.getField("hasKeyref"));
            attrToFieldMap.put(ATTRIBUTE_HAS_CODEREF, FileInfo.class.getField("hasCoderef"));
            attrToFieldMap.put(ATTRIBUTE_RESOURCE_ONLY, FileInfo.class.getField("isResourceOnly"));
            attrToFieldMap.put(ATTRIBUTE_TARGET, FileInfo.class.getField("isTarget"));
            attrToFieldMap.put(ATTRIBUTE_CONREF_TARGET, FileInfo.class.getField("isConrefTarget"));
            attrToFieldMap.put(ATTRIBUTE_NON_CONREF_TARGET, FileInfo.class.getField("isNonConrefTarget"));
            attrToFieldMap.put(ATTRIBUTE_CONREF_PUSH, FileInfo.class.getField("isConrefPush"));
            attrToFieldMap.put(ATTRIBUTE_SUBJECT_SCHEME, FileInfo.class.getField("isSubjectScheme"));
            attrToFieldMap.put(ATTRIBUTE_COPYTO_SOURCE_LIST, FileInfo.class.getField("isCopyToSource"));
            attrToFieldMap.put(ATTRIBUTE_OUT_DITA_FILES_LIST, FileInfo.class.getField("isOutDita"));
            attrToFieldMap.put(ATTRIBUTE_CHUNKED_DITAMAP_LIST, FileInfo.class.getField("isChunkedDitaMap"));
            attrToFieldMap.put(ATTRIBUTE_FLAG_IMAGE_LIST, FileInfo.class.getField("isFlagImage"));
            attrToFieldMap.put(ATTRIBUTE_SUBSIDIARY_TARGET_LIST, FileInfo.class.getField("isSubtarget"));
            attrToFieldMap.put(ATTRIBUTE_CHUNK_TOPIC_LIST, FileInfo.class.getField("isSkipChunk"));
            attrToFieldMap.put(ATTRIBUTE_ACTIVE, FileInfo.class.getField("isActive"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class FileInfo {
        public final String file;
        public String format;
        public boolean hasConref;
        public boolean isChunked;
        public boolean hasLink;
        public boolean isResourceOnly;
        public boolean isTarget;
        public boolean isConrefTarget;
        public boolean isNonConrefTarget;
        public boolean isConrefPush;
        public boolean hasKeyref;
        public boolean hasCoderef;
        public boolean isSubjectScheme;
        public boolean isSkipChunk;
        public boolean isSubtarget;
        public boolean isFlagImage;
        public boolean isChunkedDitaMap;
        public boolean isOutDita;
        public boolean isCopyToSource;
        public boolean isActive;

        FileInfo(String file) {
            this.file = file;
        }

        public static class Builder {
            private String file;
            private String format;
            private boolean hasConref;
            private boolean isChunked;
            private boolean hasLink;
            private boolean isResourceOnly;
            private boolean isTarget;
            private boolean isConrefTarget;
            private boolean isNonConrefTarget;
            private boolean isConrefPush;
            private boolean hasKeyref;
            private boolean hasCoderef;
            private boolean isSubjectScheme;
            private boolean isSkipChunk;
            private boolean isSubtarget;
            private boolean isFlagImage;
            private boolean isChunkedDitaMap;
            private boolean isOutDita;
            private boolean isCopyToSource;
            private boolean isActive;

            public Builder() {
            }

            public Builder(FileInfo orig) {
                this.file = orig.file;
                this.format = orig.format;
                this.hasConref = orig.hasConref;
                this.isChunked = orig.isChunked;
                this.hasLink = orig.hasLink;
                this.isResourceOnly = orig.isResourceOnly;
                this.isTarget = orig.isTarget;
                this.isConrefTarget = orig.isConrefTarget;
                this.isNonConrefTarget = orig.isNonConrefTarget;
                this.isConrefPush = orig.isConrefPush;
                this.hasKeyref = orig.hasKeyref;
                this.hasCoderef = orig.hasCoderef;
                this.isSubjectScheme = orig.isSubjectScheme;
                this.isSkipChunk = orig.isSkipChunk;
                this.isSubtarget = orig.isSubtarget;
                this.isFlagImage = orig.isFlagImage;
                this.isChunkedDitaMap = orig.isChunkedDitaMap;
                this.isOutDita = orig.isOutDita;
                this.isCopyToSource = orig.isCopyToSource;
                this.isActive = orig.isActive;
            }

            public Builder file(String file) {
                this.file = file;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder hasConref(boolean hasConref) {
                this.hasConref = hasConref;
                return this;
            }

            public Builder isChunked(boolean isChunked) {
                this.isChunked = isChunked;
                return this;
            }

            public Builder hasLink(boolean hasLink) {
                this.hasLink = hasLink;
                return this;
            }

            public Builder isResourceOnly(boolean isResourceOnly) {
                this.isResourceOnly = isResourceOnly;
                return this;
            }

            public Builder isTarget(boolean isTarget) {
                this.isTarget = isTarget;
                return this;
            }

            public Builder isConrefTarget(boolean isConrefTarget) {
                this.isConrefTarget = isConrefTarget;
                return this;
            }

            public Builder isNonConrefTarget(boolean isNonConrefTarget) {
                this.isNonConrefTarget = isNonConrefTarget;
                return this;
            }

            public Builder isConrefPush(boolean isConrefPush) {
                this.isConrefPush = isConrefPush;
                return this;
            }

            public Builder hasKeyref(boolean hasKeyref) {
                this.hasKeyref = hasKeyref;
                return this;
            }

            public Builder hasCoderef(boolean hasCoderef) {
                this.hasCoderef = hasCoderef;
                return this;
            }

            public Builder isSubjectScheme(boolean isSubjectScheme) {
                this.isSubjectScheme = isSubjectScheme;
                return this;
            }

            public Builder isSkipChunk(boolean isSkipChunk) {
                this.isSkipChunk = isSkipChunk;
                return this;
            }

            public Builder isSubtarget(boolean isSubtarget) {
                this.isSubtarget = isSubtarget;
                return this;
            }

            public Builder isFlagImage(boolean isFlagImage) {
                this.isFlagImage = isFlagImage;
                return this;
            }

            public Builder isChunkedDitaMap(boolean isChunkedDitaMap) {
                this.isChunkedDitaMap = isChunkedDitaMap;
                return this;
            }

            public Builder isOutDita(boolean isOutDita) {
                this.isOutDita = isOutDita;
                return this;
            }

            public Builder isCopyToSource(boolean isCopyToSource) {
                this.isCopyToSource = isCopyToSource;
                return this;
            }

            public Builder isActive(boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            public FileInfo build() {
                if (this.file == null) {
                    throw new IllegalArgumentException("file may not be null");
                }
                FileInfo fi = new FileInfo(this.file);
                fi.format = this.format;
                fi.hasConref = this.hasConref;
                fi.isChunked = this.isChunked;
                fi.hasLink = this.hasLink;
                fi.isResourceOnly = this.isResourceOnly;
                fi.isTarget = this.isTarget;
                fi.isConrefTarget = this.isConrefTarget;
                fi.isNonConrefTarget = this.isNonConrefTarget;
                fi.isConrefPush = this.isConrefPush;
                fi.hasKeyref = this.hasKeyref;
                fi.hasCoderef = this.hasCoderef;
                fi.isSubjectScheme = this.isSubjectScheme;
                fi.isSkipChunk = this.isSkipChunk;
                fi.isSubtarget = this.isSubtarget;
                fi.isFlagImage = this.isFlagImage;
                fi.isChunkedDitaMap = this.isChunkedDitaMap;
                fi.isOutDita = this.isOutDita;
                fi.isCopyToSource = this.isCopyToSource;
                fi.isActive = this.isActive;
                return fi;
            }
        }
    }

    private static final class JobHandler
    extends DefaultHandler {
        private final Map<String, Object> prop;
        private final Map<String, FileInfo> files;
        private StringBuilder buf;
        private String name;
        private String key;
        private Set<String> set;
        private Map<String, String> map;

        JobHandler(Map<String, Object> prop, Map<String, FileInfo> files) {
            this.prop = prop;
            this.files = files;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(ch, start, length);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String n;
            String string = n = localName != null ? localName : qName;
            if (n.equals(Job.ELEMENT_PROPERTY)) {
                this.name = atts.getValue(Job.ATTRIBUTE_NAME);
            } else if (n.equals(Job.ELEMENT_STRING)) {
                this.buf = new StringBuilder();
            } else if (n.equals(Job.ELEMENT_SET)) {
                this.set = new HashSet<String>();
            } else if (n.equals(Job.ELEMENT_MAP)) {
                this.map = new HashMap<String, String>();
            } else if (n.equals(Job.ELEMENT_ENTRY)) {
                this.key = atts.getValue(Job.ATTRIBUTE_KEY);
            } else if (n.equals(Job.ELEMENT_FILE)) {
                String path = atts.getValue(Job.ATTRIBUTE_PATH);
                FileInfo i = new FileInfo(path);
                i.format = atts.getValue(Job.ATTRIBUTE_FORMAT);
                try {
                    for (Map.Entry e : attrToFieldMap.entrySet()) {
                        ((Field)e.getValue()).setBoolean(i, Boolean.parseBoolean(atts.getValue((String)e.getKey())));
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                this.files.put(path, i);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String n;
            String string = n = localName != null ? localName : qName;
            if (n.equals(Job.ELEMENT_PROPERTY)) {
                this.name = null;
            } else if (n.equals(Job.ELEMENT_STRING)) {
                if (this.set != null) {
                    this.set.add(this.buf.toString());
                } else if (this.map != null) {
                    this.map.put(this.key, this.buf.toString());
                } else {
                    this.prop.put(this.name, this.buf.toString());
                }
                this.buf = null;
            } else if (n.equals(Job.ELEMENT_SET)) {
                this.prop.put(this.name, this.set);
                this.set = null;
            } else if (n.equals(Job.ELEMENT_MAP)) {
                this.prop.put(this.name, this.map);
                this.map = null;
            } else if (n.equals(Job.ELEMENT_ENTRY)) {
                this.key = null;
            }
        }
    }
}

