/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class KeyDef {
    public static final String ELEMENT_STUB = "stub";
    private static final String ATTRIUBTE_SOURCE = "source";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_SCOPE = "scope";
    private static final String ATTRIBUTE_KEYS = "keys";
    private static final String ELEMENT_KEYDEF = "keydef";
    public final String keys;
    public final String href;
    public final String scope;
    public final String source;

    public KeyDef(String keys, String href, String scope, String source) {
        this.keys = keys;
        this.href = href;
        this.scope = scope;
        this.source = source;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.keys).append("=");
        if (this.href != null) {
            buf.append(this.href);
        }
        if (this.scope != null) {
            buf.append("(").append(this.scope).append(")");
        }
        if (this.source != null) {
            buf.append("(").append(this.source).append(")");
        }
        return buf.toString();
    }

    public static Collection<KeyDef> readKeydef(File keydefFile) throws DITAOTException {
        final ArrayList<KeyDef> res = new ArrayList<KeyDef>();
        try {
            XMLReader parser = StringUtils.getXMLReader();
            parser.setContentHandler(new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    String n;
                    String string = n = localName != null ? localName : qName;
                    if (n.equals(KeyDef.ELEMENT_KEYDEF)) {
                        res.add(new KeyDef(atts.getValue(KeyDef.ATTRIBUTE_KEYS), atts.getValue(KeyDef.ATTRIBUTE_HREF), atts.getValue(KeyDef.ATTRIBUTE_SCOPE), atts.getValue(KeyDef.ATTRIUBTE_SOURCE)));
                    }
                }
            });
            parser.parse(keydefFile.toURI().toString());
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to read key definition file " + keydefFile + ": " + e.getMessage(), e);
        }
        return res;
    }

    public static void writeKeydef(File keydefFile, Collection<KeyDef> keydefs) throws DITAOTException {
        FileOutputStream out = null;
        XMLStreamWriter keydef = null;
        try {
            out = new FileOutputStream(keydefFile);
            keydef = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            keydef.writeStartDocument();
            keydef.writeStartElement(ELEMENT_STUB);
            for (KeyDef k : keydefs) {
                keydef.writeStartElement(ELEMENT_KEYDEF);
                keydef.writeAttribute(ATTRIBUTE_KEYS, k.keys);
                if (k.href != null) {
                    keydef.writeAttribute(ATTRIBUTE_HREF, k.href);
                }
                if (k.scope != null) {
                    keydef.writeAttribute(ATTRIBUTE_SCOPE, k.scope);
                }
                if (k.source != null) {
                    keydef.writeAttribute(ATTRIUBTE_SOURCE, k.source);
                }
                keydef.writeEndElement();
            }
            keydef.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new DITAOTException("Failed to write key definition file " + keydefFile + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to write key definition file " + keydefFile + ": " + e.getMessage(), e);
        }
        finally {
            if (keydef != null) {
                try {
                    keydef.close();
                }
                catch (XMLStreamException e) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {}
            }
        }
    }
}

