/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.TopicIdParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.XMLReader;

public final class MergeUtils {
    private final Hashtable<String, String> idMap = new Hashtable();
    private int index = 0;
    private final Set<String> visitSet = Collections.synchronizedSet(new HashSet(256));

    public void reset() {
        this.idMap.clear();
        this.visitSet.clear();
        this.index = 0;
    }

    public boolean findId(String id) {
        return id != null && this.idMap.containsKey(FileUtils.normalize(FileUtils.separatorsToUnix(id.trim()), "/"));
    }

    public String addId(String id) {
        if (id == null) {
            return null;
        }
        String localId = FileUtils.separatorsToUnix(id.trim());
        ++this.index;
        String newId = "unique_" + Integer.toString(this.index);
        this.idMap.put(FileUtils.normalize(localId, "/"), newId);
        return newId;
    }

    public void addId(String id, String value) {
        if (id != null && value != null) {
            String localId = FileUtils.separatorsToUnix(id.trim());
            String localValue = value.trim();
            this.idMap.put(FileUtils.normalize(localId, "/"), localValue);
        }
    }

    public String getIdValue(String id) {
        if (id == null) {
            return null;
        }
        String localId = FileUtils.separatorsToUnix(id.trim());
        return this.idMap.get(FileUtils.normalize(localId, "/"));
    }

    public boolean isVisited(String path) {
        String localPath = path;
        int idx = path.indexOf("#");
        if (idx != -1) {
            localPath = localPath.substring(0, idx);
        }
        return this.visitSet.contains(FileUtils.normalize(FileUtils.separatorsToUnix(localPath.trim()), "/"));
    }

    public void visit(String path) {
        String localPath = path;
        int idx = path.indexOf("#");
        if (idx != -1) {
            localPath = localPath.substring(0, idx);
        }
        this.visitSet.add(FileUtils.normalize(FileUtils.separatorsToUnix(localPath.trim()), "/"));
    }

    public static String getFirstTopicId(String path, String dir, boolean useCatalog) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        String localPath = path;
        String localDir = dir;
        StringBuffer firstTopicId = new StringBuffer();
        if (path == null || dir == null) {
            return null;
        }
        localPath = localPath.trim();
        localDir = localDir.trim();
        TopicIdParser parser = new TopicIdParser(firstTopicId);
        try {
            XMLReader reader = StringUtils.getXMLReader();
            reader.setContentHandler(parser);
            if (useCatalog) {
                try {
                    Class.forName("org.apache.xml.resolver.tools.CatalogResolver");
                    reader.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
                }
                catch (ClassNotFoundException e) {
                    logger.logError(e.getMessage(), e);
                }
            }
            reader.parse(new File(localDir, localPath).toURI().toString());
        }
        catch (Exception e) {
            logger.logError(e.getMessage(), e);
        }
        return firstTopicId.toString();
    }
}

