/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class StringUtils {
    private static final String NOT_RESOLVE_ENTITY_LIST = "|lt|gt|quot|amp|";
    private static final String NOT_RESOLVE_ENTITY_CHAR = "|#38|";

    private StringUtils() {
    }

    public static String assembleString(Collection coll, String delim) {
        StringBuffer buff = new StringBuffer(256);
        Iterator iter = null;
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        iter = coll.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            buff.append(delim);
        }
        return buff.toString();
    }

    public static String assembleString(Map value, String delim) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Iterator i = value.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            buf.append(((String)e.getKey()).toString()).append("=").append(((String)e.getValue()).toString());
            if (!i.hasNext()) continue;
            buf.append(delim);
        }
        return buf.toString();
    }

    public static String escapeXML(String s) {
        char[] chars = s.toCharArray();
        return StringUtils.escapeXML(chars, 0, chars.length);
    }

    public static String escapeXML(char[] chars, int offset, int length) {
        StringBuffer escaped = new StringBuffer();
        int end = offset + length;
        block7: for (int i = offset; i < end; ++i) {
            char c = chars[i];
            switch (c) {
                case '\'': {
                    escaped.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    escaped.append("&quot;");
                    continue block7;
                }
                case '<': {
                    escaped.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escaped.append("&gt;");
                    continue block7;
                }
                case '&': {
                    escaped.append("&amp;");
                    continue block7;
                }
                default: {
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    public static String getEntity(String name) {
        return name.startsWith("%") ? name + ";" : "&" + name + ";";
    }

    public static boolean checkEntity(String name) {
        return NOT_RESOLVE_ENTITY_LIST.indexOf("|" + name.trim() + "|") == -1 && NOT_RESOLVE_ENTITY_CHAR.indexOf("|" + name.trim() + "|") == -1;
    }

    public static String replaceAll(String input, String pattern, String replacement) {
        StringBuffer result = new StringBuffer();
        int startIndex = 0;
        int newIndex = 0;
        while ((newIndex = input.indexOf(pattern, startIndex)) >= 0) {
            result.append(input.substring(startIndex, newIndex));
            result.append(replacement);
            startIndex = newIndex + pattern.length();
        }
        result.append(input.substring(startIndex));
        return result.toString();
    }

    public static String getAscii(String inStr) {
        byte[] input = inStr.getBytes();
        StringBuffer ret = new StringBuffer(1024);
        String strByte = null;
        for (byte element : input) {
            ret.append("\\'");
            strByte = Integer.toHexString(element);
            ret.append(strByte.substring(strByte.length() - 2));
        }
        return ret.toString();
    }

    public static String[][] getExtProps(String domains) {
        ArrayList<String[]> propsBuffer = new ArrayList<String[]>();
        int propsStart = domains.indexOf("a(props");
        int propsEnd = domains.indexOf(")", propsStart);
        while (propsStart != -1 && propsEnd != -1) {
            String propPath = domains.substring(propsStart + 2, propsEnd).trim();
            StringTokenizer propPathTokenizer = new StringTokenizer(propPath, " ");
            ArrayList<String> propList = new ArrayList<String>(128);
            while (propPathTokenizer.hasMoreTokens()) {
                propList.add(propPathTokenizer.nextToken());
            }
            propsBuffer.add(propList.toArray(new String[propList.size()]));
            propsStart = domains.indexOf("a(props", propsEnd);
            propsEnd = domains.indexOf(")", propsStart);
        }
        return (String[][])propsBuffer.toArray((T[])new String[propsBuffer.size()][]);
    }

    public static Map<String, String> restoreMap(String s) {
        HashMap<String, String> copytoMap = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            int index = entry.indexOf(61);
            copytoMap.put(entry.substring(0, index), entry.substring(index + 1));
        }
        return copytoMap;
    }

    public static Set<String> restoreSet(String s) {
        return StringUtils.restoreSet(s, ",");
    }

    public static Set<String> restoreSet(String s, String delim) {
        HashSet<String> copytoSet = new HashSet<String>();
        if (StringUtils.isEmptyString(s)) {
            return copytoSet;
        }
        StringTokenizer st = new StringTokenizer(s, delim);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (StringUtils.isEmptyString(entry)) continue;
            copytoSet.add(entry);
        }
        return copytoSet;
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String setOrAppend(String target, String value, boolean withSpace) {
        if (target == null) {
            return value;
        }
        if (value == null) {
            return target;
        }
        if (withSpace && !target.endsWith(" ")) {
            return target + " " + value;
        }
        return target + value;
    }

    public static XMLReader getXMLReader() throws SAXException {
        if (System.getProperty("org.xml.sax.driver") != null) {
            return XMLReaderFactory.createXMLReader();
        }
        try {
            Class.forName("org.apache.xerces.parsers.SAXParser");
            return XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.sun.org.apache.xerces.internal.parsers.SAXParser");
                return XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            }
            catch (ClassNotFoundException ex) {
                try {
                    Class.forName("org.apache.crimson.parser.XMLReaderImpl");
                    return XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (ClassNotFoundException exc) {
                    return XMLReaderFactory.createXMLReader();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Locale getLocale(String anEncoding) {
        String subtag2;
        Locale aLocale = null;
        String country = null;
        String language = null;
        String variant = null;
        StringTokenizer tokenizer = new StringTokenizer(anEncoding, "-");
        int numberOfTokens = tokenizer.countTokens();
        if (numberOfTokens == 1) {
            String tempString = tokenizer.nextToken().toLowerCase();
            int underscoreIndex = tempString.indexOf("_");
            if (underscoreIndex == -1) {
                language = tempString;
                return new Locale(language);
            } else {
                if (underscoreIndex != 2) {
                    if (underscoreIndex != 3) return new Locale(language);
                }
                language = tempString.substring(0, underscoreIndex);
            }
            return new Locale(language);
        }
        if (numberOfTokens == 2) {
            language = tokenizer.nextToken().toLowerCase();
            subtag2 = tokenizer.nextToken();
            if (subtag2.length() <= 3) {
                country = subtag2.toUpperCase();
                return new Locale(language, country);
            }
            if (subtag2.length() > 3 && subtag2.length() <= 8) {
                variant = subtag2;
                return new Locale(language, "", variant);
            }
        } else {
            if (numberOfTokens < 3) return new Locale("en", "us");
            language = tokenizer.nextToken().toLowerCase();
            String subtag22 = tokenizer.nextToken();
            if (subtag22.length() <= 3) {
                country = subtag22.toUpperCase();
            } else if (subtag22.length() > 3 && subtag22.length() <= 8) {
                variant = subtag22;
            } else if (subtag22.length() > 8) {
                // empty if block
            }
            variant = tokenizer.nextToken();
            return new Locale(language, country, variant);
        }
        if (subtag2.length() <= 8) return aLocale;
        return aLocale;
    }

    public static String getFileName(String input, String marker) {
        int index = input.lastIndexOf(marker);
        if (index != -1) {
            return input.substring(0, index);
        }
        return input;
    }

    @Deprecated
    public static Integer getMax(String ul_depth, String ol_depth, String sl_depth, String dl_depth, String table_depth, String stable_depth) {
        int unDepth = Integer.parseInt(ul_depth);
        int olDepth = Integer.parseInt(ol_depth);
        int slDepth = Integer.parseInt(sl_depth);
        int dlDepth = Integer.parseInt(dl_depth);
        int tableDepth = Integer.parseInt(table_depth);
        int stableDepth = Integer.parseInt(stable_depth);
        int max = unDepth;
        if (olDepth > max) {
            max = olDepth;
        }
        if (slDepth > max) {
            max = slDepth;
        }
        if (dlDepth > max) {
            max = dlDepth;
        }
        if (tableDepth > max) {
            max = tableDepth;
        }
        if (stableDepth > max) {
            max = stableDepth;
        }
        return max;
    }

    @Deprecated
    public static Integer getMax(String fn_depth, String list_depth, String dlist_depth, String table_depth, String stable_depth) {
        int fnDepth = Integer.parseInt(fn_depth);
        int listDepth = Integer.parseInt(list_depth);
        int dlistDepth = Integer.parseInt(dlist_depth);
        int tableDepth = Integer.parseInt(table_depth);
        int stableDepth = Integer.parseInt(stable_depth);
        int max = fnDepth;
        if (listDepth > max) {
            max = listDepth;
        }
        if (dlistDepth > max) {
            max = dlistDepth;
        }
        if (tableDepth > max) {
            max = tableDepth;
        }
        if (stableDepth > max) {
            max = stableDepth;
        }
        return max;
    }
}

