/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.dita.dost.util.FilePathToURI;

public final class URLUtils {
    private static final boolean[] gNeedEscaping = new boolean[128];
    private static final char[] gAfterEscaping1 = new char[128];
    private static final char[] gAfterEscaping2 = new char[128];
    private static final char[] gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URLUtils() {
    }

    public static URL correct(File file) throws MalformedURLException {
        if (file == null) {
            throw new MalformedURLException("The url is null");
        }
        return new URL(URLUtils.correct(file.toURL().toString(), true));
    }

    public static URL correct(URL url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("The url is null");
        }
        return new URL(URLUtils.correct(url.toString(), false));
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String uncorrect(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuffer sbuf = new StringBuffer();
        int l = s.length();
        int ch = -1;
        int b = 0;
        int sumb = 0;
        boolean applyUTF8dec = false;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            char current = s.charAt(i);
            ch = current;
            switch (ch) {
                case 37: {
                    if (i + 2 >= s.length()) break;
                    int hb = (Character.isDigit((char)(ch = (int)s.charAt(++i))) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    applyUTF8dec = true;
                    break;
                }
                default: {
                    b = ch;
                    applyUTF8dec = false;
                }
            }
            if (applyUTF8dec) {
                if ((b & 0xC0) == 128) {
                    sumb = sumb << 6 | b & 0x3F;
                    if (--more != 0) continue;
                    sbuf.append((char)sumb);
                    continue;
                }
                if ((b & 0x80) == 0) {
                    sbuf.append((char)b);
                    continue;
                }
                if ((b & 0xE0) == 192) {
                    sumb = b & 0x1F;
                    more = 1;
                    continue;
                }
                if ((b & 0xF0) == 224) {
                    sumb = b & 0xF;
                    more = 2;
                    continue;
                }
                if ((b & 0xF8) == 240) {
                    sumb = b & 7;
                    more = 3;
                    continue;
                }
                if ((b & 0xFC) == 248) {
                    sumb = b & 3;
                    more = 4;
                    continue;
                }
                sumb = b & 1;
                more = 5;
                continue;
            }
            sbuf.append(current);
            more = -1;
        }
        return sbuf.toString();
    }

    public static File getCanonicalFileFromFileUrl(URL url) {
        File file = null;
        if (url == null) {
            throw new NullPointerException("The URL cannot be null.");
        }
        if ("file".equals(url.getProtocol())) {
            String fileName = url.getFile();
            String path = URLUtils.uncorrect(fileName);
            file = new File(path);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }

    public static String correct(String url, boolean forceCorrection) {
        int queryIndex;
        int refIndex;
        if (url == null) {
            return null;
        }
        String initialUrl = url;
        if (!forceCorrection && url.indexOf("%") != -1) {
            return initialUrl;
        }
        String reference = null;
        if (!forceCorrection && (refIndex = url.lastIndexOf(35)) != -1) {
            reference = FilePathToURI.filepath2URI(url.substring(refIndex + 1));
            url = url.substring(0, refIndex);
        }
        StringBuffer queryBuffer = null;
        if (!forceCorrection && (queryIndex = url.indexOf(63)) != -1) {
            String query = url.substring(queryIndex + 1);
            url = url.substring(0, queryIndex);
            queryBuffer = new StringBuffer(query.length());
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                token = FilePathToURI.filepath2URI(token);
                queryBuffer.append(token);
                if (!st.hasMoreElements()) continue;
                queryBuffer.append("&");
            }
        }
        String toReturn = FilePathToURI.filepath2URI(url);
        if (queryBuffer != null) {
            toReturn = toReturn + "?" + queryBuffer.toString();
        }
        if (reference != null) {
            toReturn = toReturn + "#" + reference;
        }
        return toReturn;
    }

    public static String getURL(String fileName) {
        if (fileName.startsWith("file:/")) {
            return fileName;
        }
        File file = new File(fileName);
        try {
            return file.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static String clean(String path) {
        return URLUtils.clean(path, true);
    }

    public static String clean(String path, boolean ascii) {
        int i;
        int ch;
        int len = path.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        if (len >= 2 && path.charAt(1) == ':' && (ch = Character.toUpperCase(path.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        for (i = 0; !(i >= len || (ch = path.charAt(i)) >= 128 && ascii); ++i) {
            if (ch < gNeedEscaping.length && gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len && ascii) {
            byte[] bytes;
            try {
                bytes = path.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (byte b : bytes) {
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            URLUtils.gNeedEscaping[i] = true;
            URLUtils.gAfterEscaping1[i] = gHexChs[i >> 4];
            URLUtils.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        URLUtils.gNeedEscaping[127] = true;
        URLUtils.gAfterEscaping1[127] = 55;
        URLUtils.gAfterEscaping2[127] = 70;
        for (char ch : new char[]{' ', '<', '>', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`', '\''}) {
            URLUtils.gNeedEscaping[ch] = true;
            URLUtils.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            URLUtils.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

