/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static void addOrSetAttribute(AttributesImpl atts, String uri, String localName, String qName, String type, String value) {
        int i = atts.getIndex(qName);
        if (i != -1) {
            atts.setAttribute(i, uri, localName, qName, type, value);
        } else {
            atts.addAttribute(uri, localName, qName, type, value);
        }
    }

    public static void addOrSetAttribute(AttributesImpl atts, String localName, String value) {
        XMLUtils.addOrSetAttribute(atts, "", localName, localName, "CDATA", value);
    }

    public static void addOrSetAttribute(AttributesImpl atts, Node att) {
        int i;
        if (att.getNodeType() != 2) {
            throw new IllegalArgumentException();
        }
        Attr a = (Attr)att;
        String localName = a.getLocalName();
        if (localName == null && (i = (localName = a.getName()).indexOf(58)) != -1) {
            localName = localName.substring(i + 1);
        }
        XMLUtils.addOrSetAttribute(atts, a.getNamespaceURI() != null ? a.getNamespaceURI() : "", localName, a.getName() != null ? a.getName() : localName, a.isId() ? "ID" : "CDATA", a.getValue());
    }

    public static void removeAttribute(AttributesImpl atts, String qName) {
        int i = atts.getIndex(qName);
        if (i != -1) {
            atts.removeAttribute(i);
        }
    }

    public static String getStringValue(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList children = element.getChildNodes();
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 3: {
                    buf.append(n.getNodeValue());
                    continue block4;
                }
                case 1: {
                    buf.append(XMLUtils.getStringValue((Element)n));
                }
            }
        }
        return buf.toString();
    }

    public static void transform(File inputFile, List<XMLFilter> filters) throws DITAOTException {
        File outputFile = new File(inputFile.getAbsolutePath() + ".temp");
        InputStream in = null;
        OutputStream out = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            XMLReader reader = StringUtils.getXMLReader();
            for (XMLFilter filter : filters) {
                filter.setContentHandler(null);
                filter.setParent(reader);
                reader = filter;
            }
            in = new BufferedInputStream(new FileInputStream(inputFile));
            out = new BufferedOutputStream(new FileOutputStream(outputFile));
            SAXSource source = new SAXSource(reader, new InputSource(in));
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to transform " + inputFile + ": " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            if (!inputFile.delete()) {
                throw new DITAOTException("Failed to delete " + outputFile);
            }
            if (!outputFile.renameTo(inputFile)) {
                throw new DITAOTException("Failed to move " + inputFile);
            }
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to replace " + inputFile + ": " + e.getMessage());
        }
    }

    public static final class AttributesBuilder {
        final AttributesImpl atts;

        public AttributesBuilder() {
            this.atts = new AttributesImpl();
        }

        public AttributesBuilder(Attributes atts) {
            this.atts = new AttributesImpl(atts);
        }

        public AttributesBuilder add(String uri, String localName, String qName, String type, String value) {
            int i = this.atts.getIndex(uri, localName);
            if (i != -1) {
                this.atts.setAttribute(i, uri, localName, qName, type, value);
            } else {
                this.atts.addAttribute(uri, localName, qName, type, value);
            }
            return this;
        }

        public AttributesBuilder add(String localName, String value) {
            return this.add("", localName, localName, "CDATA", value);
        }

        public AttributesBuilder add(String uri, String localName, String value) {
            return this.add(uri, localName, localName, "CDATA", value);
        }

        public void addAll(Attributes attrs) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
            }
        }

        public Attributes build() {
            return new AttributesImpl(this.atts);
        }
    }
}

