/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.util.XMLSerializer;
import org.dita.dost.writer.AbstractExtendDitaWriter;
import org.xml.sax.SAXException;

public final class CHMIndexWriter
extends AbstractExtendDitaWriter {
    @Override
    public void write(String filename) throws DITAOTException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            XMLSerializer serializer = XMLSerializer.newInstance(out);
            Transformer transformer = serializer.getTransformerHandler().getTransformer();
            transformer.setOutputProperty("doctype-public", "-//IETF//DTD HTML//EN");
            transformer.setOutputProperty("method", "html");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            serializer.writeStartDocument();
            serializer.writeStartElement("html");
            serializer.writeStartElement("head");
            serializer.writeStartElement("meta");
            serializer.writeAttribute("name", "GENERATOR");
            serializer.writeAttribute("content", "Microsoft\u00ae HTML Help Workshop 4.1");
            serializer.writeEndElement();
            serializer.writeComment("Sitemap 1.0");
            serializer.writeEndElement();
            serializer.writeStartElement("body");
            serializer.writeStartElement("ul");
            int termNum = this.termList.size();
            for (int i = 0; i < termNum; ++i) {
                IndexTerm term = (IndexTerm)this.termList.get(i);
                this.outputIndexTerm(term, serializer);
            }
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndDocument();
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    private void outputIndexTerm(IndexTerm term, XMLSerializer serializer) throws SAXException {
        int i;
        List<IndexTermTarget> targets = term.getTargetList();
        List<IndexTerm> subTerms = term.getSubTerms();
        int targetNum = targets.size();
        int subTermNum = subTerms.size();
        serializer.writeStartElement("li");
        serializer.writeStartElement("object");
        serializer.writeAttribute("type", "text/sitemap");
        serializer.writeStartElement("param");
        serializer.writeAttribute("name", "Name");
        serializer.writeAttribute("value", term.getTermFullName());
        serializer.writeEndElement();
        if (targets == null || targets.isEmpty()) {
            this.findTargets(term);
            targets = term.getTargetList();
            targetNum = targets.size();
        }
        for (i = 0; i < targetNum; ++i) {
            IndexTermTarget target = targets.get(i);
            serializer.writeStartElement("param");
            serializer.writeAttribute("name", "Name");
            serializer.writeAttribute("value", target.getTargetName());
            serializer.writeEndElement();
            serializer.writeStartElement("param");
            serializer.writeAttribute("name", "Local");
            serializer.writeAttribute("value", target.getTargetURI());
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
        if (subTerms != null && subTermNum > 0) {
            serializer.writeStartElement("ul");
            for (i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = subTerms.get(i);
                this.outputIndexTerm(subTerm, serializer);
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void findTargets(IndexTerm term) {
        List<IndexTerm> subTerms = term.getSubTerms();
        List<IndexTermTarget> subTargets = null;
        if (subTerms != null && !subTerms.isEmpty()) {
            for (int i = 0; i < subTerms.size(); ++i) {
                IndexTerm subTerm = subTerms.get(i);
                subTargets = subTerm.getTargetList();
                if (subTargets != null && !subTargets.isEmpty()) {
                    term.addTargets(subTerm.getTargetList());
                } else {
                    this.findTargets(subTerm);
                }
                term.addTargets(subTerm.getTargetList());
            }
        }
    }

    @Override
    public String getIndexFileName(String outputFileRoot) {
        StringBuffer indexFilename = new StringBuffer(outputFileRoot);
        indexFilename.append(".hhk");
        return indexFilename.toString();
    }
}

